/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxCombatGoal
extends Goal {
    private final Raevyx wyvern;
    private final double biteRange = 3.0;
    private final double goreRange = 4.5;
    private final double chaseSpeed = 1.4;
    private int attackCooldown = 0;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;

    public RaevyxCombatGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.wyvern.m_20160_() || this.wyvern.m_21827_()) {
            return false;
        }
        return !(this.wyvern.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_8045_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.wyvern.m_20160_() || this.wyvern.m_21827_()) {
            return false;
        }
        return !(this.wyvern.m_20280_((Entity)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.setRunning(false);
        this.wyvern.m_21561_(false);
        this.pathRecalcCooldown = 0;
    }

    public void m_8056_() {
        this.wyvern.setRunning(true);
        this.wyvern.m_21561_(true);
        LivingEntity target = this.wyvern.m_5448_();
        if (target != null) {
            this.wyvern.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.wyvern.m_21573_().m_5624_((Entity)target, 1.4);
            this.rememberTargetPosition(target);
            this.tryAttack(target);
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if ((target = this.wyvern.m_5448_()) != null) {
            this.wyvern.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double gap = this.getGapToTarget(target);
            boolean hasLineOfSight = this.wyvern.m_21574_().m_148306_((Entity)target);
            if (gap > 4.5 || !hasLineOfSight) {
                if (!this.isCurrentlyAttacking()) {
                    this.updateChasePath(target);
                }
            } else {
                this.wyvern.m_21573_().m_26573_();
                this.pathRecalcCooldown = 0;
                this.tryAttack(target);
            }
        }
    }

    private boolean isCurrentlyAttacking() {
        return this.wyvern.isAbilityActive(RaevyxAbilities.RAEVYX_BITE) || this.wyvern.isAbilityActive(RaevyxAbilities.RAEVYX_HORN_GORE);
    }

    private void tryAttack(LivingEntity target) {
        if (this.attackCooldown > 0 || this.isCurrentlyAttacking()) {
            return;
        }
        if (!this.wyvern.m_21574_().m_148306_((Entity)target)) {
            return;
        }
        double gap = this.getGapToTarget(target);
        if (gap <= 3.0) {
            this.wyvern.combatManager.tryUseAbility(RaevyxAbilities.RAEVYX_BITE);
            this.attackCooldown = 20;
        } else if (gap <= 4.5) {
            this.wyvern.combatManager.tryUseAbility(RaevyxAbilities.RAEVYX_HORN_GORE);
            this.attackCooldown = 20;
        }
    }

    private double getGapToTarget(LivingEntity target) {
        double centerDistance = this.wyvern.m_20270_((Entity)target);
        double combinedRadii = (double)(this.wyvern.m_20205_() + target.m_20205_()) * 0.5;
        return Math.max(0.0, centerDistance - combinedRadii);
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.wyvern.m_21133_(Attributes.f_22277_);
        if (followRange <= 0.0) {
            followRange = 32.0;
        }
        return followRange * followRange;
    }

    private void updateChasePath(LivingEntity target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.wyvern.m_20270_((Entity)target);
            this.pathRecalcCooldown = Mth.m_14045_((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.wyvern.m_21573_().m_5624_((Entity)target, 1.4);
        }
    }

    private void rememberTargetPosition(LivingEntity target) {
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    private boolean targetMovedSignificantly(LivingEntity target) {
        double dz;
        double dy;
        double dx = target.m_20185_() - this.lastTargetX;
        return dx * dx + (dy = target.m_20186_() - this.lastTargetY) * dy + (dz = target.m_20189_() - this.lastTargetZ) * dz > 4.0;
    }
}

