/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.AABB;

public class RaevyxTemptGoal
extends Goal {
    private final Raevyx dragon;
    private final double speedModifier;
    private final Ingredient items;
    private final boolean canScare;
    private int consumptionCooldown = 0;
    private ItemEntity targetFish = null;

    public RaevyxTemptGoal(Raevyx dragon, double speedModifier, Ingredient items, boolean canScare) {
        this.dragon = dragon;
        this.speedModifier = speedModifier;
        this.items = items;
        this.canScare = canScare;
    }

    public boolean m_8036_() {
        if (this.dragon.m_5803_() || this.dragon.isDying() || this.dragon.m_20160_()) {
            return false;
        }
        return this.findNearestFish() != null;
    }

    private ItemEntity findNearestFish() {
        AABB broadphase = this.dragon.m_20191_().m_82377_(12.0, 12.0, 12.0);
        List nearbyItems = this.dragon.m_9236_().m_6443_(ItemEntity.class, broadphase, item -> this.dragon.m_6898_(item.m_32055_()));
        if (nearbyItems.isEmpty()) {
            return null;
        }
        return nearbyItems.stream().min((i1, i2) -> Double.compare(this.dragon.m_20280_((Entity)i1), this.dragon.m_20280_((Entity)i2))).orElse(null);
    }

    public void m_8056_() {
        this.targetFish = this.findNearestFish();
        if (this.targetFish != null) {
            this.dragon.m_21573_().m_5624_((Entity)this.targetFish, this.speedModifier);
        }
    }

    public void m_8041_() {
        this.targetFish = null;
        this.dragon.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        if (this.targetFish == null || !this.targetFish.m_6084_()) {
            return false;
        }
        return !(this.dragon.m_20280_((Entity)this.targetFish) > 144.0);
    }

    public void m_8037_() {
        double distance;
        if (this.consumptionCooldown > 0) {
            --this.consumptionCooldown;
        }
        if (!this.dragon.m_9236_().f_46443_ && this.consumptionCooldown <= 0 && this.targetFish != null && (distance = this.dragon.m_20280_((Entity)this.targetFish)) <= 2.25) {
            this.handleFishConsumption(this.targetFish);
            this.consumptionCooldown = 20;
            this.targetFish = null;
        }
    }

    private void handleFishConsumption(ItemEntity fishItem) {
        if (fishItem == null || !fishItem.m_6084_()) {
            return;
        }
        Player feedingPlayer = this.findNearestPlayer();
        fishItem.m_146870_();
        this.dragon.triggerAnim("action", "eat");
        this.dragon.m_5496_(ModSounds.RAEVYX_CHUFF.get(), 1.0f, 1.0f + this.dragon.m_217043_().m_188501_() * 0.3f);
        if (this.dragon.m_21824_()) {
            float healAmount = 10.0f;
            float oldHealth = this.dragon.m_21223_();
            float newHealth = Math.min(oldHealth + healAmount, this.dragon.m_21233_());
            this.dragon.m_21153_(newHealth);
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
            this.sendFeedingMessage(feedingPlayer, newHealth);
        } else if (feedingPlayer != null && this.dragon.m_217043_().m_188503_(10) == 0) {
            this.dragon.m_21828_(feedingPlayer);
            this.dragon.m_21839_(true);
            this.dragon.setCommandManual(1);
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
            if (feedingPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)feedingPlayer;
                Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_lightning_dragon"));
                if (advancement != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "tame_lightning_dragon");
                }
            }
        } else {
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)6);
        }
    }

    private Player findNearestPlayer() {
        List nearbyPlayers = this.dragon.m_9236_().m_6443_(Player.class, this.dragon.m_20191_().m_82400_(10.0), player -> player.m_6084_() && !player.m_5833_());
        if (nearbyPlayers.isEmpty()) {
            return null;
        }
        return nearbyPlayers.stream().min((p1, p2) -> Double.compare(this.dragon.m_20280_((Entity)p1), this.dragon.m_20280_((Entity)p2))).orElse(null);
    }

    private void sendFeedingMessage(Player player, float newHealth) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String messageKey = newHealth >= this.dragon.m_21233_() ? "entity.saintsdragons.raevyx.fed" : "entity.saintsdragons.raevyx.fed_partial";
            serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.dragon.m_7755_()}), true);
        }
    }
}

