/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class StegonautFleeFromPredatorsGoal
extends Goal {
    private final Stegonaut stegonaut;
    private final double fleeSpeed;
    private final double detectionRange;
    private LivingEntity threatEntity;
    private Path fleePath;
    private int fleeTimer;
    private static final int FLEE_DURATION = 100;
    private static final double MIN_FLEE_DISTANCE = 16.0;

    public StegonautFleeFromPredatorsGoal(Stegonaut stegonaut, double fleeSpeed, double detectionRange) {
        this.stegonaut = stegonaut;
        this.fleeSpeed = fleeSpeed;
        this.detectionRange = detectionRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.stegonaut.m_5803_() || this.stegonaut.isDying() || this.stegonaut.m_20072_()) {
            return false;
        }
        if (this.stegonaut.m_21827_()) {
            return false;
        }
        List nearbyEntities = this.stegonaut.m_9236_().m_6443_(LivingEntity.class, this.stegonaut.m_20191_().m_82400_(this.detectionRange), entity -> entity.m_6084_() && this.isThreateningEntity((LivingEntity)entity));
        if (nearbyEntities.isEmpty()) {
            return false;
        }
        LivingEntity closestThreat = null;
        double closestDistSq = Double.MAX_VALUE;
        for (LivingEntity entity2 : nearbyEntities) {
            double distSq = this.stegonaut.m_20280_((Entity)entity2);
            if (!(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestThreat = entity2;
        }
        if (closestThreat == null) {
            return false;
        }
        Vec3 fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this.stegonaut, (int)16, (int)7, (Vec3)closestThreat.m_20182_());
        if (fleePos == null) {
            return false;
        }
        if (closestThreat.m_20275_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_) < closestDistSq) {
            return false;
        }
        PathNavigation navigation = this.stegonaut.m_21573_();
        Path path = navigation.m_26524_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 0);
        if (path == null || !path.m_77403_()) {
            return false;
        }
        this.threatEntity = closestThreat;
        this.fleePath = path;
        return true;
    }

    public boolean m_8045_() {
        if (this.stegonaut.m_5803_() || this.stegonaut.m_20072_()) {
            return false;
        }
        if (this.threatEntity != null && this.stegonaut.m_20280_((Entity)this.threatEntity) > 256.0) {
            return false;
        }
        if (this.threatEntity == null || !this.threatEntity.m_6084_() || this.threatEntity.m_213877_()) {
            return false;
        }
        return this.fleeTimer <= 100;
    }

    public void m_8056_() {
        if (this.fleePath != null) {
            this.stegonaut.m_21573_().m_26536_(this.fleePath, this.fleeSpeed);
        }
        this.fleeTimer = 0;
    }

    public void m_8041_() {
        this.threatEntity = null;
        this.fleePath = null;
        this.fleeTimer = 0;
        this.stegonaut.m_21573_().m_26573_();
    }

    public void m_8037_() {
        Vec3 fleePos;
        ++this.fleeTimer;
        if (this.threatEntity != null && this.threatEntity.m_6084_() && this.fleeTimer % 20 == 0 && (fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this.stegonaut, (int)16, (int)7, (Vec3)this.threatEntity.m_20182_())) != null) {
            this.stegonaut.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, this.fleeSpeed);
        }
    }

    private boolean isThreateningEntity(LivingEntity entity) {
        if (entity instanceof Raevyx) {
            Raevyx raevyx = (Raevyx)entity;
            if (this.stegonaut.m_21824_()) {
                return !raevyx.m_21824_();
            }
            return true;
        }
        if (entity instanceof Stegonaut) {
            Stegonaut otherStegonaut = (Stegonaut)entity;
            if (otherStegonaut == this.stegonaut) {
                return false;
            }
            return !this.stegonaut.m_21824_() || !otherStegonaut.m_21824_();
        }
        return false;
    }
}

