/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NulljawClawAbility
extends DragonAbility<Nulljaw> {
    private static final float BASE_DAMAGE = 12.0f;
    private static final double BASE_RANGE = 5.0;
    private static final double RIDDEN_RANGE_BONUS = 1.5;
    private static final double CLAW_ANGLE_DEG = 100.0;
    private static final double CLAW_SWIPE_HORIZONTAL = 4.0;
    private static final double CLAW_SWIPE_HORIZONTAL_RIDDEN = 3.0;
    private static final double CLAW_SWIPE_VERTICAL = 4.0;
    private static final double BLOCK_BREAK_RANGE = 6.0;
    private static final double BLOCK_BREAK_WIDTH = 3.0;
    private static final double BLOCK_BREAK_HEIGHT = 4.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 1), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 2)};
    private boolean appliedHit;
    private final boolean useLeftClaw;

    public NulljawClawAbility(DragonAbilityType<Nulljaw, NulljawClawAbility> type, Nulljaw user) {
        super(type, user, TRACK, 3);
        this.useLeftClaw = user.shouldUseLeftClaw();
        user.toggleClawSide();
    }

    @Override
    public boolean tryAbility() {
        return ((Nulljaw)this.getUser()).isPhaseTwoActive();
    }

    @Override
    public boolean isOverlayAbility() {
        return true;
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            String animName = this.useLeftClaw ? "claw_left" : "claw_right";
            dragon.triggerAnim("action", animName);
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            List<LivingEntity> targets = this.findAllTargets();
            for (LivingEntity target : targets) {
                this.applyHit(dragon, target);
            }
            if (dragon.m_20160_()) {
                this.breakBlocksInPath(dragon);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Nulljaw dragon, LivingEntity target) {
        double value;
        float damage = 12.0f;
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            damage = (float)(value * 1.2);
        }
        DamageSource source = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        target.m_6469_(source, damage);
    }

    private void breakBlocksInPath(Nulljaw dragon) {
        Level level = dragon.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 mouth = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        Vec3 start = mouth;
        Vec3 end = mouth.m_82549_(look.m_82490_(6.0));
        AABB breakArea = new AABB(start, end).m_82377_(3.0, 4.0, 3.0);
        BlockPos minPos = new BlockPos((int)Math.floor(breakArea.f_82288_), (int)Math.floor(breakArea.f_82289_), (int)Math.floor(breakArea.f_82290_));
        BlockPos maxPos = new BlockPos((int)Math.ceil(breakArea.f_82291_), (int)Math.ceil(breakArea.f_82292_), (int)Math.ceil(breakArea.f_82293_));
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = minPos.m_123341_(); x <= maxPos.m_123341_(); ++x) {
            for (int y = minPos.m_123342_(); y <= maxPos.m_123342_(); ++y) {
                for (int z = minPos.m_123343_(); z <= maxPos.m_123343_(); ++z) {
                    BlockState state;
                    cursor.m_122178_(x, y, z);
                    if (!server.m_46749_((BlockPos)cursor) || (state = server.m_8055_((BlockPos)cursor)).m_60795_() || !this.canBreakBlock(state)) continue;
                    server.m_46953_((BlockPos)cursor, true, (Entity)dragon);
                }
            }
        }
    }

    private boolean canBreakBlock(BlockState state) {
        if (state.m_278721_()) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)((Nulljaw)this.getUser()).m_9236_(), BlockPos.f_121853_);
        if (hardness < 0.0f) {
            return false;
        }
        return hardness <= 30.0f;
    }

    private double getEffectiveRange() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        double range = 5.0;
        if (dragon.m_6688_() != null) {
            range += 1.5;
        }
        return range;
    }

    private List<LivingEntity> findAllTargets() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        Vec3 mouth = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        boolean ridden = dragon.m_6688_() != null;
        double effectiveRange = this.getEffectiveRange();
        double horizontalInflate = ridden ? 3.0 : 4.0;
        AABB forwardSweep = new AABB(mouth, mouth.m_82549_(look.m_82490_(effectiveRange))).m_82377_(horizontalInflate, 4.0, horizontalInflate);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, forwardSweep, e -> e != dragon && e.m_6084_() && e.m_5789_() && !dragon.isAlly((Entity)e));
        double cosLimit = Math.cos(Math.toRadians(100.0));
        ArrayList<LivingEntity> validTargets = new ArrayList<LivingEntity>();
        for (LivingEntity e2 : candidates) {
            boolean goodAngle;
            Vec3 dir;
            double dot;
            Vec3 toward;
            double len;
            double distToAabb = NulljawClawAbility.distancePointToAABB(mouth, e2.m_20191_());
            if (distToAabb > effectiveRange + 0.5 || (len = (toward = NulljawClawAbility.closestPointOnAABB(mouth, e2.m_20191_()).m_82546_(mouth)).m_82553_()) <= 1.0E-4 || (dot = (dir = toward.m_82490_(1.0 / len)).m_82526_(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.4;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.7;
            }
            if (!veryClose && !goodAngle) continue;
            validTargets.add(e2);
        }
        return validTargets;
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static Vec3 closestPointOnAABB(Vec3 p, AABB box) {
        double cx = Mth.m_14008_((double)p.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double cy = Mth.m_14008_((double)p.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double cz = Mth.m_14008_((double)p.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(cx, cy, cz);
    }
}

