/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NulljawRoarAbility
extends DragonAbility<Nulljaw> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 85), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 9)};
    private static final int SOUND_DELAY_TICKS = 3;
    private static final int ROAR_TOTAL_TICKS = 100;
    private static final int FIRST_SWIPE_TICK = 16;
    private static final int SECOND_SWIPE_TICK = 26;
    private static final int THIRD_SWIPE_TICK = 33;
    private static final int FOURTH_SWIPE_TICK = 43;
    private static final int FIFTH_SWIPE_TICK = 49;
    private static final int SIXTH_SWIPE_TICK = 60;
    private static final int SEVENTH_SWIPE_TICK = 89;
    private static final float BASE_CLAW_DAMAGE = 12.0f;
    private static final double CLAW_RANGE = 5.0;
    private static final double CLAW_RANGE_RIDDEN_BONUS = 1.5;
    private static final double CLAW_HORIZONTAL = 4.0;
    private static final double CLAW_HORIZONTAL_RIDDEN = 3.0;
    private static final double CLAW_VERTICAL = 4.0;
    private static final double CLAW_ANGLE_DEG = 100.0;
    private boolean soundQueued = false;
    private boolean[] swipesApplied = new boolean[7];

    public NulljawRoarAbility(DragonAbilityType<Nulljaw, NulljawRoarAbility> type, Nulljaw user) {
        super(type, user, TRACK, 20);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            String trigger = dragon.isPhaseTwoActive() ? "roar2" : "roar";
            dragon.triggerAnim("action", trigger);
            this.soundQueued = true;
            dragon.lockAbilities(100);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.soundQueued = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Nulljaw dragon = (Nulljaw)this.getUser();
        if (this.soundQueued && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() >= 3) {
            if (!dragon.m_9236_().f_46443_) {
                Vec3 mouth = dragon.getMouthPosition();
                boolean phaseTwo = dragon.isPhaseTwoActive();
                float basePitch = phaseTwo ? 0.8f : 1.0f;
                float volume = phaseTwo ? 1.8f : 1.4f;
                float pitch = basePitch + dragon.m_217043_().m_188501_() * 0.1f;
                dragon.m_9236_().m_6263_(null, mouth.f_82479_, mouth.f_82480_, mouth.f_82481_, ModSounds.NULLJAW_ROAR.get(), SoundSource.NEUTRAL, volume, pitch);
            }
            this.soundQueued = false;
        }
        if (!dragon.isPhaseTwoActive() && this.getTicksInUse() >= 3 && !dragon.m_9236_().f_46443_) {
            dragon.triggerScreenShake(0.8f);
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !dragon.m_9236_().f_46443_ && dragon.isPhaseTwoActive()) {
            int ticks = this.getTicksInSection();
            if (!this.swipesApplied[0] && ticks >= 16) {
                this.applyRoarSwipe(dragon, 1);
                this.swipesApplied[0] = true;
            }
            if (!this.swipesApplied[1] && ticks >= 26) {
                this.applyRoarSwipe(dragon, 2);
                this.swipesApplied[1] = true;
            }
            if (!this.swipesApplied[2] && ticks >= 33) {
                this.applyRoarSwipe(dragon, 3);
                this.swipesApplied[2] = true;
            }
            if (!this.swipesApplied[3] && ticks >= 43) {
                this.applyRoarSwipe(dragon, 4);
                this.swipesApplied[3] = true;
            }
            if (!this.swipesApplied[4] && ticks >= 49) {
                this.applyRoarSwipe(dragon, 5);
                this.swipesApplied[4] = true;
            }
            if (!this.swipesApplied[5] && ticks >= 60) {
                this.applyRoarSwipe(dragon, 6);
                this.swipesApplied[5] = true;
            }
            if (!this.swipesApplied[6] && ticks >= 89) {
                this.applyRoarSwipe(dragon, 7);
                if (!dragon.m_9236_().f_46443_) {
                    dragon.triggerScreenShake(1.0f);
                }
                this.swipesApplied[6] = true;
            }
        }
    }

    private void applyRoarSwipe(Nulljaw dragon, int swipeNumber) {
        List<LivingEntity> targets;
        float swipeIntensity = 0.8f;
        if (!dragon.m_9236_().f_46443_) {
            dragon.triggerScreenShake(swipeIntensity);
        }
        if ((targets = this.findClawTargets(dragon)).isEmpty()) {
            return;
        }
        float damageMultiplier = swipeNumber == 7 ? 2.0f : 1.0f;
        float damage = this.computeClawDamage(dragon) * damageMultiplier;
        DamageSource source = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        Vec3 push = dragon.m_20154_().m_82490_(0.5);
        for (LivingEntity target : targets) {
            target.m_6469_(source, damage);
            target.m_5997_(push.f_82479_, 0.15, push.f_82481_);
        }
    }

    private float computeClawDamage(Nulljaw dragon) {
        double value;
        float damage = 12.0f;
        AttributeInstance attack = dragon.m_21051_(Attributes.f_22281_);
        if (attack != null && (value = attack.m_22135_()) > 0.0) {
            damage = (float)(value * 1.2);
        }
        return damage;
    }

    private List<LivingEntity> findClawTargets(Nulljaw dragon) {
        Vec3 origin = dragon.getMouthPosition();
        Vec3 forward = dragon.m_20154_().m_82541_();
        boolean ridden = dragon.m_6688_() != null;
        double range = 5.0 + (ridden ? 1.5 : 0.0);
        double horizontal = ridden ? 3.0 : 4.0;
        AABB sweep = new AABB(origin, origin.m_82549_(forward.m_82490_(range))).m_82377_(horizontal, 4.0, horizontal);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, sweep, entity -> entity != dragon && entity.m_6084_() && entity.m_5789_() && !dragon.isAlly((Entity)entity));
        double cosLimit = Math.cos(Math.toRadians(100.0));
        ArrayList<LivingEntity> valid = new ArrayList<LivingEntity>();
        for (LivingEntity candidate : candidates) {
            boolean goodAngle;
            Vec3 dir;
            double dot;
            Vec3 toward;
            double len;
            double distance = NulljawRoarAbility.distancePointToAABB(origin, candidate.m_20191_());
            if (distance > range + 0.5 || (len = (toward = NulljawRoarAbility.closestPointOnAABB(origin, candidate.m_20191_()).m_82546_(origin)).m_82553_()) <= 1.0E-4 || (dot = (dir = toward.m_82490_(1.0 / len)).m_82526_(forward)) <= 0.0) continue;
            boolean veryClose = distance < range * 0.4;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.7;
            }
            if (!veryClose && !goodAngle) continue;
            valid.add(candidate);
        }
        return valid;
    }

    private static double distancePointToAABB(Vec3 point, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - point.f_82479_, 0.0), point.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - point.f_82480_, 0.0), point.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - point.f_82481_, 0.0), point.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static Vec3 closestPointOnAABB(Vec3 point, AABB box) {
        double cx = Mth.m_14008_((double)point.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double cy = Mth.m_14008_((double)point.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double cz = Mth.m_14008_((double)point.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(cx, cy, cz);
    }
}

