/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import com.leon.saintsdragons.common.network.DragonAnimTickets;
import com.leon.saintsdragons.common.registry.DragonType;
import com.leon.saintsdragons.common.registry.Element;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.controller.DragonBodyControl;
import com.leon.saintsdragons.server.entity.controller.DragonLookControl;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import com.leon.saintsdragons.server.entity.handler.DragonCombatHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.util.math.SmoothValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class DragonEntity
extends TamableAnimal
implements GeoEntity {
    protected static final EntityDataAccessor<Integer> DATA_COMMAND = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_SIT_PROGRESS = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> DATA_GENDER = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> DATA_BODY_DEVIATION = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH_DEVIATION = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_YAW_VELOCITY = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private DragonAbility<?> activeAbility = null;
    public final DragonCombatHandler combatManager;
    public final DragonAllyManager allyManager;
    public float sitProgress = 0.0f;
    public float prevSitProgress = 0.0f;
    private boolean dying = false;
    private boolean genderInitialized = false;
    private boolean isRespawning = false;
    protected int skipRespawnTicks = 0;
    public final SmoothValue bodyRotDeviation = SmoothValue.rotation(0.0);
    public final SmoothValue xRotDeviation = SmoothValue.rotation(0.0);
    public final SmoothValue yawVelocity = SmoothValue.rotation(0.0);
    private float clientTailDragVelocity = 0.0f;
    private boolean isRideable = false;

    protected DragonEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.combatManager = new DragonCombatHandler(this);
        this.allyManager = new DragonAllyManager(this);
        this.f_21365_ = new DragonLookControl<DragonEntity>(this);
    }

    protected @NotNull BodyRotationControl m_7560_() {
        return new DragonBodyControl((Mob)this, this.getBodyTurnSpeed());
    }

    protected float getBodyTurnSpeed() {
        return 0.6f;
    }

    protected void setRideable() {
        this.isRideable = true;
    }

    public boolean isRideableDragon() {
        return this.isRideable;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COMMAND, (Object)0);
        this.f_19804_.m_135372_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_GENDER, (Object)DragonGender.MALE.getId());
        this.f_19804_.m_135372_(DATA_BODY_DEVIATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH_DEVIATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_YAW_VELOCITY, (Object)Float.valueOf(0.0f));
    }

    public float smoothTailDragVelocity(float targetDegrees) {
        this.clientTailDragVelocity = Mth.m_14179_((float)0.15f, (float)this.clientTailDragVelocity, (float)targetDegrees);
        return this.clientTailDragVelocity;
    }

    public void resetTailDragVelocity() {
        this.clientTailDragVelocity = 0.0f;
    }

    public DragonGender getGender() {
        return DragonGender.fromId((Byte)this.f_19804_.m_135370_(DATA_GENDER));
    }

    public void setGender(@Nullable DragonGender gender) {
        DragonGender resolved = gender == null ? DragonGender.MALE : gender;
        this.f_19804_.m_135381_(DATA_GENDER, (Object)resolved.getId());
        this.genderInitialized = true;
    }

    public boolean isFemale() {
        return this.getGender() == DragonGender.FEMALE;
    }

    public void setFemale(boolean female) {
        this.setGender(female ? DragonGender.FEMALE : DragonGender.MALE);
    }

    public boolean hasGender() {
        return this.genderInitialized;
    }

    protected void ensureGenderInitialized() {
        Level level = this.m_9236_();
        if (level != null && level.f_46443_) {
            return;
        }
        if (!this.genderInitialized) {
            this.setGender(this.f_19796_.m_188499_() ? DragonGender.FEMALE : DragonGender.MALE);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public abstract void registerControllers(AnimatableManager.ControllerRegistrar var1);

    public void syncAnimState(int groundState, int flightMode) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.setAnimData(DragonAnimTickets.GROUND_STATE, groundState);
        this.setAnimData(DragonAnimTickets.FLIGHT_MODE, flightMode);
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag spawnTag) {
        BlockPos safePos;
        SpawnGroupData data = super.m_6518_(levelAccessor, difficulty, reason, spawnData, spawnTag);
        this.ensureGenderInitialized();
        if (this.m_6162_() && reason == MobSpawnType.SPAWN_EGG && (safePos = this.findSafeBabySpawnPos((LevelAccessor)levelAccessor, this.m_20183_())) != null && (double)safePos.m_123342_() < this.m_20186_()) {
            this.m_7678_(this.m_20185_(), safePos.m_123342_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
        return data;
    }

    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.activeAbility;
    }

    public void setActiveAbility(DragonAbility<?> ability) {
        this.activeAbility = ability;
    }

    public boolean canUseAbility() {
        return this.combatManager.canUseAbility();
    }

    public boolean areAbilitiesLocked() {
        return this.combatManager.isGlobalCooldownActive();
    }

    public void lockAbilities(int ticks) {
        this.combatManager.lockGlobalCooldown(ticks);
    }

    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (abilityType == null || this.m_9236_().f_46443_) {
            return;
        }
        this.combatManager.tryUseAbility(abilityType);
    }

    public Map<String, VocalEntry> getVocalEntries() {
        return Collections.emptyMap();
    }

    public DragonSoundProfile getSoundProfile() {
        return DragonSoundProfile.EMPTY;
    }

    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return null;
    }

    protected void onSuccessfulDamage(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || this.isDying()) {
            return;
        }
        DragonAbilityType<?, ?> hurtAbility = this.getHurtAbilityType();
        if (hurtAbility != null) {
            this.combatManager.tryUseAbility(hurtAbility);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        DragonType dragonType = this.getDragonType();
        if (dragonType != null && dragonType.getElementalProfile().isImmuneTo(source)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_5825_() {
        DragonType dragonType = this.getDragonType();
        if (dragonType != null && dragonType.getElement() == Element.FIRE) {
            return true;
        }
        return super.m_5825_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean result;
        DragonType dragonType = this.getDragonType();
        if (dragonType != null) {
            float multiplier = dragonType.getElementalProfile().getDamageMultiplier(source);
            amount *= multiplier;
            if (multiplier == 0.0f) {
                return false;
            }
        }
        if (result = super.m_6469_(source, amount)) {
            this.onSuccessfulDamage(source, amount);
        }
        return result;
    }

    @Nullable
    public DragonType getDragonType() {
        return DragonType.fromEntity(this);
    }

    public abstract DragonAbilityType<?, ?> getPrimaryAttackAbility();

    public DragonAbilityType<?, ?> getRoaringAbility() {
        return null;
    }

    public DragonAbilityType<?, ?> getChannelingAbility() {
        return null;
    }

    public boolean isDying() {
        return this.dying;
    }

    public void onDeathAbilityStarted() {
    }

    public int getDeathAnimationDurationTicks() {
        return 62;
    }

    protected final void beginStandardDeathSequence(DragonAbilityType<?, ?> deathAbility) {
        if (this.m_9236_().f_46443_ || this.dying) {
            return;
        }
        this.m_20331_(true);
        this.dying = true;
        if (!this.canUseAbility()) {
            this.combatManager.forceEndActiveAbility();
        }
        this.tryActivateAbilityUnchecked(deathAbility);
    }

    protected final void completeStandardDeathSequence() {
        this.dying = false;
        this.m_20331_(false);
    }

    private void tryActivateAbilityUnchecked(DragonAbilityType<?, ?> type) {
        this.combatManager.tryUseAbility(type);
    }

    protected final boolean handleLethalDamage(DamageSource source, float amount, DragonAbilityType<?, ?> deathAbility) {
        if (this.m_9236_().f_46443_ || this.dying) {
            return false;
        }
        if (this.m_21223_() - amount > 0.0f) {
            return false;
        }
        this.beginStandardDeathSequence(deathAbility);
        boolean abilityStarted = this.combatManager.isAbilityActive(deathAbility);
        if (!abilityStarted) {
            this.completeStandardDeathSequence();
            return false;
        }
        return true;
    }

    protected final void registerBiteSoundKey(AnimationController<?> controller, String speciesId) {
        controller.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation." + speciesId + ".bite"));
    }

    public boolean isStayOrSitMuted() {
        return false;
    }

    public boolean isSleepTransitioning() {
        return false;
    }

    public boolean m_29443_() {
        return false;
    }

    public boolean isRunning() {
        return false;
    }

    public boolean isWalking() {
        return false;
    }

    public boolean isActuallyRunning() {
        return false;
    }

    public double getCachedHorizontalSpeed() {
        return 0.0;
    }

    public boolean areRiderControlsLocked() {
        return false;
    }

    public Vec3 getClientLocatorPosition(String locator) {
        return null;
    }

    public float maxSitTicks() {
        return 15.0f;
    }

    public float getSitProgress() {
        return ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
    }

    public boolean isGoingUp() {
        return false;
    }

    public void setGoingUp(boolean goingUp) {
    }

    public boolean isGoingDown() {
        return false;
    }

    public void setGoingDown(boolean goingDown) {
    }

    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    protected void tickAbilities() {
        if (!this.m_9236_().f_46443_) {
            this.combatManager.tick();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.skipRespawnTicks > 0) {
            --this.skipRespawnTicks;
        }
        this.tickAbilities();
        if (this.m_9236_().f_46443_) {
            this.updateRotationDeviations();
        } else {
            this.updateServerRotationTargets();
        }
    }

    private void updateRotationDeviations() {
        double headToBody = ((Float)this.f_19804_.m_135370_(DATA_BODY_DEVIATION)).floatValue();
        double pitchDelta = ((Float)this.f_19804_.m_135370_(DATA_PITCH_DEVIATION)).floatValue();
        double bodyYawDelta = ((Float)this.f_19804_.m_135370_(DATA_YAW_VELOCITY)).floatValue();
        this.bodyRotDeviation.setTo(headToBody);
        this.bodyRotDeviation.update(0.25f);
        this.xRotDeviation.setTo(pitchDelta);
        this.xRotDeviation.update(0.25f);
        this.yawVelocity.setTo(bodyYawDelta);
        this.yawVelocity.update(0.25f);
    }

    private void updateServerRotationTargets() {
        float bodyYawDelta = (float)((double)Mth.m_14177_((float)(this.f_20883_ - this.f_20884_)) * 2.0);
        this.f_19804_.m_135381_(DATA_YAW_VELOCITY, (Object)Float.valueOf(bodyYawDelta));
        if (this.m_20160_()) {
            this.f_19804_.m_135381_(DATA_BODY_DEVIATION, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_PITCH_DEVIATION, (Object)Float.valueOf(0.0f));
            return;
        }
        float headToBody = (float)((double)Mth.m_14177_((float)(this.f_20885_ - this.f_20883_)) * 0.25);
        float pitchDelta = (this.m_146909_() - this.f_19860_) * 0.5f;
        this.f_19804_.m_135381_(DATA_BODY_DEVIATION, (Object)Float.valueOf(headToBody));
        this.f_19804_.m_135381_(DATA_PITCH_DEVIATION, (Object)Float.valueOf(pitchDelta));
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(DATA_COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(DATA_COMMAND, (Object)command);
        if (this.m_21824_()) {
            this.m_21839_(command == 1);
        }
    }

    public boolean canOwnerCommand(Player player) {
        return player != null && player.m_6047_();
    }

    public boolean canOwnerMount(Player player) {
        return !this.m_6162_();
    }

    public boolean isAlly(Entity entity) {
        OwnableEntity ownable;
        LivingEntity owner;
        TamableAnimal tamable;
        Player player;
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return true;
            }
        }
        if (entity instanceof DragonEntity) {
            DragonEntity otherDragon = (DragonEntity)entity;
            if (this.m_21824_() && otherDragon.m_21824_()) {
                LivingEntity owner2 = this.m_269323_();
                if (owner2 instanceof Player) {
                    Player ownerPlayer = (Player)owner2;
                    if (otherDragon.m_21830_((LivingEntity)ownerPlayer)) {
                        return true;
                    }
                    LivingEntity otherOwner = otherDragon.m_269323_();
                    if (otherOwner instanceof Player) {
                        Player otherPlayer = (Player)otherOwner;
                        return this.allyManager.isAlly(otherPlayer);
                    }
                }
                return false;
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            return this.allyManager.isAlly(player);
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && (owner = tamable.m_269323_()) instanceof Player) {
            Player playerOwner = (Player)owner;
            return this.m_21824_() && this.m_21830_((LivingEntity)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            Player playerOwner = (Player)owner;
            return this.m_21824_() && this.m_21830_((LivingEntity)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        return false;
    }

    public boolean canTarget(Entity entity) {
        OwnableEntity ownable;
        Player playerOwner;
        LivingEntity owner;
        TamableAnimal tamable;
        if (entity == null) {
            return false;
        }
        if (this.isAlly(entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && (owner = tamable.m_269323_()) instanceof Player) {
            playerOwner = (Player)owner;
            if (this.m_21824_() && this.m_21830_((LivingEntity)playerOwner)) {
                return false;
            }
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            playerOwner = (Player)owner;
            if (this.m_21824_() && this.m_21830_((LivingEntity)playerOwner)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && this.canOwnerCommand(player) && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            int next = (this.getCommand() + 1) % 3;
            this.setCommand(next);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Command", this.getCommand());
        tag.m_128344_("Gender", this.getGender().getId());
        tag.m_128379_("IsFemale", this.isFemale());
        this.allyManager.saveToNBT(tag);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        if (tag.m_128441_("IsRespawning")) {
            this.isRespawning = tag.m_128471_("IsRespawning");
        }
        super.m_7378_(tag);
        if (tag.m_128441_("Command")) {
            this.setCommand(tag.m_128451_("Command"));
        }
        if (tag.m_128425_("Gender", 1)) {
            this.setGender(DragonGender.fromId(tag.m_128445_("Gender")));
        } else if (tag.m_128441_("IsFemale")) {
            this.setFemale(tag.m_128471_("IsFemale"));
        } else {
            this.genderInitialized = false;
            this.ensureGenderInitialized();
        }
        this.allyManager.loadFromNBT(tag);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21827_() && !this.m_20160_() && !this.m_20159_()) {
            this.m_20256_(Vec3.f_82478_);
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(travelVector);
    }

    public void m_146762_(int age) {
        boolean wasBaby = this.m_6162_();
        super.m_146762_(age);
        boolean isNowBaby = this.m_6162_();
        if (wasBaby != isNowBaby && !this.m_9236_().f_46443_ && !this.isRespawning && this.m_19879_() != -1 && this.skipRespawnTicks == 0) {
            this.isRespawning = true;
            Level world = this.m_9236_();
            double posX = this.m_20185_();
            double posY = this.m_20186_();
            double posZ = this.m_20189_();
            float yaw = this.m_146908_();
            float pitch = this.m_146909_();
            UUID oldUUID = this.m_20148_();
            boolean wasTamed = this.m_21824_();
            CompoundTag nbt = new CompoundTag();
            this.m_20240_(nbt);
            nbt.m_128379_("IsRespawning", true);
            nbt.m_128405_("Age", age);
            DragonEntity newEntity = (DragonEntity)this.m_6095_().m_20615_(world);
            if (newEntity != null) {
                newEntity.m_20258_(nbt);
                newEntity.m_6034_(posX, posY, posZ);
                newEntity.m_146922_(yaw);
                newEntity.m_146926_(pitch);
                if (wasTamed) {
                    newEntity.m_20084_(oldUUID);
                }
                newEntity.isRespawning = false;
                world.m_7967_((Entity)newEntity);
                this.m_146870_();
                world.m_7605_((Entity)newEntity, (byte)7);
            }
        }
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        AgeableMob baby = this.m_142606_(level, (AgeableMob)otherParent);
        if (baby != null) {
            BlockPos safePos = this.findSafeBabySpawnPos((LevelAccessor)level, this.m_20183_());
            baby.m_6863_(true);
            baby.m_7678_(this.m_20185_(), safePos != null ? (double)safePos.m_123342_() : this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            level.m_47205_((Entity)baby);
        }
    }

    @Nullable
    protected BlockPos findSafeBabySpawnPos(LevelAccessor level, BlockPos start) {
        if (level == null || start == null) {
            return null;
        }
        BlockPos.MutableBlockPos cursor = start.m_122032_();
        int minY = level.m_141937_();
        while (cursor.m_123342_() >= minY) {
            BlockPos above;
            BlockState aboveState;
            BlockState state = level.m_8055_((BlockPos)cursor);
            if (this.isStableBabyLandingSurface((BlockGetter)level, (BlockPos)cursor, state) && (aboveState = level.m_8055_(above = cursor.m_7494_())).m_60812_((BlockGetter)level, above).m_83281_() && aboveState.m_60819_().m_76178_()) {
                return above;
            }
            cursor.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private boolean isStableBabyLandingSurface(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60795_() || !state.m_60819_().m_76178_()) {
            return false;
        }
        return state.m_60804_(level, pos) || state.m_60783_(level, pos, Direction.UP);
    }

    public abstract Vec3 getHeadPosition();

    public abstract Vec3 getMouthPosition();

    public static final class VocalEntryBuilder {
        private final Map<String, VocalEntry> entries = new HashMap<String, VocalEntry>();

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<SoundEvent> sound, float volume, float basePitch, float variance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
            this.entries.put(key, new VocalEntry(controller, animation, sound, volume, basePitch, variance, allowWhenSitting, allowDuringSleep, preventOverlap));
            return this;
        }

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<SoundEvent> sound) {
            return this.add(key, controller, animation, sound, 1.0f, 1.0f, 0.0f, false, false, false);
        }

        public Map<String, VocalEntry> build() {
            return Map.copyOf(this.entries);
        }
    }

    public record VocalEntry(String controllerId, String animationId, Supplier<SoundEvent> soundSupplier, float volume, float basePitch, float pitchVariance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
    }
}

