/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RaevyxRiderController(Raevyx wyvern) {
    private static final double SEAT_BASE_FACTOR = 0.5;
    private static final double CRUISE_SPEED_MULT = 3.75;
    private static final double SPRINT_SPEED_MULT = 7.85;
    private static final double ACCELERATION = 0.15;
    private static final double DRAG_WITH_INPUT = 0.08;
    private static final double DRAG_NO_INPUT = 0.5;
    private static final double STRAFE_POWER = 0.5;
    private static final double ASCEND_THRUST = 0.08;
    private static final double DESCEND_THRUST = 1.0;
    private static final double TERMINAL_VELOCITY = 1.5;
    private static final double VERTICAL_DRAG = 0.92;

    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.wyvern.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        float f;
        float f2 = f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        if (this.wyvern.m_29443_()) {
            return new Vec3((double)(player.f_20900_ * 0.4f), 0.0, (double)(player.f_20902_ * 1.0f * f));
        }
        return new Vec3((double)(player.f_20900_ * 0.5f), 0.0, (double)(player.f_20902_ * 0.9f * f));
    }

    public void tickRidden(Player player, Vec3 travelVector) {
        player.f_19789_ = 0.0f;
        this.wyvern.f_19789_ = 0.0f;
        this.wyvern.m_6710_(null);
        boolean flying = this.wyvern.m_29443_();
        float yawDiff = Math.abs(player.m_146908_() - this.wyvern.m_146908_());
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f || yawDiff > 5.0f) {
            float currentYaw = this.wyvern.m_146908_();
            float targetYaw = player.m_146908_();
            float rawDiff = Mth.m_14177_((float)(targetYaw - currentYaw));
            float blend = flying ? 0.35f : 0.28f;
            float newYaw = currentYaw + rawDiff * blend;
            this.wyvern.m_146922_(newYaw);
            this.wyvern.f_20883_ = newYaw;
            this.wyvern.f_20885_ = newYaw;
            if (flying) {
                float targetPitch = Mth.m_14036_((float)(player.m_146909_() * 0.55f), (float)-35.0f, (float)30.0f);
                this.wyvern.m_146926_(targetPitch);
            } else {
                this.wyvern.m_146926_(0.0f);
            }
            this.wyvern.m_20256_(this.wyvern.m_20184_());
        }
        if (this.wyvern.m_20096_()) {
            player.f_19789_ = 0.0f;
            this.wyvern.f_19789_ = 0.0f;
        }
    }

    public float getRiddenSpeed(Player rider) {
        boolean isMoving;
        if (this.wyvern.m_29443_()) {
            return (float)this.wyvern.m_21133_(Attributes.f_22280_);
        }
        float baseSpeed = (float)this.wyvern.m_21133_(Attributes.f_22279_);
        boolean bl = isMoving = this.wyvern.m_20184_().m_165925_() > 1.0E-4;
        if (this.wyvern.isAccelerating() && isMoving) {
            this.wyvern.setRunning(true);
            return baseSpeed * 0.7f;
        }
        this.wyvern.setRunning(false);
        return baseSpeed * 0.5f;
    }

    public void handleRiderMovement(Player player, Vec3 motion) {
        if (this.wyvern.m_21573_().m_26570_() != null) {
            this.wyvern.m_21573_().m_26573_();
        }
        if (this.wyvern.m_29443_()) {
            Vec3 newHorizontalVel;
            double baseSpeed = this.wyvern.m_21133_(Attributes.f_22280_);
            boolean sprinting = this.wyvern.isAccelerating();
            double targetSpeed = (sprinting ? 7.85 : 3.75) * baseSpeed;
            Vec3 currentVelocity = this.wyvern.m_20184_();
            Vec3 horizontalVel = new Vec3(currentVelocity.f_82479_, 0.0, currentVelocity.f_82481_);
            double currentSpeed = horizontalVel.m_82553_();
            double forwardInput = motion.f_82481_;
            double strafeInput = motion.f_82479_;
            boolean hasInput = Math.abs(forwardInput) > 0.01 || Math.abs(strafeInput) > 0.01;
            float yawRad = (float)Math.toRadians(this.wyvern.m_146908_());
            double forwardX = -Math.sin(yawRad);
            double forwardZ = Math.cos(yawRad);
            double rightX = Math.cos(yawRad);
            double rightZ = Math.sin(yawRad);
            double targetDirX = forwardX * forwardInput + rightX * (strafeInput * 0.5);
            double targetDirZ = forwardZ * forwardInput + rightZ * (strafeInput * 0.5);
            double dirLength = Math.hypot(targetDirX, targetDirZ);
            if (hasInput && dirLength > 0.01) {
                Vec3 targetVelocity = new Vec3((targetDirX /= dirLength) * targetSpeed, 0.0, (targetDirZ /= dirLength) * targetSpeed);
                newHorizontalVel = new Vec3(Mth.m_14139_((double)0.15, (double)horizontalVel.f_82479_, (double)targetVelocity.f_82479_), 0.0, Mth.m_14139_((double)0.15, (double)horizontalVel.f_82481_, (double)targetVelocity.f_82481_));
                newHorizontalVel = newHorizontalVel.m_82490_(0.92);
            } else {
                newHorizontalVel = horizontalVel.m_82490_(0.5);
                if (newHorizontalVel.m_82553_() < 0.01) {
                    newHorizontalVel = Vec3.f_82478_;
                }
            }
            double verticalVel = currentVelocity.f_82480_;
            verticalVel = this.wyvern.isGoingUp() ? (verticalVel += 0.08) : (this.wyvern.isGoingDown() ? (verticalVel -= 1.0) : (verticalVel *= 0.92));
            verticalVel = Mth.m_14008_((double)verticalVel, (double)-1.5, (double)1.5);
            Vec3 finalVelocity = new Vec3(newHorizontalVel.f_82479_, verticalVel, newHorizontalVel.f_82481_);
            this.wyvern.m_6478_(MoverType.SELF, finalVelocity);
            this.wyvern.m_20256_(finalVelocity);
            this.wyvern.m_267651_(true);
            player.f_19789_ = 0.0f;
            this.wyvern.f_19789_ = 0.0f;
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.wyvern.m_20206_() * 0.5;
    }

    public void positionRider(@NotNull Entity passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction moveFunction) {
        if (!this.wyvern.m_20363_(passenger)) {
            return;
        }
        Vec3 passengerLoc = this.wyvern.getClientLocatorPosition("passengerLocator");
        if (passengerLoc != null) {
            Vec3 dragonOldPos = new Vec3(this.wyvern.f_19854_, this.wyvern.f_19855_, this.wyvern.f_19856_);
            float oldYaw = this.wyvern.f_19859_;
            Vec3 worldOffset = passengerLoc.m_82546_(dragonOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.f_82479_ * cosOld - worldOffset.f_82481_ * sinOld;
            double localY = worldOffset.f_82480_;
            double localZ = worldOffset.f_82479_ * sinOld + worldOffset.f_82481_ * cosOld;
            float currentYaw = this.wyvern.m_146908_();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            Vec3 dragonCurrentPos = this.wyvern.m_20182_();
            Vec3 passengerCurrentPos = dragonCurrentPos.m_82520_(currentWorldX, localY, currentWorldZ);
            moveFunction.m_20372_(passenger, passengerCurrentPos.f_82479_, passengerCurrentPos.f_82480_, passengerCurrentPos.f_82481_);
        } else {
            double x = this.wyvern.m_20185_();
            double y = this.wyvern.m_20186_() + this.getPassengersRidingOffset() + passenger.m_6049_();
            double z = this.wyvern.m_20189_();
            moveFunction.m_20372_(passenger, x, y, z);
        }
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        passenger.f_19789_ = 0.0f;
        Level level = this.wyvern.m_9236_();
        Vec3 base = this.wyvern.m_20182_();
        double[] radii = new double[]{2.5, 3.5, 1.8};
        int[] angles = new int[]{0, 30, -30, 60, -60, 90, -90, 150, -150, 180};
        for (double r : radii) {
            for (int a : angles) {
                double rad = Math.toRadians(this.wyvern.m_146908_() + (float)a);
                double cx = base.f_82479_ + Math.cos(rad) * r;
                double cz = base.f_82481_ + Math.sin(rad) * r;
                int startY = (int)Math.floor(base.f_82480_ + 1.0);
                for (int dy = 0; dy <= 6; ++dy) {
                    int y = startY - dy;
                    BlockPos pos = new BlockPos((int)Math.floor(cx), y, (int)Math.floor(cz));
                    BlockPos below = pos.m_7495_();
                    BlockState bsBelow = level.m_8055_(below);
                    BlockState bsAt = level.m_8055_(pos);
                    boolean solidBelow = !bsBelow.m_60795_() && !bsBelow.m_60812_((BlockGetter)level, below).m_83281_();
                    boolean spaceFree = bsAt.m_60812_((BlockGetter)level, pos).m_83281_();
                    boolean fluidOk = bsAt.m_60819_().m_76178_();
                    if (!solidBelow || !spaceFree || !fluidOk) continue;
                    return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5);
                }
            }
        }
        Vec3 direction = this.wyvern.m_20252_(1.0f);
        return base.m_82549_(direction.m_82490_(2.0));
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.wyvern.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.wyvern.m_21824_() && this.wyvern.m_21830_((LivingEntity)player)) {
                return player;
            }
        }
        return null;
    }

    public void requestRiderTakeoff() {
        if (!this.wyvern.m_21824_() || this.getRidingPlayer() == null || this.wyvern.m_29443_()) {
            return;
        }
        if (this.wyvern.isTakeoffLocked()) {
            return;
        }
        long now = this.wyvern.m_9236_().m_46467_();
        long lastLand = this.wyvern.getLastLandingGameTime();
        if (lastLand != Long.MIN_VALUE && now - lastLand < 20L) {
            return;
        }
        this.wyvern.timeFlying = 0;
        this.wyvern.landingFlag = false;
        this.wyvern.landingTimer = 0;
        this.wyvern.setFlying(true);
        this.wyvern.setTakeoff(true);
        this.wyvern.setHovering(false);
        this.wyvern.setLanding(false);
        this.wyvern.setRiderTakeoffTicks(30);
        if (this.wyvern.m_9236_().f_46443_) {
            float urgency = this.wyvern.m_5448_() != null ? 1.3f : 1.0f;
            this.wyvern.m_9236_().m_7785_(this.wyvern.m_20185_(), this.wyvern.m_20186_(), this.wyvern.m_20189_(), SoundEvents.f_11893_, SoundSource.NEUTRAL, urgency * 1.2f, 0.85f, false);
        }
    }
}

