/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.cindervane.CindervaneAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneCombatGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneFlightGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneRestGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneSleepGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.base.RideableDragonData;
import com.leon.saintsdragons.server.entity.controller.cindervane.CindervanePhysicsController;
import com.leon.saintsdragons.server.entity.controller.cindervane.CindervaneRiderController;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Cindervane
extends RideableDragonBase
implements DragonFlightCapable,
SoundHandledDragon,
ShakesScreen,
DragonSleepCapable {
    private static final int LANDING_SETTLE_TICKS = 4;
    private static final double FIRE_BODY_CRASH_MIN_DROP = 7.0;
    private static final float FIRE_BODY_EXPLOSION_RADIUS = 15.0f;
    private static final double FIRE_BODY_IMPRINT_RADIUS = 9.0;
    private static final double FIRE_BODY_IMPRINT_DEPTH_FACTOR = 0.6;
    private static final float FIRE_BODY_EXPLOSION_DAMAGE = 200.0f;
    private static final int MIN_AMBIENT_DELAY = 180;
    private static final int MAX_AMBIENT_DELAY = 420;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "actions", "animation.cindervane.grumble1", ModSounds.CINDERVANE_GRUMBLE_1, 1.1f, 0.98f, 0.06f, false, false, false).add("grumble2", "actions", "animation.cindervane.grumble2", ModSounds.CINDERVANE_GRUMBLE_2, 1.2f, 0.96f, 0.08f, false, false, false).add("grumble3", "actions", "animation.cindervane.grumble3", ModSounds.CINDERVANE_GRUMBLE_3, 1.0f, 1.0f, 0.05f, false, false, false).add("roar", "actions", "animation.cindervane.roar", ModSounds.CINDERVANE_ROAR, 1.5f, 0.95f, 0.1f, false, false, false).add("roar_ground", "actions", "animation.cindervane.roar_ground", ModSounds.CINDERVANE_ROAR, 1.5f, 0.9f, 0.05f, false, false, false).add("roar_air", "actions", "animation.cindervane.roar_air", ModSounds.CINDERVANE_ROAR, 1.5f, 1.05f, 0.05f, false, false, false).add("cindervane_hurt", "hurt", "animation.cindervane.hurt", ModSounds.CINDERVANE_HURT, 1.2f, 0.95f, 0.1f, false, false, false).add("cindervane_die", "action", "animation.cindervane.die", ModSounds.CINDERVANE_DIE, 1.5f, 1.0f, 0.0f, false, false, false).build();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final CindervaneAnimationHandler animationHandler = new CindervaneAnimationHandler(this);
    private final CindervanePhysicsController physicsController = new CindervanePhysicsController(this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final CindervaneInteractionHandler interactionHandler = new CindervaneInteractionHandler(this);
    private final CindervaneRiderController riderController;
    private final DragonRestManager restManager = new DragonRestManager((LivingEntity)this);
    private final DragonPathNavigateGround groundNav;
    private final FlyingPathNavigation airNav;
    private boolean usingAirNav;
    private int targetCooldown;
    private int airTicks;
    public int groundTicks;
    public int timeFlying = 0;
    private int landingTicks;
    private int riderTakeoffTicks;
    private boolean wasVehicleLastTick;
    private boolean fireBodyCrashArmed;
    private double fireBodyCrashMaxHeight;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    private static final double MODEL_SCALE = 1.0;
    private static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    private static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    private boolean inHighAltitudeGlide = false;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.0;
    private static final int RIDER_LANDING_BLEND_DURATION = 3;
    private int riderLandingBlendTicks = 0;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();
    private static final EntityDataAccessor<Boolean> DATA_FIRE_BREATHING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_TAKEOFF = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HOVERING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_LANDING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_GROUND_MOVE_STATE = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_FLIGHT_MODE = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_RIDER_FORWARD = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RIDER_STRAFE = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_GOING_UP = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_GOING_DOWN = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ACCELERATING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_SCREEN_SHAKE_AMOUNT = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_RIDER_LANDING_BLEND = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING_ENTERING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING_EXITING = SynchedEntityData.m_135353_(Cindervane.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double WATER_EFFECT_MAX_HEIGHT = 10.0;
    private static final double WATER_EFFECT_INTENSITY = 1.5;

    public Cindervane(EntityType<? extends Cindervane> type, Level level) {
        super(type, level);
        this.m_274367_(1.1f);
        this.groundNav = new DragonPathNavigateGround((Mob)this, level);
        this.airNav = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(@Nonnull BlockPos pos) {
                BlockState below = this.f_26495_.m_8055_(pos.m_7495_());
                return !below.m_60795_();
            }
        };
        this.airNav.m_26440_(false);
        this.airNav.m_7008_(false);
        this.airNav.m_26443_(false);
        this.f_21344_ = this.groundNav;
        this.f_21342_ = new MoveControl((Mob)this);
        this.usingAirNav = false;
        this.riderController = new CindervaneRiderController(this);
        this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        RandomSource rng = this.m_217043_();
        this.ambientSoundTimer = rng.m_188503_(80);
        this.nextAmbientSoundDelay = 180 + rng.m_188503_(Math.max(1, 241));
    }

    @Override
    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, spawnType, spawnData, dataTag);
        if (!this.m_21824_()) {
            this.m_21816_(null);
            this.setCommand(2);
            this.m_21839_(false);
        }
        return data;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22284_, 4.0);
    }

    public static boolean canSpawnHere(EntityType<? extends Cindervane> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!Animal.m_218104_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (!level.m_6425_(pos.m_7495_()).m_76178_()) {
            return false;
        }
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FIRE_BREATHING, (Object)false);
        this.f_19804_.m_135372_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RIDER_LANDING_BLEND, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEPING_EXITING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.f_19804_.m_135372_(DATA_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_TAKEOFF, (Object)false);
        this.f_19804_.m_135372_(DATA_HOVERING, (Object)false);
        this.f_19804_.m_135372_(DATA_LANDING, (Object)false);
        this.f_19804_.m_135372_(DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135372_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_GOING_UP, (Object)false);
        this.f_19804_.m_135372_(DATA_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(DATA_ACCELERATING, (Object)false);
    }

    @Override
    protected EntityDataAccessor<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected EntityDataAccessor<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected EntityDataAccessor<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected EntityDataAccessor<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected EntityDataAccessor<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    @Override
    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
        this.setFlying(flying);
        this.setTakeoff(takeoff);
        this.setHovering(hovering);
        this.setLanding(landing);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CindervaneSleepGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CindervaneRestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new CindervaneFlightGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new CindervaneCombatGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new CindervaneFollowOwnerGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new CindervaneGroundWanderGoal(this, 0.6, 160));
        this.f_21346_.m_25352_(1, (Goal)new DragonOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !Cindervane.this.m_20160_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return !Cindervane.this.m_20160_() && super.m_8036_();
            }
        });
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            boolean onGroundNow;
            if (!this.m_21827_() && ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue() != 0.0f) {
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
            boolean bl = onGroundNow = this.m_20096_() && !this.m_20069_();
            if (this.m_29443_()) {
                ++this.airTicks;
                this.groundTicks = 0;
                this.f_19789_ = 0.0f;
                if (this.isTakeoff() && !onGroundNow && this.airTicks > 5) {
                    this.setTakeoff(false);
                }
                if (onGroundNow && !this.isTakeoff()) {
                    if (!this.isLanding()) {
                        this.setLanding(true);
                    }
                    this.setFlying(false);
                } else if (this.isLanding() && !onGroundNow) {
                    this.setLanding(false);
                }
            } else {
                ++this.groundTicks;
                this.airTicks = 0;
            }
            if (this.isLanding()) {
                if (onGroundNow) {
                    ++this.landingTicks;
                    if (this.landingTicks >= 4) {
                        this.markLandedNow();
                    }
                } else {
                    this.landingTicks = 0;
                }
            } else {
                this.landingTicks = 0;
            }
            this.tickAnimationStates();
        }
        this.m_20242_(this.m_29443_() || this.isHovering());
        if (!this.m_29443_() && this.usingAirNav) {
            this.switchToGroundNavigation();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.physicsController.tick();
        this.tickSittingState();
        this.tickBankingLogic();
        this.tickPitchingLogic();
        this.tickRiderTakeoff();
        this.tickMountedState();
        this.tickScreenShake();
        this.updateSittingProgress();
        this.tickSleepTransition();
        this.tickSleepCooldowns();
        this.tickWaterSlicing();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20160_() && ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue() != 0.0f) {
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
            if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.handleFireBodyCrash();
            this.timeFlying = this.m_29443_() ? ++this.timeFlying : 0;
            this.handleAmbientSounds();
            if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
                if (this.m_5448_() != null || this.m_5912_()) {
                    this.wakeUpImmediately();
                    this.suppressSleep(200);
                } else if (this.m_20072_() || this.m_20077_()) {
                    this.wakeUpImmediately();
                    this.suppressSleep(200);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ == 1) {
            this.initializeAnimationState();
        }
        this.tickClientSideUpdates();
    }

    private void tickSittingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && this.m_21827_()) {
            this.m_21839_(false);
        }
    }

    private void tickMountedState() {
        boolean mounted = this.m_20160_();
        if (mounted && !this.wasVehicleLastTick) {
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.clearStatesWhenMounted();
            if (this.m_21827_()) {
                this.m_21839_(false);
                if (this.getCommand() == 1) {
                    this.setCommand(0);
                }
            }
            if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
                this.wakeUpImmediately();
                this.suppressSleep(300);
            }
        }
        if (!mounted && this.wasVehicleLastTick) {
            this.setBreathingFire(false);
            this.combatManager.forceEndActiveAbility();
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)0);
            this.f_19804_.m_135381_(DATA_FLIGHT_MODE, (Object)-1);
            this.f_19804_.m_135381_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
            this.syncAnimState(0, -1);
        }
        this.wasVehicleLastTick = mounted;
    }

    private void updateSittingProgress() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.m_21827_()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = 45;
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else if (this.m_20160_()) {
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
                this.prevSitProgress = 0.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
        } else if (this.sitProgress > 0.0f) {
            if ((this.sitProgress >= this.maxSitTicks() - 1.0f || this.isSittingDown) && !this.isStandingUp) {
                this.animationHandler.triggerSitUpAnimation();
                this.isStandingUp = true;
                this.isSittingDown = false;
                this.sitTransitionTicks = 46;
            }
            this.sitProgress -= 1.0f;
            if (this.sitProgress < 0.0f) {
                this.sitProgress = 0.0f;
            }
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
    }

    private void tickClientSideUpdates() {
        if (this.m_9236_().f_46443_) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    private void handleAmbientSounds() {
        if (this.nextAmbientSoundDelay <= 0) {
            this.resetAmbientSoundTimer();
        }
        if (this.m_6162_() || this.isDying() || this.m_5803_() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0) {
            this.ambientSoundTimer = 0;
            return;
        }
        if (this.getActiveAbility() != null || this.isBreathingFire() || this.m_5448_() != null) {
            this.ambientSoundTimer = 0;
            return;
        }
        if (this.m_20160_() || this.isTakeoff() || this.isLanding() || this.isHovering()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer < this.nextAmbientSoundDelay) {
            return;
        }
        String vocal = this.selectAmbientGrumble();
        if (vocal != null) {
            this.getSoundHandler().playVocal(vocal);
        }
        this.resetAmbientSoundTimer();
    }

    private String selectAmbientGrumble() {
        RandomSource random = this.m_217043_();
        float roll = random.m_188501_();
        if (roll < 0.45f) {
            return "grumble1";
        }
        if (roll < 0.8f) {
            return "grumble2";
        }
        return "grumble3";
    }

    private void resetAmbientSoundTimer() {
        this.ambientSoundTimer = 0;
        RandomSource random = this.m_217043_();
        int range = Math.max(1, 241);
        this.nextAmbientSoundDelay = 180 + random.m_188503_(range);
    }

    private void clearStatesWhenMounted() {
        if (this.m_9236_().f_46443_ || !this.m_20160_()) {
            return;
        }
        this.setRunning(false);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.setHovering(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setAccelerating(false);
        this.riderTakeoffTicks = 0;
        if (!this.m_29443_()) {
            this.airTicks = 0;
        }
        if (this.m_21573_().m_26570_() != null) {
            this.m_21573_().m_26573_();
        }
        if (!this.m_29443_() && this.usingAirNav) {
            this.switchToGroundNavigation();
        }
        this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135381_(DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135381_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.syncAnimState(0, -1);
        this.m_6710_(null);
        this.m_21839_(false);
        this.m_20242_(this.m_29443_() || this.isHovering());
    }

    private void tickRiderTakeoff() {
        if (!this.m_9236_().f_46443_ && this.riderTakeoffTicks > 0) {
            double boost;
            --this.riderTakeoffTicks;
            Vec3 velocity = this.m_20184_();
            double d = boost = this.m_29443_() ? 0.08 : 0.12;
            if (velocity.f_82480_ < boost) {
                this.m_20334_(velocity.f_82479_, boost, velocity.f_82481_);
            }
            this.f_19812_ = true;
        }
    }

    private void tickBankingLogic() {
        boolean shouldBank;
        this.prevBankAngle = this.bankAngle;
        boolean bl = shouldBank = this.m_29443_() && !this.isLanding() && !this.isHovering() && !this.m_21827_();
        if (!shouldBank) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.75f + yawChange * 0.25f;
        float targetAngle = Mth.m_14036_((float)(this.bankSmoothedYaw * 6.0f), (float)-90.0f, (float)90.0f);
        this.bankAngle = Mth.m_14179_((float)0.3f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 10.0f;
        float exit = 4.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.m_20160_() || !this.m_29443_() || this.m_20096_()) {
            this.riderLandingBlendTicks = 0;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 3;
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_46805_(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        int dragonY = (int)Math.floor(this.m_20186_());
        int scanTopY = dragonY + 3;
        int scanBottomY = Math.min(groundY - 1, dragonY - 15);
        for (int y = scanTopY; y >= scanBottomY; --y) {
            BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            BlockState checkState = this.m_9236_().m_8055_(checkPos);
            if (checkState.m_60819_().m_76178_()) continue;
            return Double.POSITIVE_INFINITY;
        }
        return this.m_20186_() - (double)groundY;
    }

    private void tickPitchingLogic() {
        this.tickRiderLandingBlendTimer();
        if (!this.m_29443_() || this.isLanding() || this.isHovering() || this.m_21827_()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) != Double.POSITIVE_INFINITY && altitude >= -0.25 && altitude <= 8.0) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.m_146909_() - this.f_19860_;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.9f + pitchChange * 0.1f;
            float enter = 4.0f;
            float exit = 6.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 4 : 6;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 15);
        }
    }

    private void tickScreenShake() {
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.12f);
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
        }
    }

    private void tickWaterSlicing() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.m_29443_()) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB box = this.m_20191_();
        int checkDown = 0;
        while ((double)checkDown < 10.0) {
            BlockPos checkPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_) - checkDown, (int)Math.floor(pos.f_82481_));
            BlockState state = this.m_9236_().m_8055_(checkPos);
            if (!state.m_60819_().m_76178_()) {
                double waterY = (double)checkPos.m_123342_() + 1.0;
                double boxWidth = box.m_82362_();
                double boxLength = box.m_82385_();
                int particleCount = (int)Math.ceil((boxWidth + boxLength) / 2.0 * 1.5 * 8.0);
                particleCount = Math.min(particleCount, 50);
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * boxWidth;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * boxLength;
                    double particleX = pos.f_82479_ + offsetX;
                    double particleZ = pos.f_82481_ + offsetZ;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, particleX, waterY, particleZ, 1, offsetX * 0.2, 0.1, offsetZ * 0.2, 0.1);
                    if (!(this.f_19796_.m_188501_() < 0.3f)) continue;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123772_, particleX, waterY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            ++checkDown;
        }
    }

    public int getBankDirection() {
        return this.bankDir;
    }

    public float getBankAngleDegrees() {
        return this.bankAngle;
    }

    public float getBankAngleDegrees(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public float getSmoothBankDirection() {
        return Mth.m_14036_((float)(this.bankAngle / 45.0f), (float)-1.0f, (float)1.0f);
    }

    public int getPitchDirection() {
        return this.pitchDir;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public int getTimeFlying() {
        return this.timeFlying;
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GOING_UP);
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RUNNING);
    }

    @Override
    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(DATA_RUNNING, (Object)running);
    }

    @Override
    public boolean isWalking() {
        if (this.m_9236_().f_46443_) {
            int s = this.getEffectiveGroundState();
            return s == 1;
        }
        int s = (Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE);
        return s == 1;
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.m_9236_().f_46443_) {
            int s = Mth.m_14045_((int)state, (int)0, (int)2);
            if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != s) {
                this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    public void initializeAnimationState() {
        super.initializeAnimationState();
        if (!this.m_9236_().f_46443_) {
            this.groundTicks = 0;
            this.airTicks = 0;
            this.landingTicks = 0;
        }
    }

    @Override
    public int getFlightMode() {
        return this.physicsController.computeFlightModeForSync();
    }

    @Override
    protected void applyRiderVerticalInput(Player player, boolean goingUp, boolean goingDown, boolean locked) {
        if (this.m_29443_()) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
        } else {
            this.setGoingUp(false);
            this.setGoingDown(false);
        }
    }

    @Override
    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = this.applyInputDeadzone(forward);
        float str = this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.m_29443_()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                moveState = this.isAccelerating() ? 2 : 1;
            }
            this.setGroundMoveStateFromAI(moveState);
            this.setRunning(moveState == 2);
        }
    }

    @Override
    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.forceEndActiveAbility();
                break;
            }
        }
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_fire_body", RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_roar", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_fire_breath_volley", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_bite", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    public double m_6048_() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void m_19956_(@Nonnull Entity passenger, @Nonnull Entity.MoveFunction moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @NotNull
    public Vec3 m_7688_(@Nonnull LivingEntity passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.riderController.getControllingPassenger();
    }

    protected float m_245547_(@Nonnull Player rider) {
        return this.riderController.getRiddenSpeed(rider);
    }

    protected void m_274498_(@Nonnull Player player, @Nonnull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        this.riderController.tickRidden(player, travelVector);
        if (this.areRiderControlsLocked() && this.combatManager.getActiveAbility() == null && !this.combatManager.hasActiveOverlay()) {
            this.copyRiderLook(player);
        }
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@Nonnull Player player, @Nonnull Vec3 deltaIn) {
        Vec3 input = this.riderController.getRiddenInput(player, deltaIn);
        if (!this.m_9236_().f_46443_ && !this.m_29443_()) {
            float fwd = (float)Mth.m_14008_((double)input.f_82481_, (double)-1.0, (double)1.0);
            float str = (float)Mth.m_14008_((double)input.f_82479_, (double)-1.0, (double)1.0);
            this.f_19804_.m_135381_(DATA_RIDER_FORWARD, (Object)Float.valueOf(RideableDragonData.applyInputThreshold(fwd)));
            this.f_19804_.m_135381_(DATA_RIDER_STRAFE, (Object)Float.valueOf(RideableDragonData.applyInputThreshold(str)));
        }
        return input;
    }

    public void m_21839_(boolean sitting) {
        super.m_21839_(sitting);
        if (sitting) {
            if (this.m_29443_()) {
                this.setLanding(true);
            }
            this.setRunning(false);
            this.m_21573_().m_26573_();
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
    }

    @Override
    public void m_7023_(@NotNull Vec3 motion) {
        LivingEntity livingEntity;
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            if (this.m_29443_()) {
                this.riderController.handleRiderMovement(player, motion);
            } else {
                super.m_7023_(motion);
            }
        } else {
            super.m_7023_(motion);
        }
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.f_21344_ = this.airNav;
            this.f_21342_ = new DragonFlightMoveHelper(this, this.getGliderFlightParameters());
            this.usingAirNav = true;
        }
    }

    private DragonFlightMoveHelper.FlightParameters getGliderFlightParameters() {
        return new DragonFlightMoveHelper.FlightParameters(3.0f, 5.0f, 0.3f, 2.0f, 0.08f, 0.15, 0.1);
    }

    private void handleFireBodyCrash() {
        boolean fireActive = this.isBreathingFire();
        boolean airborne = !this.m_20096_();
        LivingEntity rider = this.m_6688_();
        if (fireActive && rider != null) {
            rider.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 10, 0, true, false, false));
        }
        if (fireActive && airborne) {
            if (!this.fireBodyCrashArmed) {
                this.fireBodyCrashMaxHeight = this.m_20186_();
            } else if (this.m_20186_() > this.fireBodyCrashMaxHeight) {
                this.fireBodyCrashMaxHeight = this.m_20186_();
            }
            this.fireBodyCrashArmed = true;
        }
        if (this.fireBodyCrashArmed && !airborne && fireActive) {
            double dropDistance = this.fireBodyCrashMaxHeight - this.m_20186_();
            if (dropDistance >= 7.0) {
                this.triggerFireBodyCrash();
            }
            this.fireBodyCrashArmed = false;
            this.fireBodyCrashMaxHeight = 0.0;
        }
        if (!fireActive && !airborne) {
            this.fireBodyCrashArmed = false;
            this.fireBodyCrashMaxHeight = 0.0;
        }
    }

    private void triggerFireBodyCrash() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        ArrayList<Entity> immune = new ArrayList<Entity>(this.m_20197_());
        for (Entity passenger : immune) {
            if (!(passenger instanceof LivingEntity)) continue;
            LivingEntity livingPassenger = (LivingEntity)passenger;
            livingPassenger.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 4, true, false, false));
        }
        ExplosionDamageCalculator calculator = new ExplosionDamageCalculator(){

            @NotNull
            public Optional<Float> m_6617_(@NotNull Explosion explosion, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluid) {
                if (Cindervane.this.isFireBodyImmuneBlock(state)) {
                    return Optional.of(Float.valueOf(Float.MAX_VALUE));
                }
                return Optional.of(Float.valueOf(0.0f));
            }

            public boolean m_6714_(@NotNull Explosion explosion, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, float exposure) {
                return !Cindervane.this.isFireBodyImmuneBlock(state);
            }
        };
        Explosion explosion = new Explosion((Level)server, (Entity)this, server.m_269111_().m_269036_((Entity)this, (Entity)this), calculator, x, y + 0.2, z, 15.0f, true, Explosion.BlockInteraction.DESTROY);
        List<LivingEntity> allies = this.grantAlliesExplosionImmunity(server, x, y, z);
        for (LivingEntity ally : allies) {
            ally.m_20331_(true);
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        for (LivingEntity ally : allies) {
            ally.m_20331_(false);
        }
        this.applyFireBodyBlastDamage(server, x, y, z, immune);
        this.carveFireBodyImprint(server, BlockPos.m_274561_((double)x, (double)y, (double)z));
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y + 0.8, z, 150, 2.0, 1.0, 2.0, 0.2);
        server.m_8767_((ParticleOptions)ParticleTypes.f_175834_, x, y + 0.5, z, 120, 1.8, 0.8, 1.8, 0.15);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y + 0.5, z, 40, 1.3, 0.6, 1.3, 0.12);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y + 0.5, z, 80, 2.2, 0.7, 2.2, 0.05);
        BlockPos.MutableBlockPos flamePos = new BlockPos.MutableBlockPos();
        int baseY = this.m_146904_();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockState belowState;
                if (this.m_217043_().m_188501_() > 0.45f) continue;
                flamePos.m_122169_(x + (double)dx, (double)baseY, z + (double)dz);
                if (!server.m_46749_((BlockPos)flamePos) || !server.m_8055_((BlockPos)flamePos).m_60795_() || (belowState = server.m_8055_(flamePos.m_7495_())).m_60795_() || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)server, (BlockPos)flamePos)) continue;
                server.m_7731_((BlockPos)flamePos, Blocks.f_50083_.m_49966_(), 11);
            }
        }
        this.forceEndActiveAbility();
    }

    private boolean isFireBodyImmuneBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50752_) || state.m_60713_(Blocks.f_50080_);
    }

    private List<LivingEntity> grantAlliesExplosionImmunity(ServerLevel server, double x, double y, double z) {
        double radius = 19.0;
        AABB area = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List allies = server.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity != this && this.isAlly((Entity)entity));
        if (allies.isEmpty()) {
            return allies;
        }
        for (LivingEntity ally : allies) {
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 4, true, false, false));
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0, true, false, false));
            ally.m_7311_(0);
        }
        return allies;
    }

    private void applyFireBodyBlastDamage(ServerLevel server, double x, double y, double z, List<Entity> immune) {
        double radius = 17.5;
        AABB area = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        HashSet<Integer> immuneIds = new HashSet<Integer>();
        for (Entity entity : immune) {
            immuneIds.add(entity.m_19879_());
        }
        immuneIds.add(this.m_19879_());
        List targets = server.m_6443_(LivingEntity.class, area, living -> living.m_6084_() && !immuneIds.contains(living.m_19879_()) && !this.isAlly((Entity)living));
        if (targets.isEmpty()) {
            return;
        }
        for (LivingEntity target : targets) {
            if (!target.m_6469_(server.m_269111_().m_269036_((Entity)this, (Entity)this), 200.0f)) continue;
            target.m_20254_(8);
        }
    }

    private void carveFireBodyImprint(ServerLevel server, BlockPos center) {
        int radius = Mth.m_14165_((double)9.0);
        double radiusSq = 81.0;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double horizontalSq = dx * dx + dz * dz;
                if (horizontalSq > radiusSq) continue;
                double normalized = Math.sqrt(horizontalSq) / 9.0;
                double depth = (1.0 - normalized * normalized) * 5.3999999999999995;
                int maxDepth = Mth.m_14107_((double)depth);
                for (int dy = 0; dy <= maxDepth; ++dy) {
                    BlockState state;
                    cursor.m_122178_(center.m_123341_() + dx, center.m_123342_() - dy, center.m_123343_() + dz);
                    if (!server.m_46749_((BlockPos)cursor) || (state = server.m_8055_((BlockPos)cursor)).m_60795_() || this.isFireBodyImmuneBlock(state)) continue;
                    server.m_46953_((BlockPos)cursor, true, (Entity)this);
                }
            }
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.f_21344_ = this.groundNav;
            this.f_21342_ = new MoveControl((Mob)this);
            this.usingAirNav = false;
        }
    }

    public boolean isBreathingFire() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FIRE_BREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.f_19804_.m_135381_(DATA_FIRE_BREATHING, (Object)breathing);
    }

    @NotNull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        return new DragonPathNavigateGround((Mob)this, level);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movement = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::handleMovementAnimation);
        movement.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{movement});
        AnimationController banking = new AnimationController((GeoAnimatable)this, "banking", 10, this.animationHandler::bankingPredicate);
        controllers.add(new AnimationController[]{banking});
        AnimationController pitching = new AnimationController((GeoAnimatable)this, "pitching", 10, this.animationHandler::pitchingPredicate);
        controllers.add(new AnimationController[]{pitching});
        AnimationController actions = new AnimationController((GeoAnimatable)this, "actions", 5, this.animationHandler::actionPredicate);
        this.animationHandler.setupActionController((AnimationController<Cindervane>)actions);
        actions.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{actions});
        AnimationController HurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        HurtController.triggerableAnim("cindervane_hurt", RawAnimation.begin().thenPlay("animation.cindervane.hurt"));
        HurtController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{HurtController});
    }

    private void onAnimationSound(SoundKeyframeEvent<Cindervane> event) {
        this.soundHandler.handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return CindervaneSoundProfile.INSTANCE;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return CindervaneAbilities.BITE;
    }

    @Override
    public boolean hasSecondaryMelee() {
        return false;
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return CindervaneAbilities.ROAR;
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return CindervaneAbilities.HURT;
    }

    @Override
    public int getDeathAnimationDurationTicks() {
        return 95;
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.isDying()) {
            if (source.m_276093_(DamageTypes.f_286979_)) {
                return super.m_6469_(source, amount);
            }
            return false;
        }
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        if (this.handleLethalDamage(source, amount, CindervaneAbilities.DIE)) {
            return true;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    @Override
    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.combatManager.getActiveAbility();
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        this.combatManager.forceEndAbility(abilityType);
    }

    public void useRidingAbility(String abilityName) {
        Player player;
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (!(rider instanceof LivingEntity)) {
            return;
        }
        if (this.m_21824_() && rider instanceof Player && !this.m_21830_((LivingEntity)(player = (Player)rider))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type == CindervaneAbilities.BITE || type == CindervaneAbilities.FIRE_BODY || type == CindervaneAbilities.ROAR || type == CindervaneAbilities.FIRE_BREATH_VOLLEY) {
            this.combatManager.tryUseAbility(type);
        }
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
        this.fireBodyCrashArmed = false;
        this.setBreathingFire(false);
    }

    public boolean m_7327_(@NotNull Entity target) {
        if (!this.m_20160_() && !this.m_21827_()) {
            this.combatManager.tryUseAbility(CindervaneAbilities.BITE);
        }
        return true;
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public Vec3 getMouthPosition() {
        return this.computeMouthOrigin(1.0f);
    }

    public Vec3 computeMouthOrigin(float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)this.f_19854_, (double)this.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)this.f_19855_, (double)this.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)this.f_19856_, (double)this.m_20189_());
        float yawDeg = Mth.m_14179_((float)partialTicks, (float)this.f_20886_, (float)this.f_20885_);
        float pitchDeg = Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double R = -0.025;
        double U = 0.325;
        double F = 0.78125;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double up = U * cp - F * sp;
        double fwd = U * sp + F * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = R * cy - fwd * sy;
        double offZ = R * sy + fwd * cy;
        return new Vec3(x + offX, y + up, z + offZ);
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_150930_(Items.f_42526_) || stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42528_) || stack.m_150930_(Items.f_42581_);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult handlerResult = this.interactionHandler.handleInteraction(player, hand);
        if (handlerResult != InteractionResult.PASS) {
            return handlerResult;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob partner) {
        Cindervane baby = (Cindervane)ModEntities.CINDERVANE.get().m_20615_((Level)level);
        if (baby != null) {
            BlockPos safePos = this.findSafeBabySpawnPos((LevelAccessor)level, this.m_20183_());
            double spawnY = safePos != null ? (double)safePos.m_123342_() : this.m_20186_();
            baby.m_7678_(this.m_20185_(), spawnY, this.m_20189_(), this.m_146908_(), 0.0f);
        }
        return baby;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TimeFlying", this.timeFlying);
        this.saveRideableData(tag);
        this.restManager.save(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.loadRideableData(tag);
        boolean savedFlying = tag.m_128471_("Flying");
        this.timeFlying = tag.m_128451_("TimeFlying");
        if (!savedFlying) {
            this.landingTicks = 0;
            this.airTicks = 0;
        } else {
            this.airTicks = Math.max(this.airTicks, 1);
        }
        this.groundTicks = 0;
        this.m_20242_(this.m_29443_() || this.isHovering());
        this.restManager.load(tag);
        DragonRestState restState = this.restManager.getCurrentState();
        switch (restState) {
            case SLEEPING: {
                this.m_21839_(true);
                this.animationHandler.triggerSleepAnimation();
                break;
            }
            case SITTING_DOWN: 
            case SITTING: 
            case SITTING_AFTER: {
                this.m_21839_(true);
                break;
            }
            case FALLING_ASLEEP: {
                this.m_21839_(true);
                this.startSleepEnter();
                break;
            }
            case WAKING_UP: {
                this.m_21839_(true);
                this.startSleepExit();
                break;
            }
            case STANDING_UP: {
                this.m_21839_(false);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19797_ = 0;
        }
    }

    public void prepareForMounting() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_21839_(false);
        if (this.getCommand() == 1) {
            this.setCommand(0);
        }
        this.sitProgress = 0.0f;
        this.prevSitProgress = 0.0f;
        this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
        this.m_6710_(null);
        if (this.m_21573_().m_26570_() != null) {
            this.m_21573_().m_26573_();
        }
        this.clearStatesWhenMounted();
    }

    @Override
    protected boolean isDragonFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying == this.m_29443_()) {
            return;
        }
        this.f_19804_.m_135381_(DATA_FLYING, (Object)flying);
        if (flying) {
            this.switchToAirNavigation();
            this.setLanding(false);
            this.setTakeoff(true);
            this.m_21573_().m_26573_();
        } else {
            this.switchToGroundNavigation();
            this.setHovering(false);
            this.setTakeoff(false);
        }
    }

    @Override
    public boolean isTakeoff() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAKEOFF);
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        this.f_19804_.m_135381_(DATA_TAKEOFF, (Object)takeoff);
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOVERING);
    }

    @Override
    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(DATA_HOVERING, (Object)hovering);
    }

    @Override
    public boolean isLanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LANDING);
    }

    @Override
    public void setLanding(boolean landing) {
        this.f_19804_.m_135381_(DATA_LANDING, (Object)landing);
        this.landingTicks = 0;
        if (landing) {
            this.setHovering(false);
            this.setTakeoff(false);
        }
    }

    @Override
    public float getFlightSpeed() {
        return 0.5f;
    }

    @Override
    public double getPreferredFlightAltitude() {
        double base = 24.0 + this.m_217043_().m_188500_() * 10.0;
        return Mth.m_14008_((double)base, (double)20.0, (double)45.0);
    }

    @Override
    public boolean canTakeoff() {
        return !this.m_6162_() && !this.m_21827_() && this.m_6084_() && (this.m_20096_() || this.m_20069_());
    }

    @Override
    public void markLandedNow() {
        this.setLanding(false);
        this.setTakeoff(false);
        this.riderTakeoffTicks = 0;
    }

    public void setRiderTakeoffTicks(int ticks) {
        this.riderTakeoffTicks = Math.max(0, ticks);
    }

    public boolean m_142535_(float fallDistance, float fallMultiplier, @NotNull DamageSource source) {
        if (this.m_29443_() || this.isTakeoff() || this.isLanding()) {
            return false;
        }
        return super.m_142535_(fallDistance, fallMultiplier, source);
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.m_20184_().f_82480_ > -0.1;
    }

    public boolean canBeBound() {
        return !this.m_29443_() && !this.isDying() && !this.isAccelerating();
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return CindervaneAbilities.FIRE_BREATH_VOLLEY;
    }

    public void m_7822_(byte eventId) {
        if (eventId == 6) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(eventId);
        }
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float current = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
        return this.prevScreenShakeAmount + (current - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 18.0;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        this.screenShakeAmount = Math.max(this.screenShakeAmount, intensity);
        this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.m_9236_().f_46443_) {
            if (this.getSitProgress() >= this.maxSitTicks()) {
                if (this.sleepTransitionTicks > 60) {
                    this.animationHandler.triggerFallAsleepAnimation();
                    this.sleepTransitionTicks = 60;
                }
            } else {
                this.sleepTransitionTicks = 61;
                return;
            }
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                    this.animationHandler.triggerSleepAnimation();
                } else if (this.isSleepingExiting()) {
                    this.setSleepingExiting(false);
                    this.sleepAmbientCooldownTicks = 10;
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    @Override
    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.f_19804_.m_135381_(DATA_SLEEPING_ENTERING, (Object)entering);
    }

    public boolean isSleepingExiting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.f_19804_.m_135381_(DATA_SLEEPING_EXITING, (Object)exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        int snapshot = this.getCommand();
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = snapshot;
            if (this.getCommand() != 1) {
                this.setCommand(1);
                this.m_21839_(true);
            }
        }
    }

    private void releaseSleepLock() {
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired >= 0 && desired != this.getCommand()) {
                this.setCommand(desired);
                this.m_21839_(desired == 1);
            }
        }
    }

    @Override
    public void startSleepEnter() {
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepTransitionTicks = 61;
        if (!this.m_9236_().f_46443_) {
            this.enterSleepLock();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.m_5803_() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepTransitionTicks = 42;
        this.animationHandler.triggerWakeUpAnimation();
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void wakeUpImmediately() {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepCancelTicks = 2;
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0;
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(true, false, true, true, true);
    }

    @Override
    public boolean canSleepNow() {
        return !this.isBreathingFire() && !this.m_20160_() && this.getActiveAbility() == null;
    }
}

