/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record RaevyxInteractionHandler(Raevyx wyvern) {
    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        if (this.wyvern.isDying()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.wyvern.m_21824_()) {
            return this.handleUntamedInteraction(player, itemstack);
        }
        return this.handleTamedInteraction(player, itemstack, hand);
    }

    private InteractionResult handleUntamedInteraction(Player player, ItemStack itemstack) {
        if (!this.wyvern.m_6898_(itemstack)) {
            return InteractionResult.PASS;
        }
        if (!this.wyvern.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            if (this.wyvern.m_217043_().m_188503_(10) == 0) {
                this.wyvern.m_21828_(player);
                this.wyvern.m_21839_(true);
                this.wyvern.setCommandManual(1);
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)7);
                this.triggerTamingAdvancement(player);
            } else {
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)6);
            }
        }
        return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
    }

    private InteractionResult handleTamedInteraction(Player player, ItemStack itemstack, InteractionHand hand) {
        boolean isOwner = player.equals((Object)this.wyvern.m_269323_());
        if (this.wyvern.m_6898_(itemstack)) {
            if (player.m_6047_() && isOwner) {
                return this.handleBreeding(player, itemstack);
            }
            return this.handleFeeding(player, itemstack);
        }
        if (isOwner) {
            boolean isSleeping;
            boolean bl = isSleeping = this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning();
            if (this.canOwnerCommand(player) && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                if (isSleeping) {
                    if (!this.wyvern.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.raevyx.sleeping", (Object[])new Object[]{this.wyvern.m_7755_()}), true);
                    }
                    return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
                }
                return this.handleCommandCycling(player);
            }
            if (!player.m_6047_() && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND && this.canOwnerMount(player)) {
                return this.handleMounting(player);
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleBreeding(Player player, ItemStack itemstack) {
        boolean client = this.wyvern.m_9236_().f_46443_;
        if (this.wyvern.m_6162_()) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_too_young");
            return InteractionResult.m_19078_((boolean)client);
        }
        if (this.wyvern.m_146764_() != 0) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_cooling_down");
            return InteractionResult.m_19078_((boolean)client);
        }
        if (this.wyvern.m_27593_()) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_already_ready");
            return InteractionResult.m_19078_((boolean)client);
        }
        if (!client) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            this.wyvern.m_27595_(player);
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_ready");
        }
        return InteractionResult.m_19078_((boolean)client);
    }

    private InteractionResult handleFeeding(Player player, ItemStack itemstack) {
        if (!this.wyvern.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            if (this.wyvern.m_6162_()) {
                int currentAge = this.wyvern.m_146764_();
                int newAge = Math.min(0, currentAge + 2400);
                this.wyvern.m_146762_(newAge);
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)6);
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)7);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int remainingTicks = Math.abs(newAge);
                    int remainingMinutes = remainingTicks / 1200;
                    String messageKey = newAge == 0 ? "entity.saintsdragons.raevyx.baby_grown" : "entity.saintsdragons.raevyx.baby_fed";
                    serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.wyvern.m_7755_()}), true);
                }
            } else {
                float healAmount = 10.0f;
                float oldHealth = this.wyvern.m_21223_();
                float newHealth = Math.min(oldHealth + healAmount, this.wyvern.m_21233_());
                this.wyvern.m_21153_(newHealth);
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)6);
                this.wyvern.m_9236_().m_7605_((Entity)this.wyvern, (byte)7);
                this.sendFeedingMessage(player, newHealth);
            }
        }
        return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
    }

    private InteractionResult handleCommandCycling(Player player) {
        boolean isTransitioning = this.wyvern.isInSitTransition();
        if (isTransitioning) {
            if (!this.wyvern.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean sittingDown = this.wyvern.isSittingDownAnimation();
                String messageKey = sittingDown ? "entity.saintsdragons.raevyx.sitting_down" : "entity.saintsdragons.raevyx.standing_up";
                serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.wyvern.m_7755_()}), true);
            }
            return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
        }
        int currentCommand = this.wyvern.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.wyvern.setCommandManual(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.wyvern.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.wyvern.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.wyvern.m_21839_(false);
                break;
            }
            case 1: {
                this.wyvern.m_21839_(true);
                break;
            }
            case 2: {
                this.wyvern.m_21839_(false);
            }
        }
    }

    private void sendStatusMessage(Player player, String key) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)Component.m_237110_((String)key, (Object[])new Object[]{this.wyvern.m_7755_()}), true);
        }
    }

    private InteractionResult handleMounting(Player player) {
        if (this.wyvern.m_20160_()) {
            return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
        }
        if (this.wyvern.m_21827_()) {
            this.wyvern.m_21839_(false);
        }
        if (this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning()) {
            this.wyvern.wakeUpImmediately();
            this.wyvern.suppressSleep(300);
        }
        this.wyvern.clearAllStatesForMounting();
        if (player.m_20329_((Entity)this.wyvern)) {
            this.wyvern.playExcitedSound();
            return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
        }
        return InteractionResult.m_19078_((boolean)this.wyvern.m_9236_().f_46443_);
    }

    private void triggerTamingAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.wyvern.isFemale()) {
                Advancement femaleAdvancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_raevyx_female"));
                if (femaleAdvancement != null) {
                    serverPlayer.m_8960_().m_135988_(femaleAdvancement, "tame_raevyx_female");
                }
            } else {
                Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_raevyx"));
                if (advancement != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "tame_raevyx");
                }
            }
        }
    }

    private void sendFeedingMessage(Player player, float newHealth) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String messageKey = newHealth >= this.wyvern.m_21233_() ? "entity.saintsdragons.raevyx.fed" : "entity.saintsdragons.raevyx.fed_partial";
            serverPlayer.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.wyvern.m_7755_()}), true);
        }
    }

    private boolean canOwnerCommand(Player player) {
        return this.wyvern.canOwnerCommand(player);
    }

    private boolean canOwnerMount(Player player) {
        return this.wyvern.canOwnerMount(player);
    }
}

