/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.stegonaut;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.stegonaut.StegonautAbilities;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautFleeFromPredatorsGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautLeaveWaterGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautLookAtPlayerGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautNapGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautRandomLookAroundGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautSleepGoal;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.ability.abilities.stegonaut.StegonautPassiveBuffAbility;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers.StegonautAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers.StegonautSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Stegonaut
extends DragonEntity
implements DragonSleepCapable,
SoundHandledDragon {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final StegonautAnimationHandler animationController = new StegonautAnimationHandler(this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final DragonRestManager restManager = new DragonRestManager((LivingEntity)this);
    private final StegonautPassiveBuffAbility passiveBuffAbility = new StegonautPassiveBuffAbility(this);
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final int MIN_AMBIENT_DELAY = 200;
    private static final int MAX_AMBIENT_DELAY = 600;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.stegonaut.grumble1", ModSounds.STEGONAUT_GRUMBLE_1, 0.6f, 1.1f, 0.2f, false, false, true).add("grumble2", "action", "animation.stegonaut.grumble2", ModSounds.STEGONAUT_GRUMBLE_2, 0.6f, 1.1f, 0.2f, false, false, true).add("grumble3", "action", "animation.stegonaut.grumble3", ModSounds.STEGONAUT_GRUMBLE_3, 0.6f, 1.1f, 0.2f, false, false, true).add("hurt", "action", "animation.stegonaut.hurt", ModSounds.STEGONAUT_HURT, 1.0f, 0.95f, 0.1f, false, true, true).add("die", "action", "animation.stegonaut.die", ModSounds.STEGONAUT_DIE, 1.2f, 1.0f, 0.0f, false, true, true).build();
    private boolean sleeping = false;
    private boolean sleepTransitioning = false;
    private int napTicks = 0;
    private int napCooldown = 0;
    private boolean dayNapQueued = false;
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Stegonaut.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_GROUND_MOVE_STATE = SynchedEntityData.m_135353_(Stegonaut.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean boundToBinder = false;
    private static final int CLIENT_GROUND_STATE_STABLE_TICKS = 3;
    private int clientGroundMoveState = 0;
    private int clientGroundMoveTarget = 0;
    private int clientGroundMoveHold = 0;
    private int walkAnimationHoldTicks = 0;
    private int grumbleCooldown = 0;

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return StegonautSoundProfile.INSTANCE;
    }

    public Stegonaut(EntityType<? extends Stegonaut> entityType, Level level) {
        super(entityType, level);
        this.animationController.initializeAnimation();
        RandomSource rng = this.m_217043_();
        this.ambientSoundTimer = rng.m_188503_(80);
        this.nextAmbientSoundDelay = 200 + rng.m_188503_(400);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_GROUND_MOVE_STATE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new StegonautSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new StegonautLeaveWaterGoal(this, 1.15));
        this.f_21345_.m_25352_(2, (Goal)new StegonautFleeFromPredatorsGoal(this, 0.6, 12.0));
        this.f_21345_.m_25352_(3, (Goal)new StegonautFollowOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new StegonautNapGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new StegonautGroundWanderGoal(this, 0.35, 120));
        this.f_21345_.m_25352_(6, (Goal)new StegonautLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new StegonautRandomLookAroundGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    public boolean m_29443_() {
        return false;
    }

    @Override
    public boolean isStayOrSitMuted() {
        return this.m_21827_() || this.m_21825_();
    }

    @Override
    public boolean canOwnerCommand(Player player) {
        return player != null && player.equals((Object)this.m_269323_());
    }

    public boolean isTameable() {
        return true;
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_150930_(Items.f_42579_) || stack.m_150930_(Items.f_42485_) || stack.m_150930_(Items.f_42581_) || stack.m_150930_(Items.f_42658_) || stack.m_150930_(Items.f_42526_) || stack.m_150930_(Items.f_42527_);
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public Vec3 getMouthPosition() {
        return this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.8, 0.0);
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return null;
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return StegonautAbilities.STEGONAUT_HURT;
    }

    @Override
    public int getDeathAnimationDurationTicks() {
        return 75;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.isDying()) {
            if (source.m_276093_(DamageTypes.f_286979_)) {
                return super.m_6469_(source, amount);
            }
            return false;
        }
        if (this.handleLethalDamage(source, amount, StegonautAbilities.STEGONAUT_DIE)) {
            return true;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 1, this.animationController::handleMovementAnimation);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{movementController});
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 1, this.animationController::actionPredicate);
        this.animationController.setupActionController((AnimationController<Stegonaut>)actionController);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{actionController});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob other) {
        Stegonaut baby = (Stegonaut)ModEntities.STEGONAUT.get().m_20615_((Level)level);
        if (baby != null) {
            BlockPos safePos = this.findSafeBabySpawnPos((LevelAccessor)level, this.m_20183_());
            double spawnY = safePos != null ? (double)safePos.m_123342_() : this.m_20186_();
            baby.m_7678_(this.m_20185_(), spawnY, this.m_20189_(), this.m_146908_(), 0.0f);
        }
        return baby;
    }

    public static boolean canSpawnHere(EntityType<? extends Stegonaut> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!Animal.m_218104_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (!level.m_6425_(pos.m_7495_()).m_76178_()) {
            return false;
        }
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_21824_()) {
            return this.handleUntamedInteraction(player, hand);
        }
        return this.handleTamedInteraction(player, hand);
    }

    private InteractionResult handleUntamedInteraction(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_6898_(itemstack)) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.triggerAnim("action", "eat");
            this.m_21828_(player);
            this.m_21839_(true);
            this.setCommand(1);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            player.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.stegonaut.tamed", (Object[])new Object[]{this.m_7755_()}), true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragonsCommon.rl("tame_stegonaut"));
                if (advancement != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "tame_stegonaut");
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private InteractionResult handleTamedInteraction(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_6898_(itemstack)) {
            return this.handleFeeding(player, itemstack);
        }
        if (player.equals((Object)this.m_269323_()) && this.canOwnerCommand(player) && itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
            return this.handleCommandCycling(player);
        }
        return super.m_6071_(player, hand);
    }

    private InteractionResult handleFeeding(Player player, ItemStack itemstack) {
        if (!this.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.triggerAnim("action", "eat");
            float healAmount = 8.0f;
            float oldHealth = this.m_21223_();
            float newHealth = Math.min(oldHealth + healAmount, this.m_21233_());
            this.m_21153_(newHealth);
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            String messageKey = newHealth >= this.m_21233_() ? "entity.saintsdragons.stegonaut.fed" : "entity.saintsdragons.stegonaut.fed_partial";
            player.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{this.m_7755_()}), true);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private InteractionResult handleCommandCycling(Player player) {
        int currentCommand = this.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.m_21839_(false);
                break;
            }
            case 1: {
                this.m_21839_(true);
                break;
            }
            case 2: {
                this.m_21839_(false);
            }
        }
    }

    public void refreshCommandState() {
        this.applyCommandState(this.getCommand());
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    public void playRandomGrumble() {
        if (this.m_9236_().f_46443_ || this.isDying()) {
            return;
        }
        float grumbleChance = this.m_217043_().m_188501_();
        String vocalKey = grumbleChance < 0.4f ? "grumble1" : (grumbleChance < 0.7f ? "grumble2" : "grumble3");
        this.getSoundHandler().playVocal(vocalKey);
    }

    private void playCustomAmbientSound() {
        RandomSource random = this.m_217043_();
        if (this.isDying() || this.m_5448_() != null) {
            return;
        }
        String vocalKey = null;
        float moodRoll = random.m_188501_();
        vocalKey = moodRoll < 0.4f ? "grumble1" : (moodRoll < 0.7f ? "grumble2" : "grumble3");
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.isDying() || this.m_5803_() || this.isSleepTransitioning()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void resetAmbientSoundTimer() {
        RandomSource random = this.m_217043_();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.m_188503_(400);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.tickAnimationStates();
        }
    }

    @Override
    public boolean m_5803_() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING) : this.sleeping;
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.sleepTransitioning;
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.m_5448_() != null || this.m_20072_() || this.m_20160_();
    }

    @Override
    public void startSleepEnter() {
        if (!this.sleeping && !this.sleepTransitioning) {
            this.sleepTransitioning = true;
            this.sleeping = true;
            this.f_19804_.m_135381_(DATA_SLEEPING, (Object)true);
            this.m_21839_(true);
        }
    }

    @Override
    public void startSleepExit() {
        if (this.sleeping && !this.sleepTransitioning) {
            this.sleepTransitioning = true;
            this.sleeping = false;
            this.f_19804_.m_135381_(DATA_SLEEPING, (Object)false);
            this.refreshCommandState();
        }
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(true, true, false, false, false);
    }

    @Override
    public boolean canSleepNow() {
        if (this.m_9236_().m_46461_()) {
            if (this.napCooldown <= 0 && this.m_217043_().m_188501_() < 0.01f) {
                this.dayNapQueued = true;
                return true;
            }
            this.dayNapQueued = false;
            return false;
        }
        this.dayNapQueued = false;
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.soundHandler.tick();
        if (!this.m_9236_().f_46443_) {
            this.handleAmbientSounds();
        }
        if (this.m_6084_()) {
            this.passiveBuffAbility.tick();
        } else {
            this.passiveBuffAbility.cleanup();
        }
        if (this.sleepTransitioning) {
            this.sleepTransitioning = false;
        }
        if (this.napTicks > 0) {
            --this.napTicks;
            if (this.napTicks <= 0) {
                if (this.sleeping) {
                    this.startSleepExit();
                }
                this.napCooldown = 1200 + this.m_217043_().m_188503_(1800);
            }
        }
        if (this.napCooldown > 0) {
            --this.napCooldown;
        }
        if (this.grumbleCooldown > 0) {
            --this.grumbleCooldown;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_21827_()) {
                if (this.sitProgress < this.maxSitTicks()) {
                    this.sitProgress += 1.0f;
                    this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
                }
            } else if (this.sitProgress > 0.0f) {
                this.sitProgress -= 1.0f;
                if (this.sitProgress < 0.0f) {
                    this.sitProgress = 0.0f;
                }
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
        if (this.m_9236_().f_46443_) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    public void startNap() {
        if (!this.sleeping && this.napCooldown <= 0) {
            this.napTicks = 1200 + this.m_217043_().m_188503_(1200);
        }
    }

    public boolean isDayNapQueued() {
        return this.dayNapQueued;
    }

    public boolean consumeDayNapQueued() {
        boolean queued = this.dayNapQueued;
        this.dayNapQueued = false;
        return queued;
    }

    public void onAnimationSound(SoundKeyframeEvent<Stegonaut> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (this.m_9236_().f_46443_) {
            this.clientLocatorCache.put(name, pos);
        }
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        return this.clientLocatorCache.get(name);
    }

    @Override
    public boolean isWalking() {
        if (this.m_9236_().f_46443_) {
            int s = this.getEffectiveGroundState();
            return s == 1;
        }
        int s = (Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE);
        return s == 1;
    }

    @Override
    public boolean isRunning() {
        if (this.m_9236_().f_46443_) {
            int s = this.getEffectiveGroundState();
            return s == 2;
        }
        int s = (Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE);
        return s == 2;
    }

    public int getEffectiveGroundState() {
        if (this.m_9236_().f_46443_) {
            int syncedState = (Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE);
            if (this.clientGroundMoveTarget != syncedState) {
                this.clientGroundMoveTarget = syncedState;
                this.clientGroundMoveHold = 0;
            } else if (this.clientGroundMoveState != this.clientGroundMoveTarget) {
                ++this.clientGroundMoveHold;
                if (this.clientGroundMoveHold >= 3) {
                    this.clientGroundMoveState = this.clientGroundMoveTarget;
                    this.clientGroundMoveHold = 0;
                }
            } else {
                this.clientGroundMoveHold = 0;
            }
            if (this.m_5803_() || this.m_21827_()) {
                this.clientGroundMoveState = 0;
                this.clientGroundMoveTarget = 0;
                this.clientGroundMoveHold = 0;
            }
            return this.clientGroundMoveState;
        }
        return (Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE);
    }

    private void tickAnimationStates() {
        int moveState = 0;
        if (!this.m_5803_() && !this.m_21827_()) {
            boolean isActuallyMoving;
            boolean hasActivePath = this.m_21573_().m_26572_();
            boolean bl = isActuallyMoving = this.m_20184_().m_165925_() > 0.001;
            if (hasActivePath || isActuallyMoving) {
                moveState = 1;
                this.walkAnimationHoldTicks = 8;
            } else if (this.walkAnimationHoldTicks > 0) {
                moveState = 1;
                --this.walkAnimationHoldTicks;
            }
        } else {
            this.walkAnimationHoldTicks = 0;
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != moveState) {
            this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)moveState);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("StegonautCommand", this.getCommand());
        tag.m_128379_("StegonautOrderedSit", this.m_21827_());
        tag.m_128379_("Sleeping", this.sleeping);
        tag.m_128379_("SleepTransitioning", this.sleepTransitioning);
        tag.m_128405_("NapTicks", this.napTicks);
        tag.m_128405_("NapCooldown", this.napCooldown);
        tag.m_128405_("GrumbleCooldown", this.grumbleCooldown);
        tag.m_128379_("BoundToBinder", this.boundToBinder);
        tag.m_128350_("SitProgress", this.sitProgress);
        this.restManager.save(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        int restoredCommand = this.getCommand();
        if (tag.m_128441_("StegonautCommand")) {
            restoredCommand = tag.m_128451_("StegonautCommand");
            this.setCommand(restoredCommand);
        }
        boolean restoredOrderedSit = tag.m_128441_("StegonautOrderedSit") ? tag.m_128471_("StegonautOrderedSit") : restoredCommand == 1;
        this.sleeping = tag.m_128471_("Sleeping");
        this.sleepTransitioning = tag.m_128471_("SleepTransitioning");
        this.napTicks = tag.m_128451_("NapTicks");
        this.napCooldown = tag.m_128451_("NapCooldown");
        this.grumbleCooldown = tag.m_128451_("GrumbleCooldown");
        this.boundToBinder = tag.m_128471_("BoundToBinder");
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)this.sleeping);
        if (tag.m_128441_("SitProgress")) {
            this.sitProgress = tag.m_128457_("SitProgress");
            this.f_19804_.m_135381_(DragonEntity.DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
        this.refreshCommandState();
        this.m_21839_(restoredOrderedSit);
        this.restManager.load(tag);
    }

    public boolean isBoundToBinder() {
        return this.boundToBinder;
    }

    public void setBoundToBinder(boolean bound) {
        this.boundToBinder = bound;
    }

    public boolean canBeBound() {
        return !this.m_5803_() && !this.isDying();
    }
}

