/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.api.DimensionLike;
import io.hotwop.worldmagic.api.LocationResolver;
import io.hotwop.worldmagic.api.MagicWorld;
import io.hotwop.worldmagic.api.WorldAlreadyLoadedException;
import io.hotwop.worldmagic.api.WorldAlreadyUnloadedException;
import io.hotwop.worldmagic.api.WorldLoadException;
import io.hotwop.worldmagic.api.WorldUnloadException;
import io.hotwop.worldmagic.api.settings.AllowSettings;
import io.hotwop.worldmagic.api.settings.CustomWorldSettings;
import io.hotwop.worldmagic.api.settings.Loading;
import io.hotwop.worldmagic.api.settings.SpawnPosition;
import io.hotwop.worldmagic.api.settings.WorldBorderSettings;
import io.hotwop.worldmagic.api.settings.WorldProperties;
import io.hotwop.worldmagic.file.FileUtil;
import io.hotwop.worldmagic.file.WorldFile;
import io.hotwop.worldmagic.generation.Dimension;
import io.hotwop.worldmagic.generation.GameRuleFactory;
import io.hotwop.worldmagic.generation.GeneratorSettings;
import io.hotwop.worldmagic.util.VersionUtil;
import io.papermc.paper.FeatureHooks;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.validation.ContentValidationException;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomWorld
implements MagicWorld {
    private static final ExecutorService threadManager = Executors.newCachedThreadPool();
    private static final Method vanillaSetSpawn;
    private static final Field ioExecutorField;
    private static final NamespacedKey overworld;
    private static boolean shutdown;
    public final NamespacedKey id;
    public final String bukkitId;
    public final String folder;
    public final WorldProperties worldProperties;
    public final Dimension dimension;
    public final Loading loading;
    public final SpawnPosition spawnPosition;
    public final LocationResolver callbackLocation;
    public final AllowSettings allowSettings;
    public final GameRuleFactory gamerules;
    public final WorldBorderSettings border;
    public final Path folderPath;
    public final ResourceLocation vanillaLocId;
    public final ResourceKey<LevelStem> vanillaId;
    public final ResourceKey<Level> vanillaLevelId;
    public final ResourceKey<LevelStem> dimensionId;
    public final LevelStem stem;
    private boolean loaded = false;
    private boolean forDeletion = false;
    private World bukkitWorld = null;
    private ServerLevel level = null;

    public static void shutdownAsync() {
        if (shutdown) {
            return;
        }
        shutdown = true;
        threadManager.shutdown();
        try {
            threadManager.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            threadManager.shutdownNow();
        }
    }

    @Override
    public NamespacedKey id() {
        return this.id;
    }

    @Override
    public String bukkitId() {
        return this.bukkitId;
    }

    @Override
    public String folder() {
        return this.folder;
    }

    @Override
    public Path folderPath() {
        return this.folderPath;
    }

    @Override
    public DimensionLike dimension() {
        return this.dimension;
    }

    @Override
    public WorldProperties worldProperties() {
        return this.worldProperties;
    }

    @Override
    public AllowSettings allowSettings() {
        return this.allowSettings;
    }

    @Override
    public CustomWorldSettings createSettings(@NotNull NamespacedKey id) {
        Objects.requireNonNull(id, "id");
        return this.createSettings(id, (String)(id.namespace().equals("minecraft") ? id.value() : id.namespace() + "_" + id.value()));
    }

    @Override
    public CustomWorldSettings createSettings(@NotNull NamespacedKey id, @NotNull String bukkitId) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(bukkitId, "bukkitId");
        return this.createSettings(id, bukkitId, bukkitId);
    }

    @Override
    public CustomWorldSettings createSettings(@NotNull NamespacedKey id, @NotNull String bukkitId, @NotNull String folder) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(bukkitId, "bukkitId");
        Objects.requireNonNull(folder, "folder");
        CustomWorldSettings out = new CustomWorldSettings(id, bukkitId, folder);
        out.setWorldProperties(this.worldProperties);
        out.setDimension(this.dimension);
        out.setLoadingSettings(this.loading);
        out.setAllowSettings(this.allowSettings);
        out.setWorldBorderSettings(this.border);
        if (this.spawnPosition != null) {
            out.setSpawn(this.spawnPosition);
        }
        if (this.callbackLocation != null) {
            out.setCallbackLocation(this.callbackLocation);
        }
        FileUtil.fromFactory(out.gameRuleSet(), this.gamerules);
        out.setGameRuleOverride(this.gamerules.override);
        return out;
    }

    @Override
    public boolean loaded() {
        return this.loaded;
    }

    @Override
    public World world() {
        if (!this.loaded) {
            return null;
        }
        return this.bukkitWorld;
    }

    public ServerLevel level() {
        if (!this.loaded) {
            return null;
        }
        return this.level;
    }

    @Override
    public Location callbackLocation() {
        if (this.callbackLocation == null) {
            return Bukkit.getWorld((NamespacedKey)overworld).getSpawnLocation();
        }
        try {
            return this.callbackLocation.resolve();
        }
        catch (LocationResolver.ResolveException e) {
            return Bukkit.getWorld((NamespacedKey)overworld).getSpawnLocation();
        }
    }

    @Override
    public boolean isForDeletion() {
        return this.forDeletion;
    }

    protected CustomWorld(WorldFile file) {
        this(file.id, file.bukkitId, file.folder, file);
    }

    protected CustomWorld(NamespacedKey id, String bukkitId, String folder, WorldFile file) {
        this.id = id;
        this.vanillaLocId = VersionUtil.createResourceLocation(id);
        this.vanillaId = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)this.vanillaLocId);
        this.vanillaLevelId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.vanillaLocId);
        this.bukkitId = bukkitId == null ? (id.namespace().equals("minecraft") ? id.value() : id.namespace() + "_" + id.value()) : bukkitId;
        this.folder = folder == null ? this.bukkitId : folder;
        this.folderPath = Bukkit.getWorldContainer().toPath().resolve(this.folder);
        this.worldProperties = FileUtil.fromFile(file.worldProperties);
        this.dimension = file.dimension;
        this.loading = FileUtil.fromFile(file.loading);
        this.spawnPosition = file.spawnPosition == null ? null : FileUtil.fromFile(file.spawnPosition);
        this.callbackLocation = file.callbackLocation;
        this.allowSettings = FileUtil.fromFile(file.allowSettings);
        this.gamerules = file.gamerules;
        this.border = FileUtil.fromFile(file.border);
        Dimension dimension = this.dimension;
        if (dimension instanceof Dimension.Reference) {
            Dimension.Reference ref = (Dimension.Reference)dimension;
            this.dimensionId = ref.getKey();
        } else {
            this.dimensionId = this.vanillaId;
        }
        this.stem = this.dimension.get();
    }

    protected CustomWorld(CustomWorldSettings settings) {
        this.id = settings.id;
        this.bukkitId = settings.bukkitId;
        this.folder = settings.folder;
        this.vanillaLocId = VersionUtil.createResourceLocation(this.id);
        this.vanillaId = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)this.vanillaLocId);
        this.vanillaLevelId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.vanillaLocId);
        this.folderPath = Bukkit.getWorldContainer().toPath().resolve(this.folder);
        this.worldProperties = settings.worldProperties() == null ? new WorldProperties(true, null, true, false, null, Difficulty.NORMAL, null, null) : settings.worldProperties();
        DimensionLike dimensionLike = settings.dimension();
        if (!(dimensionLike instanceof Dimension)) {
            throw new RuntimeException("Don't try to spoof DimensionLike!");
        }
        Dimension dim = (Dimension)dimensionLike;
        this.dimension = dim;
        this.loading = settings.loadingSettings() == null ? new Loading(false, true, true, false, true) : settings.loadingSettings();
        this.spawnPosition = settings.spawn();
        this.callbackLocation = settings.callbackLocation();
        this.allowSettings = settings.allowSettings() == null ? new AllowSettings(true, true, true) : settings.allowSettings();
        this.gamerules = FileUtil.toFactory(settings.gameRuleSet(), settings.isGameRuleOverride());
        this.border = settings.worldBorderSettings() == null ? new WorldBorderSettings(false, 2.9999984E7, 5.0, 0.2, 0.0, 0.0, 5, 300) : settings.worldBorderSettings();
        Dimension dimension = this.dimension;
        if (dimension instanceof Dimension.Reference) {
            Dimension.Reference ref = (Dimension.Reference)dimension;
            this.dimensionId = ref.getKey();
        } else {
            this.dimensionId = this.vanillaId;
        }
        this.stem = this.dimension.get();
    }

    @Override
    public void load() {
        if (shutdown) {
            return;
        }
        if (this.loaded) {
            throw new WorldAlreadyLoadedException();
        }
        if (this.forDeletion) {
            throw new WorldLoadException("World for deletion!");
        }
        this.loaded = true;
        if (this.loading.async()) {
            threadManager.execute(this::loadProcess);
        } else if (WorldMagic.vanillaServer().isSameThread()) {
            this.loadProcess();
        } else {
            WorldMagic.scheduler().runTask((Plugin)WorldMagic.instance(), this::loadProcess);
        }
    }

    @Override
    public void unload() {
        if (shutdown) {
            return;
        }
        if (!this.loaded) {
            throw new WorldAlreadyUnloadedException();
        }
        this.loaded = false;
        List players = List.copyOf(this.level.players());
        if (this.loading.save() && Bukkit.isStopping() || players.isEmpty()) {
            if (WorldMagic.vanillaServer().isSameThread()) {
                this.unloadProcess();
            } else {
                WorldMagic.scheduler().runTask((Plugin)WorldMagic.instance(), this::unloadProcess);
            }
        } else {
            AtomicInteger task = new AtomicInteger(players.size());
            Location loc = this.callbackLocation();
            players.forEach(pl -> pl.getBukkitEntity().teleportAsync(loc).thenAccept(done -> {
                if (!done.booleanValue()) {
                    pl.getBukkitEntity().teleport(loc);
                }
                if (task.addAndGet(-1) == 0) {
                    this.unloadProcess();
                }
            }));
        }
    }

    protected void forDeletion() {
        this.forDeletion = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProcess() {
        boolean init;
        org.bukkit.generator.ChunkGenerator chunkGenerator;
        Object oldLevelData;
        PrimaryLevelData levelData;
        PrimaryLevelData.SpecialWorldProperty specialProperty;
        Registry dimensionRegistry;
        GeneratorSettings.Vanilla generator;
        Object pluginBiomeProvider;
        LevelStorageSource.LevelStorageAccess levelStorage;
        block41: {
            Dynamic save;
            block40: {
                if (this.checkDuplication()) {
                    this.loaded = false;
                    throw new WorldLoadException("world with that vanilla id or bukkit id already loaded");
                }
                if (this.folderPath.toFile().isFile()) {
                    this.loaded = false;
                    throw new WorldLoadException("world \"folder\" already defined as file");
                }
                WorldMagic.logger().info("Creating world {}", (Object)this.id.asString());
                Path container = this.folderPath.getParent();
                String folderName = container.relativize(this.folderPath).toString();
                try {
                    levelStorage = LevelStorageSource.createDefault((Path)container).validateAndCreateAccess(folderName, this.dimensionId);
                }
                catch (IOException | ContentValidationException e) {
                    this.loaded = false;
                    throw new WorldLoadException("error to start folder session: " + String.valueOf(e));
                }
                if (levelStorage.hasWorldData()) {
                    LevelSummary worldinfo;
                    try {
                        save = levelStorage.getDataTag();
                        worldinfo = levelStorage.getSummary(save);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception) {
                        LevelStorageSource.LevelDirectory directory = levelStorage.getLevelDirectory();
                        WorldMagic.logger().warn("Failed to load world {} data from {}", new Object[]{this.id.asString(), directory.dataFile(), ioexception});
                        WorldMagic.logger().info("Attempting to use fallback");
                        try {
                            save = levelStorage.getDataTagFallback();
                            worldinfo = levelStorage.getSummary(save);
                        }
                        catch (IOException | NbtException | ReportedNbtException e) {
                            this.loaded = false;
                            throw new WorldLoadException("Error to load world data from " + String.valueOf(directory.dataFile()) + ": " + String.valueOf(e));
                        }
                        levelStorage.restoreLevelDataFromOld();
                    }
                    if (worldinfo.requiresManualConversion()) {
                        this.loaded = false;
                        throw new WorldLoadException("World must be opened in an older version (like 1.6.4) to be safely converted");
                    }
                    if (!worldinfo.isCompatible()) {
                        this.loaded = false;
                        throw new WorldLoadException("World was created by an incompatible version");
                    }
                } else {
                    save = null;
                }
                if (this.dimension instanceof Dimension.Reference) {
                    pluginBiomeProvider = null;
                    generator = new GeneratorSettings.Vanilla(this.stem.generator());
                } else {
                    Dimension dimension = this.dimension;
                    if (!(dimension instanceof Dimension.Inline)) throw new WorldLoadException("Unexpected exception");
                    Dimension.Inline inline = (Dimension.Inline)dimension;
                    try {
                        Object object;
                        NamespacedKey typ = object = inline.dimensionType();
                        Object gen = object = inline.generator();
                        Object pluginBiomes = object = inline.pluginBiomes();
                        generator = gen;
                        pluginBiomeProvider = pluginBiomes;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (save != null && !this.worldProperties.override()) break block40;
                WorldDimensions worldDimensions = VersionUtil.createWorldDimensions(generator.create());
                MappedRegistry writableDimensionRegistry = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.experimental());
                worldDimensions.dimensions().forEach((arg_0, arg_1) -> CustomWorld.lambda$loadProcess$2((WritableRegistry)writableDimensionRegistry, arg_0, arg_1));
                dimensionRegistry = writableDimensionRegistry.freeze();
                specialProperty = CustomWorld.specialWorldProperty(generator);
                levelData = this.getPrimaryLevelData((Registry<LevelStem>)dimensionRegistry, specialProperty);
                if (save == null || this.border.override()) {
                    levelData.setWorldBorder(FileUtil.buildWorldBorder(this.border));
                }
                if (save != null) {
                    LevelDataAndDimensions saveData = VersionUtil.getLevelDataAndDimension(save, WorldMagic.worldLoader().dataConfiguration(), VersionUtil.getRegistry(Registries.LEVEL_STEM));
                    oldLevelData = (PrimaryLevelData)saveData.worldData();
                    levelData.setDayTime(oldLevelData.getDayTime());
                    levelData.setClearWeatherTime(oldLevelData.getClearWeatherTime());
                    levelData.setRainTime(oldLevelData.getRainTime());
                    levelData.setThunderTime(oldLevelData.getThunderTime());
                    levelData.setGameTime(oldLevelData.getGameTime());
                    levelData.setRaining(oldLevelData.isRaining());
                    levelData.setThundering(oldLevelData.isThundering());
                    levelData.setInitialized(oldLevelData.isInitialized());
                    if (this.gamerules == null || !this.gamerules.override) {
                        levelData.getGameRules().assignFrom(oldLevelData.getGameRules(), null);
                    }
                    if (!this.border.override()) {
                        levelData.setWorldBorder(oldLevelData.getWorldBorder());
                    }
                }
                break block41;
            }
            LevelDataAndDimensions saveData = VersionUtil.getLevelDataAndDimension(save, WorldMagic.worldLoader().dataConfiguration(), VersionUtil.getRegistry(Registries.LEVEL_STEM));
            dimensionRegistry = saveData.dimensions().dimensions();
            levelData = (PrimaryLevelData)saveData.worldData();
            specialProperty = saveData.dimensions().specialWorldProperty();
            if (this.gamerules != null && this.gamerules.override) {
                levelData.getGameRules().assignFrom(this.gamerules.gameRules, null);
            }
            if (this.border.override()) {
                levelData.setWorldBorder(FileUtil.buildWorldBorder(this.border));
            }
        }
        levelData.customDimensions = dimensionRegistry;
        levelData.checkName(this.bukkitId);
        levelData.setModdedInfo(WorldMagic.vanillaServer().getServerModName(), WorldMagic.vanillaServer().getModdedStatus().shouldReportAsModified());
        if (WorldMagic.vanillaServer().options.has("forceUpgrade")) {
            VersionUtil.forceUpgrade.invoke(levelStorage, levelData, DataFixers.getDataFixer(), WorldMagic.vanillaServer().options.has("eraseCache"), () -> true, WorldMagic.vanillaServer().registryAccess(), WorldMagic.vanillaServer().options.has("recreateRegionFiles"));
        }
        int loadRadius = ((GameRules.IntegerValue)levelData.getGameRules().getRule(GameRules.RULE_SPAWN_CHUNK_RADIUS)).get();
        ChunkProgressListener loadListener = WorldMagic.vanillaServer().progressListenerFactory.create(loadRadius);
        DedicatedServer dedicatedServer = WorldMagic.vanillaServer();
        Executor executor = WorldMagic.vanillaServer().executor;
        boolean bl = specialProperty == PrimaryLevelData.SpecialWorldProperty.DEBUG;
        long l = BiomeManager.obfuscateSeed((long)(this.worldProperties.override() && this.worldProperties.seed() != null ? this.worldProperties.seed().longValue() : levelData.worldGenOptions().seed()));
        List<WanderingTraderSpawner> list = List.of(new PhantomSpawner(), new PatrolSpawner(), new CatSpawner(), new VillageSiege(), new WanderingTraderSpawner((ServerLevelData)levelData));
        RandomSequences randomSequences = WorldMagic.vanillaServer().overworld().getRandomSequences();
        if (generator instanceof GeneratorSettings.Plugin) {
            String pl;
            oldLevelData = (GeneratorSettings.Plugin)((Object)generator);
            {
                String string;
                pl = string = ((GeneratorSettings.Plugin)oldLevelData).generator();
            }
            chunkGenerator = WorldCreator.getGeneratorForName((String)this.bukkitId, (String)pl, (CommandSender)Bukkit.getConsoleSender());
        } else {
            chunkGenerator = null;
        }
        this.level = new ServerLevel((MinecraftServer)dedicatedServer, executor, levelStorage, levelData, this.vanillaLevelId, this.stem, loadListener, bl, l, list, true, randomSequences, World.Environment.CUSTOM, chunkGenerator, pluginBiomeProvider == null ? null : WorldCreator.getBiomeProviderForName((String)this.bukkitId, (String)pluginBiomeProvider, (CommandSender)Bukkit.getConsoleSender()));
        this.level.noSave = !this.loading.save();
        this.level.pvpMode = this.allowSettings.pvp();
        WorldMagic.vanillaServer().addLevel(this.level);
        this.bukkitWorld = this.level.getWorld();
        try {
            if (this.level.generator != null) {
                this.bukkitWorld.getPopulators().addAll(this.level.generator.getDefaultPopulators(this.bukkitWorld));
            }
            if (!this.loading.async()) {
                WorldBorder worldBorder = this.level.getWorldBorder();
                worldBorder.applySettings(levelData.getWorldBorder());
                WorldMagic.pluginManager().callEvent((Event)new WorldInitEvent(this.bukkitWorld));
            }
            if (this.spawnPosition != null && this.spawnPosition.override()) {
                this.setSpawn(levelData);
            }
            if (!levelData.isInitialized()) {
                init = true;
                if (this.spawnPosition != null) {
                    if (!this.spawnPosition.override()) {
                        this.setSpawn(levelData);
                    }
                } else {
                    try {
                        vanillaSetSpawn.invoke(null, this.level, levelData, false, this.level.isDebug());
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new WorldLoadException(e.toString());
                    }
                }
                if (!this.loading.async() && this.worldProperties.bonusChest()) {
                    ((ConfiguredFeature)VersionUtil.getHolder(VersionUtil.getRegistry(this.level.registryAccess(), Registries.CONFIGURED_FEATURE), MiscOverworldFeatures.BONUS_CHEST).value()).place((WorldGenLevel)this.level, this.level.chunkSource.getGenerator(), this.level.random, levelData.getSpawnPos());
                }
                levelData.setInitialized(true);
            } else {
                init = false;
            }
            VersionUtil.setSpawnSettings(this.level, this.allowSettings.monsters(), this.allowSettings.animals());
            BlockPos spawnPos = this.level.getSharedSpawnPos();
            loadListener.updateSpawnPos(new ChunkPos(spawnPos));
            this.level.setDefaultSpawnPos(spawnPos, this.level.getSharedSpawnAngle());
            WorldMagic.logger().info("World {} initialization done!", (Object)this.id.asString());
        }
        catch (RuntimeException e) {
            this.loaded = false;
            Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)false);
            throw new WorldLoadException(e.toString());
        }
        if (!this.loading.async()) {
            this.postLoadProcess(loadRadius, loadListener);
            return;
        }
        WorldMagic.scheduler().runTask((Plugin)WorldMagic.instance(), () -> {
            try {
                WorldBorder worldBorder = this.level.getWorldBorder();
                worldBorder.applySettings(levelData.getWorldBorder());
                WorldMagic.pluginManager().callEvent((Event)new WorldInitEvent(this.bukkitWorld));
                if (init && this.worldProperties.bonusChest()) {
                    ((ConfiguredFeature)VersionUtil.getHolder(VersionUtil.getRegistry(this.level.registryAccess(), Registries.CONFIGURED_FEATURE), MiscOverworldFeatures.BONUS_CHEST).value()).place((WorldGenLevel)this.level, this.level.chunkSource.getGenerator(), this.level.random, levelData.getSpawnPos());
                }
            }
            catch (RuntimeException e) {
                this.loaded = false;
                Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)false);
                throw new WorldLoadException(e.toString());
            }
            this.postLoadProcess(loadRadius, loadListener);
        });
    }

    private void postLoadProcess(int loadRadius, ChunkProgressListener loadListener) {
        try {
            ServerChunkCache chunkCache = this.level.getChunkSource();
            if (this.loading.loadChunks()) {
                WorldMagic.vanillaServer().forceTicks = true;
                if (loadRadius > 0) {
                    int load = Mth.square((int)ChunkProgressListener.calculateDiameter((int)loadRadius));
                    while (chunkCache.getTickingGenerated() < load) {
                        try {
                            chunkCache.pollTask();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                WorldMagic.vanillaServer().forceTicks = false;
                WorldMagic.logger().info("{} {} chunks loaded.", (Object)chunkCache.getTickingGenerated(), (Object)this.id.asString());
            }
            VersionUtil.computeForcedChunks(this.level.getDataStorage(), chunkCache);
            loadListener.stop();
            if (VersionUtil.dataVersion > 4082) {
                FeatureHooks.tickEntityManager((ServerLevel)this.level);
            }
            WorldMagic.pluginManager().callEvent((Event)new WorldLoadEvent(this.bukkitWorld));
        }
        catch (RuntimeException e) {
            this.loaded = false;
            Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)false);
            throw new WorldLoadException(e.toString());
        }
    }

    private void unloadProcess() {
        if (!this.loading.save()) {
            DimensionDataStorage dataSt = this.level.getDataStorage();
            if (VersionUtil.dataVersion < 4082) {
                try {
                    ((ExecutorService)ioExecutorField.get(dataSt)).shutdown();
                }
                catch (IllegalAccessException e) {
                    throw new WorldUnloadException(e.toString());
                }
            }
            VersionUtil.undirtData(dataSt);
        }
        if (!Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)this.loading.save())) {
            throw new WorldUnloadException("Error to unload");
        }
        if (this.loading.folderDeletion()) {
            threadManager.execute(this::folderDeletion);
        }
    }

    private void folderDeletion() {
        for (int i = 1; i <= 5; ++i) {
            try {
                Files.walkFileTree(this.folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(Path path, @NotNull BasicFileAttributes basicfileattributes) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult postVisitDirectory(Path path, @Nullable IOException ioexception) throws IOException {
                        if (ioexception != null) {
                            throw ioexception;
                        }
                        Files.deleteIfExists(path);
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            catch (IOException ioexception) {
                if (i == 5) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    private void setSpawn(PrimaryLevelData levelData) {
        BlockPos spawnPos = new BlockPos(this.spawnPosition.x(), this.spawnPosition.y(), this.spawnPosition.z());
        levelData.setSpawn(spawnPos, this.spawnPosition.yaw());
    }

    private boolean checkDuplication() {
        return Bukkit.getWorld((String)this.bukkitId) != null || Bukkit.getWorld((NamespacedKey)this.id) != null;
    }

    @NotNull
    private PrimaryLevelData getPrimaryLevelData(Registry<LevelStem> dimensionRegistry, PrimaryLevelData.SpecialWorldProperty specialProperty) {
        WorldDimensions.Complete dimensionsOp = new WorldDimensions.Complete(dimensionRegistry, specialProperty);
        WorldOptions worldOptions = new WorldOptions(this.worldProperties.seed() == null ? WorldOptions.randomSeed() : this.worldProperties.seed(), this.worldProperties.generateStructures(), this.worldProperties.bonusChest());
        LevelSettings levelSettings = new LevelSettings(this.bukkitId, WorldMagic.vanillaServer().getDefaultGameType(), Bukkit.isHardcore(), FileUtil.mapDifficulty(this.worldProperties.difficulty()), false, this.gamerules == null ? VersionUtil.createGameRules() : this.gamerules.gameRules, WorldMagic.worldLoader().dataConfiguration());
        return new PrimaryLevelData(levelSettings, worldOptions, dimensionsOp.specialWorldProperty(), Lifecycle.experimental());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PrimaryLevelData.SpecialWorldProperty specialWorldProperty(GeneratorSettings generator) {
        ChunkGenerator generatorVan;
        if (generator instanceof GeneratorSettings.Plugin) {
            return PrimaryLevelData.SpecialWorldProperty.FLAT;
        }
        if (!(generator instanceof GeneratorSettings.Vanilla)) throw new WorldLoadException("Unexpected exception");
        GeneratorSettings.Vanilla vanilla = (GeneratorSettings.Vanilla)generator;
        try {
            ChunkGenerator chunkGenerator;
            generatorVan = chunkGenerator = vanilla.generator();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (generatorVan instanceof DebugLevelSource) {
            return PrimaryLevelData.SpecialWorldProperty.DEBUG;
        }
        if (!(generatorVan instanceof FlatLevelSource)) return PrimaryLevelData.SpecialWorldProperty.NONE;
        return PrimaryLevelData.SpecialWorldProperty.FLAT;
    }

    public static boolean isStable(ResourceKey<LevelStem> key, LevelStem data) {
        return key == LevelStem.OVERWORLD && CustomWorld.isStableOverworld(data) || key == LevelStem.NETHER && CustomWorld.isStableNether(data) || key == LevelStem.END && CustomWorld.isStableEnd(data);
    }

    public static boolean isStableOverworld(LevelStem dimensionOptions) {
        MultiNoiseBiomeSource multiNoiseBiomeSource;
        BiomeSource biomeSource;
        Holder holder = dimensionOptions.type();
        return !(!holder.is(BuiltinDimensionTypes.OVERWORLD) && !holder.is(BuiltinDimensionTypes.OVERWORLD_CAVES) || (biomeSource = dimensionOptions.generator().getBiomeSource()) instanceof MultiNoiseBiomeSource && !(multiNoiseBiomeSource = (MultiNoiseBiomeSource)biomeSource).stable(MultiNoiseBiomeSourceParameterLists.OVERWORLD));
    }

    public static boolean isStableNether(LevelStem dimensionOptions) {
        MultiNoiseBiomeSource multiNoiseBiomeSource;
        NoiseBasedChunkGenerator noiseBasedChunkGenerator;
        ChunkGenerator chunkGenerator;
        return dimensionOptions.type().is(BuiltinDimensionTypes.NETHER) && (chunkGenerator = dimensionOptions.generator()) instanceof NoiseBasedChunkGenerator && (noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator).stable(NoiseGeneratorSettings.NETHER) && (chunkGenerator = noiseBasedChunkGenerator.getBiomeSource()) instanceof MultiNoiseBiomeSource && (multiNoiseBiomeSource = (MultiNoiseBiomeSource)chunkGenerator).stable(MultiNoiseBiomeSourceParameterLists.NETHER);
    }

    public static boolean isStableEnd(LevelStem dimensionOptions) {
        NoiseBasedChunkGenerator noiseBasedChunkGenerator;
        ChunkGenerator chunkGenerator;
        return dimensionOptions.type().is(BuiltinDimensionTypes.END) && (chunkGenerator = dimensionOptions.generator()) instanceof NoiseBasedChunkGenerator && (noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator).stable(NoiseGeneratorSettings.END) && noiseBasedChunkGenerator.getBiomeSource() instanceof TheEndBiomeSource;
    }

    private static /* synthetic */ void lambda$loadProcess$2(WritableRegistry writableDimensionRegistry, ResourceKey key, LevelStem dimension) {
        writableDimensionRegistry.register(key, (Object)dimension, new RegistrationInfo(Optional.empty(), CustomWorld.isStable((ResourceKey<LevelStem>)key, dimension) ? Lifecycle.stable() : Lifecycle.experimental()));
    }

    static {
        overworld = NamespacedKey.minecraft((String)"overworld");
        try {
            vanillaSetSpawn = MinecraftServer.class.getDeclaredMethod("setInitialSpawn", ServerLevel.class, ServerLevelData.class, Boolean.TYPE, Boolean.TYPE);
            if (VersionUtil.dataVersion < 4082) {
                ioExecutorField = DimensionDataStorage.class.getDeclaredField("ioExecutor");
                ioExecutorField.setAccessible(true);
            } else {
                ioExecutorField = null;
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        vanillaSetSpawn.setAccessible(true);
        shutdown = false;
    }
}

