/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.util.RegistrationUtil;
import io.hotwop.worldmagic.util.VersionUtil;
import io.hotwop.worldmagic.util.serializer.NamespacedKeySerializer;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v7.ConfigurateOps;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class WorldGenProcessor {
    private static final Map<NamespacedKey, DimensionType> dimensionTypes = new HashMap<NamespacedKey, DimensionType>();
    private static final List<WorldGenStatement<?>> worldGen = List.of(new WorldGenStatement<NormalNoise.NoiseParameters>("noise", new TypeToken<NormalNoise.NoiseParameters>(){}, NormalNoise.NoiseParameters.DIRECT_CODEC, new HashMap(), Registries.NOISE), new WorldGenStatement<DensityFunction>("density_function", new TypeToken<DensityFunction>(){}, DensityFunction.DIRECT_CODEC, new HashMap(), Registries.DENSITY_FUNCTION), new WorldGenStatement<NoiseGeneratorSettings>("noise_settings", new TypeToken<NoiseGeneratorSettings>(){}, NoiseGeneratorSettings.DIRECT_CODEC, new HashMap(), Registries.NOISE_SETTINGS), new WorldGenStatement("configured_carver", new TypeToken<ConfiguredWorldCarver<?>>(){}, ConfiguredWorldCarver.DIRECT_CODEC, new HashMap(), Registries.CONFIGURED_CARVER), new WorldGenStatement("configured_feature", new TypeToken<ConfiguredFeature<?, ?>>(){}, ConfiguredFeature.DIRECT_CODEC, new HashMap(), Registries.CONFIGURED_FEATURE), new WorldGenStatement<PlacedFeature>("placed_feature", new TypeToken<PlacedFeature>(){}, PlacedFeature.DIRECT_CODEC, new HashMap(), Registries.PLACED_FEATURE), new WorldGenStatement<Biome>("biome", new TypeToken<Biome>(){}, Biome.DIRECT_CODEC, new HashMap(), Registries.BIOME), new WorldGenStatement<StructureProcessorList>("processor_list", new TypeToken<StructureProcessorList>(){}, StructureProcessorType.DIRECT_CODEC, new HashMap(), Registries.PROCESSOR_LIST), new WorldGenStatement<StructureTemplatePool>("template_pool", new TypeToken<StructureTemplatePool>(){}, StructureTemplatePool.DIRECT_CODEC, new HashMap(), Registries.TEMPLATE_POOL), new WorldGenStatement<Structure>("structure", new TypeToken<Structure>(){}, Structure.DIRECT_CODEC, new HashMap(), Registries.STRUCTURE), new WorldGenStatement<StructureSet>("structure_set", new TypeToken<StructureSet>(){}, StructureSet.DIRECT_CODEC, new HashMap(), Registries.STRUCTURE_SET));

    private WorldGenProcessor() {
    }

    public static DimensionType getPluginDimensionType(NamespacedKey id) {
        return dimensionTypes.get(id);
    }

    public static Map<NamespacedKey, DimensionType> getPluginDimensionTypes() {
        return Map.copyOf(dimensionTypes);
    }

    @Nullable
    public <T> T getPluginWorldGenElement(Class<T> elementClass, NamespacedKey id) {
        return WorldGenProcessor.findStatement(elementClass).map(st -> st.map.get(id)).orElse(null);
    }

    @Nullable
    public <T> Map<NamespacedKey, T> getPluginWorldGenElements(Class<T> elementClass) {
        return WorldGenProcessor.findStatement(elementClass).map(st -> Map.copyOf(st.map)).orElse(null);
    }

    private static <T> Optional<WorldGenStatement<T>> findStatement(Class<T> elementClass) {
        return worldGen.stream().filter(st -> {
            ParameterizedType param;
            Type inner = st.clazz.getType();
            if (inner.equals(elementClass)) {
                return true;
            }
            return inner instanceof ParameterizedType && (param = (ParameterizedType)inner).getRawType().equals(elementClass);
        }).map(st -> st).findAny();
    }

    public static void loadDimensionTypes() {
        WorldMagic.logger().info("Loading dimension types...");
        HashMap<Path, YamlConfigurationLoader> loaders = new HashMap<Path, YamlConfigurationLoader>();
        try (Stream<Path> stream = Files.walk(WorldMagic.dimensionTypesPath(), new FileVisitOption[0]);){
            stream.filter(pt -> Files.isRegularFile(pt, new LinkOption[0]) && pt.toFile().getName().endsWith(".yml")).forEach(pt -> loaders.computeIfAbsent((Path)pt, WorldGenProcessor::createWorldGenLoader));
        }
        catch (IOException e) {
            WorldMagic.logger().error("Error to load dimension type files: {}", (Object)e.toString());
            return;
        }
        dimensionTypes.clear();
        HashMap patches = new HashMap();
        HashMap<NamespacedKey, List> conflicts = new HashMap<NamespacedKey, List>();
        RegistryAccess.Frozen access = WorldMagic.vanillaServer().registryAccess();
        RegistryOps ops = access.createSerializationContext(ConfigurateOps.instance());
        loaders.forEach((path, loader) -> {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
                if (node.isNull()) {
                    WorldMagic.logger().warn("File {} is empty, error to load dimension type", path);
                    return;
                }
                CommentedConfigurationNode idNode = (CommentedConfigurationNode)node.node(new Object[]{"id"});
                if (idNode.virtual()) {
                    throw new SerializationException((ConfigurationNode)node, DimensionType.class, "id node is required");
                }
                NamespacedKey id = (NamespacedKey)idNode.require(NamespacedKey.class);
                if (conflicts.containsKey(id)) {
                    ((List)conflicts.get(id)).add(path);
                    return;
                }
                if (dimensionTypes.containsKey(id)) {
                    DimensionType conflict = dimensionTypes.get(id);
                    Path conflictPath = (Path)patches.get(conflict);
                    dimensionTypes.remove(id);
                    patches.remove(conflict);
                    ArrayList<Path> conflictLs = new ArrayList<Path>();
                    conflictLs.add((Path)path);
                    conflictLs.add(conflictPath);
                    conflicts.put(id, conflictLs);
                    return;
                }
                DimensionType file = (DimensionType)DimensionType.DIRECT_CODEC.parse((DynamicOps)ops, (Object)node).getOrThrow(err -> new SerializationException((ConfigurationNode)node, DimensionType.class, "Error to deserialize dimension type:\n     " + err.replace(";", "\n    ")));
                dimensionTypes.put(id, file);
                patches.put(file, path);
            }
            catch (ConfigurateException ex) {
                WorldMagic.logger().warn("Error to load dimension type file {}: {}", (Object)path.toString(), (Object)ex.getMessage());
            }
        });
        conflicts.forEach((id, files) -> {
            StringBuilder builder = new StringBuilder();
            boolean separator = false;
            for (Path path : files) {
                if (separator) {
                    builder.append(", ");
                }
                builder.append(path.toString());
                if (separator) continue;
                separator = true;
            }
            WorldMagic.logger().warn("Error to load dimension type files due ID duplication: {}", (Object)builder);
        });
        HashMap vanillaDimensionTypes = new HashMap();
        dimensionTypes.forEach((id, type) -> vanillaDimensionTypes.put(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)VersionUtil.createResourceLocation(id)), type));
        RegistrationUtil.registerIgnoreFreezeAll(Registries.DIMENSION_TYPE, (RegistryAccess)access, vanillaDimensionTypes, Lifecycle.experimental());
        RegistrationUtil.bindRegistrations(Registries.DIMENSION_TYPE, (RegistryAccess)access, vanillaDimensionTypes);
        WorldMagic.logger().info("Dimension types loaded");
    }

    public static void loadWorldGen() {
        WorldMagic.logger().info("Loading worldgen...");
        worldGen.forEach(WorldGenStatement::load);
        WorldMagic.logger().info("Worldgen loaded");
    }

    private static YamlConfigurationLoader createWorldGenLoader(Path path) {
        return ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).indent(2).defaultOptions(opts -> opts.serializers(ser -> ser.register((ScalarSerializer)NamespacedKeySerializer.instance)))).build();
    }

    private record WorldGenStatement<T>(String name, TypeToken<T> clazz, Codec<T> codec, Map<NamespacedKey, T> map, ResourceKey<Registry<T>> registry) {
        public void load() {
            Path directoryPath = WorldMagic.worldGenPath().resolve(this.name);
            File directory = directoryPath.toFile();
            if (!directory.exists() || !directory.isDirectory()) {
                return;
            }
            HashMap<Path, YamlConfigurationLoader> loaders = new HashMap<Path, YamlConfigurationLoader>();
            try (Stream<Path> stream = Files.walk(directoryPath, new FileVisitOption[0]);){
                stream.filter(pt -> Files.isRegularFile(pt, new LinkOption[0]) && pt.toFile().getName().endsWith(".yml")).forEach(pt -> loaders.computeIfAbsent((Path)pt, WorldGenProcessor::createWorldGenLoader));
            }
            catch (IOException e) {
                WorldMagic.logger().error("Error to load {} files: {}", (Object)this.name, (Object)e.toString());
                return;
            }
            this.map.clear();
            HashMap patches = new HashMap();
            HashMap conflicts = new HashMap();
            RegistryAccess.Frozen access = WorldMagic.vanillaServer().registryAccess();
            RegistryOps ops = access.createSerializationContext(ConfigurateOps.instance());
            loaders.forEach((path, loader) -> {
                try {
                    CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
                    if (node.isNull()) {
                        WorldMagic.logger().warn("File {} is empty, error to load {}", path, (Object)this.name);
                        return;
                    }
                    CommentedConfigurationNode idNode = (CommentedConfigurationNode)node.node(new Object[]{"id"});
                    if (idNode.virtual()) {
                        throw new SerializationException((ConfigurationNode)node, this.clazz.getType(), "id node is required");
                    }
                    NamespacedKey id = (NamespacedKey)idNode.require(NamespacedKey.class);
                    if (conflicts.containsKey(id)) {
                        ((List)conflicts.get(id)).add(path);
                        return;
                    }
                    if (this.map.containsKey(id)) {
                        T conflict = this.map.get(id);
                        Path conflictPath = (Path)patches.get(conflict);
                        this.map.remove(id);
                        patches.remove(conflict);
                        ArrayList<Path> conflictLs = new ArrayList<Path>();
                        conflictLs.add((Path)path);
                        conflictLs.add(conflictPath);
                        conflicts.put(id, conflictLs);
                        return;
                    }
                    Object file = this.codec.parse((DynamicOps)ops, (Object)node).getOrThrow(err -> new SerializationException((ConfigurationNode)node, this.clazz.getType(), "Error to deserialize " + this.name + ":\n     " + err.replace(";", "\n    ")));
                    this.map.put(id, file);
                    patches.put(file, path);
                }
                catch (ConfigurateException ex) {
                    WorldMagic.logger().warn("Error to load {} file {}: {}", new Object[]{this.name, path.toString(), ex.getMessage()});
                }
            });
            HashMap vanillaMap = new HashMap();
            this.map.forEach((id, val) -> vanillaMap.put(ResourceKey.create(this.registry, (ResourceLocation)VersionUtil.createResourceLocation(id)), val));
            RegistrationUtil.registerIgnoreFreezeAll(this.registry, (RegistryAccess)access, vanillaMap, Lifecycle.experimental());
            RegistrationUtil.bindRegistrations(this.registry, (RegistryAccess)access, vanillaMap);
        }
    }
}

