/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.hotwop.worldmagic.CustomWorld;
import io.hotwop.worldmagic.WorldCreationException;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.command.BorderSubCommand;
import io.hotwop.worldmagic.command.CustomWorldArgument;
import io.hotwop.worldmagic.command.DeleteSubCommand;
import io.hotwop.worldmagic.command.MoveSubCommand;
import io.hotwop.worldmagic.command.NodeBuilders;
import io.hotwop.worldmagic.command.WorldFileArgument;
import io.hotwop.worldmagic.file.WorldFile;
import io.hotwop.worldmagic.util.VersionUtil;
import io.hotwop.worldmagic.util.Weather;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.DataVersion;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.world.TimeSkipEvent;
import org.jetbrains.annotations.NotNull;

public final class WorldMagicBootstrap
implements PluginBootstrap {
    private static ComponentLogger logger;
    public static final DynamicCommandExceptionType notLoadControlWorldException;
    public static final DynamicCommandExceptionType worldAlreadyLoadedException;
    public static final DynamicCommandExceptionType worldAlreadyUnloadedException;
    public static final DynamicCommandExceptionType worldNotLoaded;
    public static final DynamicCommandExceptionType worldCreateError;
    public static final DynamicCommandExceptionType worldDeleteException;
    public static final SimpleCommandExceptionType noVaultException;
    private static final String[] globalPermissionSet;

    public static ComponentLogger logger() {
        return logger;
    }

    public static boolean hasOneOfPermission(CommandSender sender, String[] permissions) {
        for (String permission : permissions) {
            if (!sender.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static int getDataVersion() {
        Method getVersionMethod;
        DataVersion dataVersion;
        Method dataVersionMethod;
        WorldVersion version = SharedConstants.getCurrentVersion();
        Class clazz = version.getClass();
        try {
            dataVersionMethod = clazz.getMethod("getDataVersion", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return version.dataVersion().version();
        }
        try {
            dataVersion = (DataVersion)dataVersionMethod.invoke((Object)version, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Class<?> dataClazz = dataVersion.getClass();
        try {
            getVersionMethod = dataClazz.getMethod("getVersion", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            return (Integer)getVersionMethod.invoke((Object)dataVersion, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void bootstrap(@NotNull BootstrapContext ctx) {
        logger = ctx.getLogger();
        logger.info("Booting WorldMagic...");
        if (WorldMagicBootstrap.getDataVersion() < 3839) {
            throw new RuntimeException("Versions under 1.20.6 are unsupported");
        }
        try {
            WorldMagicBootstrap.class.getClassLoader().loadClass(VersionUtil.class.getName());
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        LifecycleEventManager manager = ctx.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, e -> {
            Commands commands = (Commands)e.registrar();
            commands.register(this.buildCommand(commands), List.of("wm"));
        });
    }

    private LiteralCommandNode<CommandSourceStack> buildCommand(Commands commands) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldmagic").requires(ctx -> WorldMagicBootstrap.hasOneOfPermission(ctx.getSender(), globalPermissionSet))).then(((LiteralArgumentBuilder)Commands.literal((String)"world").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.world"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)CustomWorldArgument.instance).then(((LiteralArgumentBuilder)Commands.literal((String)"load").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.world.load"))).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loading.loadControl()) {
                throw notLoadControlWorldException.create((Object)world.id.asString());
            }
            if (world.loaded()) {
                throw worldAlreadyLoadedException.create((Object)world.id.asString());
            }
            world.load();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Loading world...");
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"unload").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.world.load"))).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loading.loadControl()) {
                throw notLoadControlWorldException.create((Object)world.id.asString());
            }
            if (!world.loaded()) {
                throw worldAlreadyUnloadedException.create((Object)world.id.asString());
            }
            world.unload();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Unloading world...");
            return 1;
        }))).then(NodeBuilders.buildGameruleNode("gamerule", (key, type, value, ctx) -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            String val = value.toString();
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(world.world(), ((CommandSourceStack)ctx.getSource()).getSender(), GameRule.getByName((String)key.getId()), val);
            WorldMagic.pluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.translatable((String)"multiplayer.status.cancelled"));
                return 0;
            }
            ServerLevel level = world.level();
            GameRules.Value rule = level.getGameRules().getRule(key);
            rule.deserialize(val);
            rule.onChanged(level);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.translatable((String)"commands.gamerule.set").arguments(new ComponentLike[]{Component.text((String)key.getId()), Component.text((String)val)}));
            return 1;
        }, (key, type, ctx) -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            String value = world.level().getGameRules().getRule(key).serialize();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.gamerule.query", (Object[])new Object[]{key.getId(), value})));
            return 1;
        }, commands))).then(NodeBuilders.buildDifficultyNode("difficulty", (diff, ctx) -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            VersionUtil.setDifficulty.invokeWithExecutor(WorldMagic.vanillaServer(), world.level(), diff, ctx.getSource(), true);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.difficulty.success", (Object[])new Object[]{diff.getDisplayName()})));
            return diff.getId() + 1;
        }, ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            Difficulty value = world.level().getDifficulty();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.difficulty.query", (Object[])new Object[]{value.getDisplayName()})));
            return value.getId();
        }))).then(NodeBuilders.buildWeatherNode("weather", (weather, duration, ctx) -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            weather.apply(world.level(), duration);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)weather.getSetComponent()));
            return duration;
        }, ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            Weather weather = Weather.query(world.level());
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Weather in " + world.id.asString() + " is " + weather.name());
            return weather.ordinal();
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"time").then(NodeBuilders.buildSetTimeNode("set", (time, ctx) -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            ServerLevel level = world.level();
            TimeSkipEvent event = new TimeSkipEvent(world.world(), TimeSkipEvent.SkipReason.COMMAND, (long)time - level.getDayTime());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                level.setDayTime(level.getDayTime() + event.getSkipAmount());
            }
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.time.set", (Object[])new Object[]{time})));
            return time % 24000;
        }))).then(Commands.literal((String)"add").then(Commands.argument((String)"value", (ArgumentType)ArgumentTypes.time()).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            int time = (Integer)ctx.getArgument("value", Integer.class);
            ServerLevel level = world.level();
            TimeSkipEvent event = new TimeSkipEvent(world.world(), TimeSkipEvent.SkipReason.COMMAND, (long)time);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                level.setDayTime(level.getDayTime() + event.getSkipAmount());
            }
            long out = level.getDayTime();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.time.set", (Object[])new Object[]{out})));
            return Long.valueOf(out).intValue() % 24000;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"world-exists").executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            long time = world.level().getGameTime();
            WorldMagicBootstrap.timeMessage((CommandSourceStack)ctx.getSource(), time);
            return Long.valueOf(time).intValue();
        }))).then(Commands.literal((String)"days").executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            long time = world.level().getDayTime() / 24000L;
            WorldMagicBootstrap.timeMessage((CommandSourceStack)ctx.getSource(), time);
            return Long.valueOf(time).intValue();
        }))).then(Commands.literal((String)"hours").executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            long time = world.level().getDayTime();
            WorldMagicBootstrap.timeMessage((CommandSourceStack)ctx.getSource(), time);
            return Long.valueOf(time).intValue();
        }))).then(Commands.literal((String)"hours-in-day").executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            long time = world.level().getGameTime() % 24000L;
            WorldMagicBootstrap.timeMessage((CommandSourceStack)ctx.getSource(), time);
            return Long.valueOf(time).intValue();
        }))))).then(BorderSubCommand.buildNode())).then(Commands.literal((String)"spawn").then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)ArgumentTypes.blockPosition()).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            BlockPosition pos = (BlockPosition)((BlockPositionResolver)ctx.getArgument("pos", BlockPositionResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            world.world().setSpawnLocation(pos.blockX(), pos.blockY(), pos.blockZ());
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.setworldspawn.success", (Object[])new Object[]{pos.blockX(), pos.blockY(), pos.blockZ(), 0})));
            return 1;
        })).then(Commands.argument((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-180.0f, (float)180.0f)).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw worldNotLoaded.create((Object)world.id.asString());
            }
            BlockPosition pos = (BlockPosition)((BlockPositionResolver)ctx.getArgument("pos", BlockPositionResolver.class)).resolve((CommandSourceStack)ctx.getSource());
            float yaw = ((Float)ctx.getArgument("yaw", Float.class)).floatValue();
            world.world().setSpawnLocation(pos.blockX(), pos.blockY(), pos.blockZ(), yaw);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.setworldspawn.success", (Object[])new Object[]{pos.blockX(), pos.blockY(), pos.blockZ(), Float.valueOf(yaw)})));
            return 1;
        }))))).then(MoveSubCommand.buildNode())).then(DeleteSubCommand.buildNode())))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.create"))).then(Commands.argument((String)"prototype", (ArgumentType)WorldFileArgument.instance).then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)ArgumentTypes.namespacedKey()).executes(ctx -> {
            WorldFile file = (WorldFile)ctx.getArgument("prototype", WorldFile.class);
            NamespacedKey id = (NamespacedKey)ctx.getArgument("id", NamespacedKey.class);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Creating world...");
            try {
                WorldMagic.createWorldFromFile(id, file);
            }
            catch (WorldCreationException e) {
                throw worldCreateError.create((Object)e.getMessage());
            }
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"bukkitId", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            WorldFile file = (WorldFile)ctx.getArgument("prototype", WorldFile.class);
            NamespacedKey id = (NamespacedKey)ctx.getArgument("id", NamespacedKey.class);
            String bukkitId = (String)ctx.getArgument("bukkitId", String.class);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Creating world...");
            try {
                WorldMagic.createWorldFromFile(id, bukkitId, file);
            }
            catch (WorldCreationException e) {
                throw worldCreateError.create((Object)e.getMessage());
            }
            return 1;
        })).then(Commands.argument((String)"folder", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            WorldFile file = (WorldFile)ctx.getArgument("prototype", WorldFile.class);
            NamespacedKey id = (NamespacedKey)ctx.getArgument("id", NamespacedKey.class);
            String bukkitId = (String)ctx.getArgument("bukkitId", String.class);
            String folder = (String)ctx.getArgument("folder", String.class);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Creating world...");
            try {
                WorldMagic.createWorldFromFile(id, bukkitId, folder, file);
            }
            catch (WorldCreationException e) {
                throw worldCreateError.create((Object)e.getMessage());
            }
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.reload"))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Reloading world files and config...");
            new Thread(() -> {
                WorldMagic wm = WorldMagic.instance();
                wm.loadConfig();
                wm.loadWorldFiles();
            }).start();
            return 1;
        })).then(Commands.literal((String)"economy").executes(ctx -> {
            if (WorldMagic.pluginManager().isPluginEnabled("Vault")) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Reloading economy...");
                WorldMagic.instance().loadVault();
                return 1;
            }
            throw noVaultException.create();
        })))).build();
    }

    private static void timeMessage(CommandSourceStack ctx, long time) {
        ctx.getSender().sendMessage(PaperAdventure.asAdventure((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"commands.time.query", (Object[])new Object[]{time})));
    }

    static {
        notLoadControlWorldException = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("World " + String.valueOf(obj) + " load control is disabled")));
        worldAlreadyLoadedException = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("World " + String.valueOf(obj) + " already loaded")));
        worldAlreadyUnloadedException = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("World " + String.valueOf(obj) + " already unloaded")));
        worldNotLoaded = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("World " + String.valueOf(obj) + " isn't loaded")));
        worldCreateError = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("Error to create world: " + String.valueOf(obj))));
        worldDeleteException = new DynamicCommandExceptionType(obj -> net.minecraft.network.chat.Component.literal((String)("Error to delete world: " + String.valueOf(obj))));
        noVaultException = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.literal((String)"Error: Vault isn't enabled"));
        globalPermissionSet = new String[]{"worldmagic.command.*", "worldmagic.command.world", "worldmagic.command.create", "worldmagic.command.reload"};
    }
}

