/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.api;

import io.hotwop.worldmagic.api.GeneratorLike;
import io.hotwop.worldmagic.generation.Dimension;
import io.hotwop.worldmagic.generation.GeneratorSettings;
import java.util.Objects;
import org.bukkit.NamespacedKey;

public interface DimensionLike {
    public static DimensionLike createInline(NamespacedKey dimensionType, GeneratorLike generator) {
        Objects.requireNonNull(dimensionType, "dimensionType");
        Objects.requireNonNull(generator, "generator");
        if (!(generator instanceof GeneratorSettings)) {
            throw new RuntimeException("Don't try to spoof GeneratorLike!");
        }
        GeneratorSettings gen = (GeneratorSettings)generator;
        return new Dimension.Inline(dimensionType, gen, null);
    }

    public static DimensionLike createInline(NamespacedKey dimensionType, GeneratorLike generator, String pluginBiomeSource) {
        Objects.requireNonNull(dimensionType, "dimensionType");
        Objects.requireNonNull(generator, "generator");
        Objects.requireNonNull(pluginBiomeSource, "pluginBiomeSource");
        if (!(generator instanceof GeneratorSettings)) {
            throw new RuntimeException("Don't try to spoof GeneratorLike!");
        }
        GeneratorSettings gen = (GeneratorSettings)generator;
        return new Dimension.Inline(dimensionType, gen, pluginBiomeSource);
    }

    public static DimensionLike createFromReference(NamespacedKey id) {
        Objects.requireNonNull(id, "id");
        return new Dimension.Reference(id);
    }
}

