/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.api;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.hotwop.worldmagic.generation.GeneratorSettings;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.chunk.ChunkGenerator;

public interface GeneratorLike {
    public static GeneratorLike createVanillaGeneratorFromSettings(String settings) {
        Objects.requireNonNull(settings, "settings");
        JsonObject json = GsonHelper.parse((String)settings);
        ChunkGenerator generator = (ChunkGenerator)ChunkGenerator.CODEC.parse((DynamicOps)JsonOps.COMPRESSED, (Object)json).getOrThrow(err -> new RuntimeException("Error to parse ChunkGenerator: " + err));
        return new GeneratorSettings.Vanilla(generator);
    }

    public static GeneratorLike createVanillaGeneratorFromHandle(Object handle) {
        Objects.requireNonNull(handle, "handle");
        if (handle instanceof ChunkGenerator) {
            ChunkGenerator ch = (ChunkGenerator)handle;
            return new GeneratorSettings.Vanilla(ch);
        }
        throw new RuntimeException("Provided object isn't NMS ChunkGenerator");
    }

    public static GeneratorLike createPluginGenerator(String id) {
        Objects.requireNonNull(id, "id");
        return new GeneratorSettings.Plugin(id);
    }
}

