/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.api;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;

public sealed interface LocationResolver {
    public Location resolve() throws ResolveException;

    public static LocationResolver resolver(NamespacedKey world, double x, double y, double z) {
        return new RuntimeResolver(world, x, y, z, 0.0f, 0.0f);
    }

    public static LocationResolver resolver(NamespacedKey world, double x, double y, double z, float yaw, float pitch) {
        return new RuntimeResolver(world, x, y, z, yaw, pitch);
    }

    public static LocationResolver resolver(Location location) {
        return new AlreadyResolver(location);
    }

    public static final class RuntimeResolver
    implements LocationResolver {
        public final NamespacedKey world;
        public final double x;
        public final double y;
        public final double z;
        public final float yaw;
        public final float pitch;

        private RuntimeResolver(NamespacedKey world, double x, double y, double z, float yaw, float pitch) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        @Override
        public Location resolve() throws ResolveException {
            World wd = Bukkit.getWorld((NamespacedKey)this.world);
            if (wd == null) {
                throw new ResolveException();
            }
            return new Location(wd, this.x, this.y, this.z, this.yaw, this.pitch);
        }
    }

    public static final class AlreadyResolver
    implements LocationResolver {
        public final Location location;

        private AlreadyResolver(Location location) {
            this.location = location.clone();
        }

        @Override
        public Location resolve() {
            return this.location;
        }
    }

    public static final class ResolveException
    extends Exception {
        public ResolveException() {
            super("Error to resolve location");
        }
    }
}

