/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.api.settings;

import io.hotwop.worldmagic.api.DimensionLike;
import io.hotwop.worldmagic.api.GameRuleSet;
import io.hotwop.worldmagic.api.LocationResolver;
import io.hotwop.worldmagic.api.settings.AllowSettings;
import io.hotwop.worldmagic.api.settings.Loading;
import io.hotwop.worldmagic.api.settings.SpawnPosition;
import io.hotwop.worldmagic.api.settings.WorldBorderSettings;
import io.hotwop.worldmagic.api.settings.WorldProperties;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Nullable;

public final class CustomWorldSettings {
    public final NamespacedKey id;
    public final String bukkitId;
    public final String folder;
    private AllowSettings allowSettings = null;
    private Loading loading = null;
    private WorldProperties worldProperties = null;
    private WorldBorderSettings border = null;
    private SpawnPosition spawn = null;
    private boolean gameRuleOverride = false;
    private final GameRuleSet gameRuleSet = new GameRuleSet();
    private LocationResolver callbackLocation = null;
    private DimensionLike dimension = DimensionLike.createFromReference(NamespacedKey.minecraft((String)"overworld"));

    public CustomWorldSettings(NamespacedKey id) {
        this(id, (String)(id.namespace().equals("minecraft") ? id.value() : id.namespace() + "_" + id.value()));
    }

    public CustomWorldSettings(NamespacedKey id, String bukkitId) {
        this(id, bukkitId, bukkitId);
    }

    public CustomWorldSettings(NamespacedKey id, String bukkitId, String folder) {
        this.id = id;
        this.bukkitId = bukkitId;
        this.folder = folder;
    }

    public void setAllowSettings(AllowSettings allowSettings) {
        Objects.requireNonNull(allowSettings, "allowSettings");
        this.allowSettings = allowSettings;
    }

    @Nullable
    public AllowSettings allowSettings() {
        return this.allowSettings;
    }

    public void setLoadingSettings(Loading loading) {
        Objects.requireNonNull(loading, "loading");
        this.loading = loading;
    }

    @Nullable
    public Loading loadingSettings() {
        return this.loading;
    }

    public void setWorldProperties(WorldProperties properties) {
        Objects.requireNonNull(properties, "properties");
        this.worldProperties = properties;
    }

    @Nullable
    public WorldProperties worldProperties() {
        return this.worldProperties;
    }

    public void setWorldBorderSettings(WorldBorderSettings border) {
        Objects.requireNonNull(border, "border");
        this.border = border;
    }

    @Nullable
    public WorldBorderSettings worldBorderSettings() {
        return this.border;
    }

    public void setSpawn(SpawnPosition spawn) {
        Objects.requireNonNull(spawn, "spawn");
        this.spawn = spawn;
    }

    @Nullable
    public SpawnPosition spawn() {
        return this.spawn;
    }

    public GameRuleSet gameRuleSet() {
        return this.gameRuleSet;
    }

    public void setGameRuleOverride(boolean override) {
        this.gameRuleOverride = override;
    }

    public boolean isGameRuleOverride() {
        return this.gameRuleOverride;
    }

    public void setCallbackLocation(LocationResolver location) {
        Objects.requireNonNull(location);
        this.callbackLocation = location;
    }

    @Nullable
    public LocationResolver callbackLocation() {
        return this.callbackLocation;
    }

    public void setDimension(DimensionLike dimension) {
        Objects.requireNonNull(dimension, "dimension");
        this.dimension = dimension;
    }

    public DimensionLike dimension() {
        return this.dimension;
    }
}

