/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.hotwop.worldmagic.CustomWorld;
import io.hotwop.worldmagic.WorldMagicBootstrap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.border.WorldBorder;

public final class BorderSubCommand {
    public static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.worldborder.set.failed.nochange"));
    public static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.worldborder.set.failed.small"));
    public static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.worldborder.set.failed.big", (Object[])new Object[]{5.9999968E7}));
    public static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.worldborder.set.failed.far", (Object[])new Object[]{2.9999984E7}));

    private BorderSubCommand() {
    }

    public static LiteralCommandNode<CommandSourceStack> buildNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"border").then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> BorderSubCommand.changeSize((CommandContext<CommandSourceStack>)ctx, start -> start + (Double)ctx.getArgument("distance", Double.class), current -> current))).then(Commands.argument((String)"milliseconds", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(ctx -> BorderSubCommand.changeSize((CommandContext<CommandSourceStack>)ctx, start -> start + (Double)ctx.getArgument("distance", Double.class), current -> current + (Long)ctx.getArgument("milliseconds", Long.class))))))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> BorderSubCommand.changeSize((CommandContext<CommandSourceStack>)ctx, start -> (Double)ctx.getArgument("distance", Double.class), current -> 0L))).then(Commands.argument((String)"milliseconds", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(ctx -> BorderSubCommand.changeSize((CommandContext<CommandSourceStack>)ctx, start -> (Double)ctx.getArgument("distance", Double.class), current -> (Long)ctx.getArgument("milliseconds", Long.class))))))).then(Commands.literal((String)"center").then(Commands.argument((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
            }
            double x = (Double)ctx.getArgument("x", Double.class);
            double z = (Double)ctx.getArgument("z", Double.class);
            if (Math.abs(x) > 2.9999984E7 || Math.abs(z) > 2.9999984E7) {
                throw ERROR_TOO_FAR_OUT.create();
            }
            WorldBorder border = world.level().getWorldBorder();
            border.setCenter(x, z);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.center.success", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", x), String.format(Locale.ROOT, "%.2f", z)})));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"damage").then(Commands.literal((String)"amount").then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
            }
            double value = (Double)ctx.getArgument("value", Double.class);
            WorldBorder border = world.level().getWorldBorder();
            border.setDamagePerBlock(value);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.damage.amount.success", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", value)})));
            return 1;
        })))).then(Commands.literal((String)"buffer").then(Commands.argument((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
            }
            double distance = (Double)ctx.getArgument("distance", Double.class);
            WorldBorder border = world.level().getWorldBorder();
            border.setDamageSafeZone(distance);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.damage.buffer.success", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", distance)})));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"warning").then(Commands.literal((String)"distance").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
            }
            int value = (Integer)ctx.getArgument("value", Integer.class);
            WorldBorder border = world.level().getWorldBorder();
            border.setWarningBlocks(value);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.warning.distance.success", (Object[])new Object[]{value})));
            return 1;
        })))).then(Commands.literal((String)"time").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loaded()) {
                throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
            }
            int value = (Integer)ctx.getArgument("value", Integer.class);
            WorldBorder border = world.level().getWorldBorder();
            border.setWarningTime(value);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.warning.time.success", (Object[])new Object[]{value})));
            return 1;
        }))))).build();
    }

    private static int changeSize(CommandContext<CommandSourceStack> ctx, Function<Double, Double> getEnd, Function<Long, Long> getTime) throws CommandSyntaxException {
        double end;
        CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
        if (!world.loaded()) {
            throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
        }
        WorldBorder border = world.level().getWorldBorder();
        double start = border.getSize();
        if (start == (end = getEnd.apply(start).doubleValue())) {
            throw ERROR_SAME_SIZE.create();
        }
        if (end < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (end > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        double change = end - start;
        long time = getTime.apply(border.getLerpRemainingTime());
        if (time == 0L) {
            border.setSize(end);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.set.immediate", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", end)})));
        } else {
            border.lerpSizeBetween(start, end, time);
            if (change > 0.0) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.set.grow", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", end), Long.toString(time / 1000L)})));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.worldborder.set.shrink", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", end), Long.toString(time / 1000L)})));
            }
        }
        return (int)change;
    }
}

