/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.hotwop.worldmagic.CustomWorld;
import io.hotwop.worldmagic.WorldDeletionException;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.WorldMagicBootstrap;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class DeleteSubCommand {
    private static boolean awaitDeletion = false;

    private DeleteSubCommand() {
    }

    public static LiteralCommandNode<CommandSourceStack> buildNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(ctx -> ctx.getSender().hasPermission("worldmagic.command.world.delete"))).executes(ctx -> {
            CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
            if (!world.loading.loadControl()) {
                throw WorldMagicBootstrap.notLoadControlWorldException.create((Object)world.id.asString());
            }
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Objects.requireNonNull(commandSender);
            CommandSender selector0$temp = commandSender;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, ConsoleCommandSender.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Player pl = (Player)selector0$temp;
                    pl.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Are you sure?").appendNewline()).append((Component)Component.text((String)"5 seconds for answer: "))).append(Component.text((String)"[Yes]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.callback(aud -> {
                        aud.sendMessage((Component)Component.text((String)"Deleting world..."));
                        try {
                            WorldMagic.deleteWorld(world.id);
                        }
                        catch (WorldDeletionException e) {
                            aud.sendMessage((Component)Component.text((String)("Error to delete world: " + e.getMessage()), (TextColor)NamedTextColor.RED));
                        }
                    }, bl -> bl.uses(1).lifetime((TemporalAmount)Duration.ofSeconds(5L))))));
                    return 1;
                }
                case 1: {
                    ConsoleCommandSender console = (ConsoleCommandSender)selector0$temp;
                    if (awaitDeletion) {
                        awaitDeletion = false;
                        try {
                            WorldMagic.deleteWorld(world.id);
                        }
                        catch (WorldDeletionException e) {
                            throw WorldMagicBootstrap.worldDeleteException.create((Object)e.getMessage());
                        }
                    } else {
                        awaitDeletion = true;
                        Bukkit.getAsyncScheduler().runDelayed((Plugin)WorldMagic.instance(), task -> {
                            awaitDeletion = false;
                        }, 5L, TimeUnit.SECONDS);
                        console.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Are you sure?").appendNewline()).append((Component)Component.text((String)"5 seconds for answer: "))).append((Component)Component.text((String)"Type command again to confirm")));
                    }
                    return 1;
                }
            }
            return 0;
        })).build();
    }
}

