/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.hotwop.worldmagic.CustomWorld;
import io.hotwop.worldmagic.WorldMagicBootstrap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class MoveSubCommand {
    private MoveSubCommand() {
    }

    public static LiteralCommandNode<io.papermc.paper.command.brigadier.CommandSourceStack> buildNode() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"move").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3((boolean)true)).executes(ctx -> MoveSubCommand.move(false, world -> MoveSubCommand.getPos(world, (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx), (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx))).then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).executes(ctx -> MoveSubCommand.move(true, world -> MoveSubCommand.getPosAndRotation(world, (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx), (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx))))).then(Commands.literal((String)"spawn").executes(ctx -> MoveSubCommand.move(true, World::getSpawnLocation, (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx)))).then(Commands.literal((String)"here").executes(ctx -> MoveSubCommand.move(true, world -> {
            Location loc = ((io.papermc.paper.command.brigadier.CommandSourceStack)ctx.getSource()).getLocation().clone();
            loc.setWorld(world);
            return loc;
        }, (CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)ctx))))).build();
    }

    private static Location getPos(World world, CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> ctx) {
        Coordinates coords = (Coordinates)ctx.getArgument("pos", Coordinates.class);
        Vec3 vec = coords.getPosition((CommandSourceStack)ctx.getSource());
        return new Location(world, vec.x, vec.y, vec.z);
    }

    private static Location getPosAndRotation(World world, CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> ctx) {
        Coordinates coords = (Coordinates)ctx.getArgument("pos", Coordinates.class);
        Vec3 pos = coords.getPosition((CommandSourceStack)ctx.getSource());
        Coordinates rotation = (Coordinates)ctx.getArgument("rotation", Coordinates.class);
        Vec2 rot = rotation.getRotation((CommandSourceStack)ctx.getSource());
        return new Location(world, pos.x, pos.y, pos.z, rot.x, rot.y);
    }

    private static int move(boolean rotation, Function<World, Location> getLocation, CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> ctx) throws CommandSyntaxException {
        CustomWorld world = (CustomWorld)ctx.getArgument("world", CustomWorld.class);
        if (!world.loaded()) {
            throw WorldMagicBootstrap.worldNotLoaded.create((Object)world.id.asString());
        }
        List entities = (List)((EntitySelectorArgumentResolver)ctx.getArgument("target", EntitySelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)ctx.getSource());
        Location location = getLocation.apply(world.world());
        entities.forEach(entity -> {
            Location loc;
            if (rotation) {
                loc = location;
            } else {
                loc = location.clone();
                loc.setYaw(entity.getYaw());
                loc.setPitch(entity.getPitch());
            }
            entity.teleportAsync(loc, PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(success -> {
                if (!success.booleanValue()) {
                    entity.teleport(loc);
                }
            });
        });
        if (entities.size() == 1) {
            ((io.papermc.paper.command.brigadier.CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.teleport.success.location.single", (Object[])new Object[]{PaperAdventure.asVanilla((net.kyori.adventure.text.Component)((Entity)entities.getFirst()).name()), String.format(Locale.ROOT, "%f", location.getX()), String.format(Locale.ROOT, "%f", location.getY()), String.format(Locale.ROOT, "%f", location.getZ())})));
        } else {
            ((io.papermc.paper.command.brigadier.CommandSourceStack)ctx.getSource()).getSender().sendMessage(PaperAdventure.asAdventure((Component)Component.translatable((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{entities.size(), String.format(Locale.ROOT, "%f", location.getX()), String.format(Locale.ROOT, "%f", location.getY()), String.format(Locale.ROOT, "%f", location.getZ())})));
        }
        return 1;
    }
}

