/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.hotwop.worldmagic.util.VersionUtil;
import io.hotwop.worldmagic.util.Weather;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public final class NodeBuilders {
    private static final Field argumentSupplerField;

    private NodeBuilders() {
    }

    public static LiteralCommandNode<CommandSourceStack> buildGameruleNode(String root, final GameruleOperation value, final GameruleQuery get, Commands commands) {
        final LiteralArgumentBuilder builder = Commands.literal((String)root);
        VersionUtil.visitGameRules(VersionUtil.createGameRulesFromContext(((PaperCommands)commands).getBuildContext()), new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull GameRules.Key<T> key, // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull GameRules.Type<T> type) {
                builder.then(((LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(ctx -> get.consume(key, type, (CommandContext<CommandSourceStack>)ctx))).then(Commands.argument((String)"value", NodeBuilders.getGameruleArgument(type)).executes(ctx -> {
                    Object val = ctx.getArgument("value", Object.class);
                    return value.consume(key, type, val, (CommandContext<CommandSourceStack>)ctx);
                })));
            }
        });
        return builder.build();
    }

    public static LiteralCommandNode<CommandSourceStack> buildDifficultyNode(String root, DifficultyOperation op, QueryOperation query) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)root).executes(query::consume);
        for (Difficulty diff : Difficulty.values()) {
            builder.then(Commands.literal((String)diff.getKey()).executes(ctx -> op.consume(diff, (CommandContext<CommandSourceStack>)ctx)));
        }
        return builder.build();
    }

    public static LiteralCommandNode<CommandSourceStack> buildWeatherNode(String root, WeatherOperation op, QueryOperation query) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)root).executes(query::consume);
        for (Weather weather : Weather.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.literal((String)weather.id).executes(ctx -> op.consume(weather, -1, (CommandContext<CommandSourceStack>)ctx))).then(Commands.argument((String)"duration", (ArgumentType)ArgumentTypes.time((int)1)).executes(ctx -> op.consume(weather, (Integer)ctx.getArgument("duration", Integer.class), (CommandContext<CommandSourceStack>)ctx))));
        }
        return builder.build();
    }

    public static LiteralCommandNode<CommandSourceStack> buildSetTimeNode(String root, SetTimeOperation op) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)root).then(Commands.argument((String)"value", (ArgumentType)ArgumentTypes.time((int)0)).executes(ctx -> op.consume((Integer)ctx.getArgument("value", Integer.class), (CommandContext<CommandSourceStack>)ctx)));
        for (SetTimeTimes time : SetTimeTimes.values()) {
            builder.then(Commands.literal((String)time.name()).executes(ctx -> op.consume(time.time, (CommandContext<CommandSourceStack>)ctx)));
        }
        return builder.build();
    }

    private static <T extends GameRules.Value<T>> ArgumentType<?> getGameruleArgument(GameRules.Type<T> type) {
        Supplier supp;
        try {
            supp = (Supplier)argumentSupplerField.get(type);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return (ArgumentType)supp.get();
    }

    public static NamespacedKey readNamespacedKey(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.isAllowedInResourceLocation((char)reader.peek())) {
            reader.skip();
        }
        String str = reader.getString().substring(i, reader.getCursor());
        NamespacedKey out = NamespacedKey.fromString((String)str);
        if (out == null) {
            reader.setCursor(i);
            throw ResourceLocation.ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
        return out;
    }

    static {
        try {
            argumentSupplerField = GameRules.Type.class.getDeclaredField("argument");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        argumentSupplerField.setAccessible(true);
    }

    @FunctionalInterface
    public static interface GameruleQuery {
        public int consume(GameRules.Key<?> var1, GameRules.Type<?> var2, CommandContext<CommandSourceStack> var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface GameruleOperation {
        public int consume(GameRules.Key<?> var1, GameRules.Type<?> var2, Object var3, CommandContext<CommandSourceStack> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface QueryOperation {
        public int consume(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface DifficultyOperation {
        public int consume(Difficulty var1, CommandContext<CommandSourceStack> var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface WeatherOperation {
        public int consume(Weather var1, int var2, CommandContext<CommandSourceStack> var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface SetTimeOperation {
        public int consume(int var1, CommandContext<CommandSourceStack> var2) throws CommandSyntaxException;
    }

    public static enum SetTimeTimes {
        day(1000),
        noon(6000),
        night(13000),
        midnight(18000);

        public final int time;

        private SetTimeTimes(int time) {
            this.time = time;
        }
    }
}

