/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.command.NodeBuilders;
import io.hotwop.worldmagic.file.WorldFile;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public final class WorldFileArgument
implements CustomArgumentType<WorldFile, NamespacedKey> {
    public static final WorldFileArgument instance = new WorldFileArgument();
    public static final DynamicCommandExceptionType unknownWorldFileException = new DynamicCommandExceptionType(obj -> Component.literal((String)("World file " + String.valueOf(obj) + " not exist")));

    private WorldFileArgument() {
    }

    @NotNull
    public WorldFile parse(@NotNull StringReader reader) throws CommandSyntaxException {
        NamespacedKey fileId = NodeBuilders.readNamespacedKey(reader);
        WorldFile file = WorldMagic.getWorldFile(fileId);
        if (file == null) {
            throw unknownWorldFileException.create((Object)fileId.asString());
        }
        return file;
    }

    @NotNull
    public ArgumentType<NamespacedKey> getNativeType() {
        return ArgumentTypes.namespacedKey();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> ctx, @NotNull SuggestionsBuilder builder) {
        String input = builder.getRemaining();
        if (input.isEmpty()) {
            WorldMagic.getWorldFileIds().forEach(id -> builder.suggest(id.asString()));
        } else {
            WorldMagic.getWorldFileIds().stream().filter(id -> id.asString().startsWith(input) || id.asMinimalString().startsWith(input)).forEach(id -> builder.suggest(id.asString()));
        }
        return builder.buildFuture();
    }
}

