/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.file;

import io.hotwop.worldmagic.api.GameRuleSet;
import io.hotwop.worldmagic.api.settings.AllowSettings;
import io.hotwop.worldmagic.api.settings.Loading;
import io.hotwop.worldmagic.api.settings.SpawnPosition;
import io.hotwop.worldmagic.api.settings.WorldBorderSettings;
import io.hotwop.worldmagic.api.settings.WorldProperties;
import io.hotwop.worldmagic.file.WorldFile;
import io.hotwop.worldmagic.generation.GameRuleFactory;
import io.hotwop.worldmagic.util.VersionUtil;
import java.util.List;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.border.WorldBorder;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.jetbrains.annotations.NotNull;

public final class FileUtil {
    private FileUtil() {
    }

    public static WorldBorder.Settings buildWorldBorder(WorldBorderSettings plugin) {
        WorldBorder handle = new WorldBorder();
        handle.setSize(plugin.size());
        handle.setDamageSafeZone(plugin.safeZone());
        handle.setDamagePerBlock(plugin.damagePerBlock());
        handle.setCenter(plugin.centerX(), plugin.centerZ());
        handle.setWarningBlocks(plugin.warningDistance());
        handle.setWarningTime(plugin.warningTime());
        return handle.createSettings();
    }

    public static AllowSettings fromFile(WorldFile.AllowSettings file) {
        return new AllowSettings(file.animals, file.monsters, file.pvp);
    }

    public static Loading fromFile(WorldFile.Loading file) {
        return new Loading(file.async, file.loadChunks, file.save, file.folderDeletion, file.loadControl);
    }

    public static SpawnPosition fromFile(WorldFile.SpawnPosition file) {
        return new SpawnPosition(file.override, file.x, file.y, file.z, file.yaw);
    }

    public static WorldBorderSettings fromFile(WorldFile.WorldBorderSettings file) {
        return new WorldBorderSettings(file.override, file.size, file.safeZone, file.damagePerBlock, file.center.x, file.center.z, file.warning.distance, file.warning.time);
    }

    public static WorldProperties fromFile(WorldFile.WorldProperties file) {
        return new WorldProperties(file.override, file.seed, file.generateStructures, file.bonusChest, file.forceGamemode, file.difficulty, file.requiredPermission, file.enterPayment);
    }

    public static GameRuleFactory toFactory(GameRuleSet set, boolean override) {
        final List<GameRuleSet.GameRuleStatement<?>> statements = set.getStatements();
        final GameRules out = VersionUtil.createGameRules();
        VersionUtil.visitGameRules(out, new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull GameRules.Key<T> key, // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull GameRules.Type<T> type) {
                String id = key.getId();
                statements.stream().filter(st -> st.gameRule().getName().equals(id)).findAny().ifPresent(st -> out.getRule(key).setFrom((GameRules.Value)st.value(), null));
            }
        });
        return new GameRuleFactory(override, out);
    }

    public static void fromFactory(final GameRuleSet out, final GameRuleFactory factory) {
        VersionUtil.visitGameRules(factory.gameRules, new GameRules.GameRuleTypeVisitor(){

            public void visitInteger(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                int value = factory.gameRules.getInt(key);
                if (((GameRules.IntegerValue)type.createRule()).get() == value) {
                    return;
                }
                out.set(GameRule.getByName((String)key.getId()), value);
            }

            public void visitBoolean(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                boolean value = factory.gameRules.getBoolean(key);
                if (((GameRules.BooleanValue)type.createRule()).get() == value) {
                    return;
                }
                out.set(GameRule.getByName((String)key.getId()), value);
            }
        });
    }

    public static net.minecraft.world.Difficulty mapDifficulty(Difficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: {
                return net.minecraft.world.Difficulty.PEACEFUL;
            }
            case EASY: {
                return net.minecraft.world.Difficulty.EASY;
            }
            case NORMAL: {
                return net.minecraft.world.Difficulty.NORMAL;
            }
            case HARD: {
                return net.minecraft.world.Difficulty.HARD;
            }
        }
        throw new RuntimeException();
    }

    public static GameType mapGameMode(GameMode gamemode) {
        switch (gamemode) {
            case SURVIVAL: {
                return GameType.SURVIVAL;
            }
            case CREATIVE: {
                return GameType.CREATIVE;
            }
            case ADVENTURE: {
                return GameType.ADVENTURE;
            }
            case SPECTATOR: {
                return GameType.SPECTATOR;
            }
        }
        throw new RuntimeException();
    }
}

