/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.file;

import io.hotwop.worldmagic.api.LocationResolver;
import io.hotwop.worldmagic.generation.Dimension;
import io.hotwop.worldmagic.generation.GameRuleFactory;
import io.hotwop.worldmagic.generation.GeneratorSettings;
import io.hotwop.worldmagic.util.serializer.ConfigRange;
import io.hotwop.worldmagic.util.serializer.LocationResolverSerializer;
import io.hotwop.worldmagic.util.serializer.NamespacedKeySerializer;
import java.nio.file.Path;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.Constraint;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@ConfigSerializable
public final class WorldFile {
    public static final ObjectMapper.Factory objectFactory = ObjectMapper.factoryBuilder().addConstraint(ConfigRange.class, Number.class, (Constraint.Factory)ConfigRange.Factory.instance).build();
    public static final TypeSerializerCollection serializers = TypeSerializerCollection.builder().register((ScalarSerializer)NamespacedKeySerializer.instance).register(Dimension.class, (TypeSerializer)Dimension.Serializer.instance).register(LocationResolver.class, (TypeSerializer)LocationResolverSerializer.instance).register(GameRuleFactory.class, (TypeSerializer)GameRuleFactory.Serializer.instance).registerAll(GeneratorSettings.serializer).registerAnnotatedObjects(objectFactory).build();
    @Required
    public NamespacedKey id;
    public String bukkitId;
    public String folder;
    public boolean prototype = false;
    public WorldProperties worldProperties;
    public Dimension dimension = new Dimension.Reference(NamespacedKey.minecraft((String)"overworld"));
    public Loading loading;
    public SpawnPosition spawnPosition = null;
    public LocationResolver callbackLocation = null;
    public AllowSettings allowSettings;
    public GameRuleFactory gamerules;
    public WorldBorderSettings border;

    public static YamlConfigurationLoader createLoader(Path path) {
        return ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).indent(2).defaultOptions(bl -> bl.serializers(sr -> sr.registerAll(serializers)))).build();
    }

    @ConfigSerializable
    public static final class SpawnPosition {
        public boolean override = false;
        @Required
        public int x;
        @Required
        public int y;
        @Required
        public int z;
        @ConfigRange(min=-180, max=180)
        public float yaw = 0.0f;
    }

    @ConfigSerializable
    public static final class WorldBorderSettings {
        public boolean override = false;
        public double size = 2.9999984E7;
        public double safeZone = 5.0;
        public double damagePerBlock = 0.2;
        public Center center = new Center();
        public Warning warning = new Warning();

        @ConfigSerializable
        public static final class Center {
            public double x = 0.0;
            public double z = 0.0;
        }

        @ConfigSerializable
        public static final class Warning {
            public int distance = 5;
            public int time = 300;
        }
    }

    @ConfigSerializable
    public static final class AllowSettings {
        public boolean animals = true;
        public boolean monsters = true;
        public boolean pvp = true;
    }

    @ConfigSerializable
    public static final class Loading {
        public boolean async = false;
        public boolean startup = true;
        public boolean loadChunks = true;
        public boolean save = true;
        public boolean folderDeletion = false;
        public boolean loadControl = true;
    }

    @ConfigSerializable
    public static final class WorldProperties {
        public boolean override = true;
        public Long seed;
        public boolean generateStructures = true;
        public boolean bonusChest = false;
        public GameMode forceGamemode = null;
        public Difficulty difficulty = Difficulty.NORMAL;
        public String requiredPermission;
        @ConfigRange(min=0)
        public Integer enterPayment;
    }
}

