/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.generation;

import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.api.DimensionLike;
import io.hotwop.worldmagic.generation.GeneratorSettings;
import io.hotwop.worldmagic.util.VersionUtil;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public sealed interface Dimension
extends DimensionLike {
    public LevelStem get();

    public ResourceKey<LevelStem> getKey();

    public static final class Serializer
    implements TypeSerializer<Dimension> {
        public static final Serializer instance = new Serializer();

        private Serializer() {
        }

        public Dimension deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
            if (node.isMap()) {
                ConfigurationNode dimensionNode = node.node(new Object[]{"dimension-type"});
                ConfigurationNode generatorNode = node.node(new Object[]{"generator"});
                if (dimensionNode.virtual()) {
                    throw new SerializationException(node, Dimension.class, "Missing dimension-type node");
                }
                if (generatorNode.virtual()) {
                    throw new SerializationException(node, Dimension.class, "Missing generator node");
                }
                ConfigurationNode pluginBiomeNode = node.node(new Object[]{"plugin-biomes"});
                NamespacedKey dimension = (NamespacedKey)dimensionNode.require(NamespacedKey.class);
                GeneratorSettings settings = (GeneratorSettings)generatorNode.require(GeneratorSettings.class);
                String pluginBiome = pluginBiomeNode.virtual() ? null : pluginBiomeNode.getString();
                return new Inline(dimension, settings, pluginBiome);
            }
            NamespacedKey dimension = (NamespacedKey)node.require(NamespacedKey.class);
            return new Reference(dimension);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void serialize(@NotNull Type type, @Nullable Dimension obj, @NotNull ConfigurationNode node) throws SerializationException {
            Dimension dimension = obj;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, Inline.class}, (Object)dimension, n)) {
                case -1: {
                    return;
                }
                case 0: {
                    NamespacedKey id;
                    Reference reference = (Reference)dimension;
                    try {
                        NamespacedKey namespacedKey;
                        id = namespacedKey = reference.id();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    node.set((Object)id);
                    return;
                }
                case 1: {
                    Object pluginGenerator;
                    Object generator;
                    NamespacedKey dimensionType;
                    Inline inline = (Inline)dimension;
                    {
                        Object object;
                        dimensionType = object = inline.dimensionType();
                        generator = object = inline.generator();
                        pluginGenerator = object = inline.pluginBiomes();
                    }
                    node.node(new Object[]{"dimension-type"}).set((Object)dimensionType);
                    node.node(new Object[]{"generator"}).set(generator);
                    if (pluginGenerator == null) return;
                    node.node(new Object[]{"plugin-biomes"}).set(pluginGenerator);
                    return;
                }
            }
            throw new SerializationException();
        }
    }

    public record Inline(NamespacedKey dimensionType, GeneratorSettings generator, @Nullable String pluginBiomes) implements Dimension
    {
        public static final FlatLevelSource emptyGenerator;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public LevelStem get() {
            FlatLevelSource flatLevelSource;
            Registry type = VersionUtil.getRegistry(Registries.DIMENSION_TYPE);
            Holder.Reference reference = VersionUtil.getHolderOrThrow(type, ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)VersionUtil.createResourceLocation(this.dimensionType)), () -> new RuntimeException("Error to get dimension type: " + this.dimensionType.asString()));
            GeneratorSettings generatorSettings = this.generator;
            if (!(generatorSettings instanceof GeneratorSettings.Vanilla)) {
                flatLevelSource = emptyGenerator;
                return new LevelStem(reference, (ChunkGenerator)flatLevelSource);
            }
            GeneratorSettings.Vanilla vanilla = (GeneratorSettings.Vanilla)generatorSettings;
            try {
                ChunkGenerator chunkGenerator;
                ChunkGenerator generatorVan = chunkGenerator = vanilla.generator();
                flatLevelSource = generatorVan;
                return new LevelStem(reference, (ChunkGenerator)flatLevelSource);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        @Override
        public ResourceKey<LevelStem> getKey() {
            Registry reg = VersionUtil.getRegistry(Registries.LEVEL_STEM);
            ResourceLocation loc = reg.getKey((Object)this.get());
            if (loc == null) {
                return null;
            }
            return ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)loc);
        }

        static {
            Registry biomeRegistry = VersionUtil.getRegistry(Registries.BIOME);
            emptyGenerator = new FlatLevelSource(new FlatLevelGeneratorSettings(Optional.empty(), (Holder)Holder.Reference.createStandAlone(VersionUtil.getHolderOwner(biomeRegistry), (ResourceKey)Biomes.THE_VOID), List.of()));
        }
    }

    public record Reference(NamespacedKey id) implements Dimension
    {
        @Override
        public ResourceKey<LevelStem> getKey() {
            return ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)VersionUtil.createResourceLocation(this.id));
        }

        @Override
        public LevelStem get() {
            return (LevelStem)VersionUtil.registryGet(Registries.LEVEL_STEM, (RegistryAccess)WorldMagic.vanillaServer().registryAccess(), this.id);
        }
    }
}

