/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.generation;

import io.hotwop.worldmagic.util.VersionUtil;
import java.lang.reflect.Type;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.GameRules;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v7.ConfigurateOps;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class GameRuleFactory {
    public final GameRules gameRules;
    public final boolean override;

    public GameRuleFactory(boolean override, GameRules rules) {
        this.gameRules = rules;
        this.override = override;
    }

    public static final class Serializer
    implements TypeSerializer<GameRuleFactory> {
        public static final Serializer instance = new Serializer();

        private Serializer() {
        }

        public GameRuleFactory deserialize(@NotNull Type type, final @NotNull ConfigurationNode node) throws SerializationException {
            boolean override = node.node(new Object[]{"override"}).getBoolean();
            final GameRules rules = VersionUtil.createGameRules();
            VersionUtil.visitGameRules(rules, new GameRules.GameRuleTypeVisitor(){

                public void visitBoolean(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                    ConfigurationNode subNode = node.node(new Object[]{key.getId()});
                    if (!subNode.virtual()) {
                        ((GameRules.BooleanValue)rules.getRule(key)).set(subNode.getBoolean(), null);
                    }
                }

                public void visitInteger(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                    ConfigurationNode subNode = node.node(new Object[]{key.getId()});
                    if (!subNode.virtual()) {
                        ((GameRules.IntegerValue)rules.getRule(key)).set(subNode.getInt(), null);
                    }
                }
            });
            return new GameRuleFactory(override, rules);
        }

        public void serialize(@NotNull Type type, @Nullable GameRuleFactory obj, @NotNull ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                return;
            }
            if (obj.override) {
                node.node(new Object[]{"override"}).set((Object)true);
            }
            ConfigurationNode gameRuleNode = (ConfigurationNode)NbtOps.INSTANCE.convertTo(ConfigurateOps.instance(), (Tag)obj.gameRules.createTag());
            node.from(gameRuleNode);
        }
    }
}

