/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.generation;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.api.GeneratorLike;
import io.hotwop.worldmagic.util.serializer.EnumSwitchSerializer;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.extra.dfu.v7.ConfigurateOps;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public sealed interface GeneratorSettings
extends GeneratorLike {
    public static final TypeSerializerCollection serializer = TypeSerializerCollection.builder().register((ScalarSerializer)Plugin.Serializer.instance).register(Vanilla.class, (TypeSerializer)Vanilla.Serializer.instance).registerExact(GeneratorSettings.class, EnumSwitchSerializer.builder(GeneratorSettings.class, GenType.class, "source", "settings").define(GenType.vanilla, Vanilla.class).define(GenType.plugin, Plugin.class).build()).build();

    public DedicatedServerProperties.WorldDimensionData create();

    public record Plugin(String generator) implements GeneratorSettings
    {
        @Override
        public DedicatedServerProperties.WorldDimensionData create() {
            return new DedicatedServerProperties.WorldDimensionData(GsonHelper.parse((String)"{\"layers\":[],\"biome\":\"the_void\"}"), "flat");
        }

        public static final class Serializer
        extends ScalarSerializer<Plugin> {
            public static final Serializer instance = new Serializer();

            private Serializer() {
                super(Plugin.class);
            }

            public Plugin deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
                if (obj instanceof String) {
                    String str = (String)obj;
                    return new Plugin(str);
                }
                throw new SerializationException("Generator name expected as plugin generator");
            }

            @NotNull
            protected Object serialize(Plugin item, @NotNull Predicate<Class<?>> typeSupported) {
                return item.generator;
            }
        }
    }

    public record Vanilla(ChunkGenerator generator) implements GeneratorSettings
    {
        @Override
        public DedicatedServerProperties.WorldDimensionData create() {
            ChunkGenerator chunkGenerator = this.generator;
            if (chunkGenerator instanceof FlatLevelSource) {
                FlatLevelSource fl = (FlatLevelSource)chunkGenerator;
                JsonObject obj = (JsonObject)FlatLevelGeneratorSettings.CODEC.encode((Object)fl.settings(), (DynamicOps)WorldMagic.vanillaServer().registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)new JsonObject()).getOrThrow();
                return new DedicatedServerProperties.WorldDimensionData(obj, "flat");
            }
            return new DedicatedServerProperties.WorldDimensionData(new JsonObject(), "normal");
        }

        public static final class Serializer
        implements TypeSerializer<Vanilla> {
            public static final Serializer instance = new Serializer();

            private Serializer() {
            }

            public Vanilla deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
                ChunkGenerator gen = (ChunkGenerator)ChunkGenerator.CODEC.parse((DynamicOps)WorldMagic.vanillaServer().registryAccess().createSerializationContext(ConfigurateOps.instance()), (Object)node).getOrThrow(err -> new SerializationException(node, GeneratorSettings.class, "Error to deserialize vanilla generator settings:\n     " + err.replace(";", "\n    ")));
                return new Vanilla(gen);
            }

            public void serialize(@NotNull Type type, @Nullable Vanilla obj, @NotNull ConfigurationNode node) throws SerializationException {
                if (obj == null) {
                    return;
                }
                ChunkGenerator.CODEC.encode((Object)obj.generator, (DynamicOps)WorldMagic.vanillaServer().registryAccess().createSerializationContext(ConfigurateOps.instance()), (Object)node).getOrThrow(err -> new SerializationException(node, GeneratorSettings.class, "Error to serialize vanilla generator settings:\n     " + err.replace(";", "\n    ")));
            }
        }
    }

    public static enum GenType {
        vanilla,
        plugin;

    }
}

