/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.integration.papi;

import io.hotwop.worldmagic.CustomWorld;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.integration.papi.PlaceholderResolver;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public final class WorldResolver
implements PlaceholderResolver {
    private final Pattern pattern;
    private final Function<CustomWorld, String> consumer;

    public WorldResolver(String name, Function<CustomWorld, String> consumer) {
        this.pattern = Pattern.compile("world_<[^>\\s]+>_" + name);
        this.consumer = consumer;
    }

    @Override
    public String check(@NotNull String input) {
        if (this.pattern.matcher(input).matches()) {
            String name = input.split("_")[1];
            NamespacedKey id = NamespacedKey.fromString((String)name.substring(1, name.length() - 1));
            if (id == null) {
                return "";
            }
            return this.consumer.apply(WorldMagic.getPluginWorld(id));
        }
        return null;
    }
}

