/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util;

import com.mojang.serialization.Lifecycle;
import io.hotwop.worldmagic.util.VersionUtil;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistrationUtil {
    static final Field frozenField;
    static final Field byIdField;
    static final Field toIdField;
    static final Field byLocationField;
    static final Field byKeyField;
    static final Field byValueField;
    static final Field registrationInfosField;
    static final Field valueHolderField;

    private RegistrationUtil() {
    }

    public static <T> void registerIgnoreFreeze(ResourceKey<Registry<T>> registry, RegistryAccess access, ResourceKey<T> id, T value, Lifecycle lifecycle) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        if (reg instanceof WritableRegistry) {
            WritableRegistry wr = (WritableRegistry)reg;
            if (wr instanceof MappedRegistry) {
                boolean frozen;
                MappedRegistry map = (MappedRegistry)wr;
                try {
                    frozen = frozenField.getBoolean(map);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (frozen) {
                    try {
                        frozenField.setBoolean(map, false);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                map.register(id, value, new RegistrationInfo(Optional.empty(), lifecycle));
                if (frozen) {
                    try {
                        frozenField.setBoolean(map, true);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                wr.register(id, value, new RegistrationInfo(Optional.empty(), lifecycle));
            }
        } else {
            throw new RuntimeException("Registry isn't writable at all");
        }
    }

    public static <T> void bindRegistration(ResourceKey<Registry<T>> registry, RegistryAccess access, ResourceKey<T> id, T value) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        Holder.Reference<T> ref = VersionUtil.getHolder(reg, id);
        if (ref != null) {
            try {
                valueHolderField.set(ref, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> void unregisterAll(ResourceKey<Registry<T>> registry, RegistryAccess access, List<ResourceKey<T>> ids) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        if (reg instanceof MappedRegistry) {
            Map registrationInfos;
            Map byValue;
            Map byKey;
            Map byLocation;
            Reference2IntMap toId;
            ObjectList byId;
            try {
                byId = (ObjectList)byIdField.get(reg);
                toId = (Reference2IntMap)toIdField.get(reg);
                byLocation = (Map)byLocationField.get(reg);
                byKey = (Map)byKeyField.get(reg);
                byValue = (Map)byValueField.get(reg);
                registrationInfos = (Map)registrationInfosField.get(reg);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            for (ResourceKey<T> id : ids) {
                T value = VersionUtil.registryGet(reg, id.location());
                Holder.Reference<T> ref = VersionUtil.getHolderOrThrow(reg, id, RuntimeException::new);
                ResourceLocation loc = id.location();
                int index = byId.indexOf(ref);
                byId.remove(ref);
                toId.remove(value, index);
                byLocation.remove(loc);
                byKey.remove(id);
                byValue.remove(value);
                registrationInfos.remove(id);
            }
        } else {
            throw new RuntimeException("Can't uregister not mapped registry");
        }
    }

    public static <T> void registerIgnoreFreezeAll(ResourceKey<Registry<T>> registry, RegistryAccess access, Map<ResourceKey<T>, T> entries, Lifecycle lifecycle) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        if (reg instanceof WritableRegistry) {
            WritableRegistry wr = (WritableRegistry)reg;
            if (wr instanceof MappedRegistry) {
                boolean frozen;
                MappedRegistry map = (MappedRegistry)wr;
                try {
                    frozen = frozenField.getBoolean(map);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (frozen) {
                    try {
                        frozenField.setBoolean(map, false);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                RegistrationUtil.registerIgnoreFreezeAllOp(wr, entries, lifecycle);
                if (frozen) {
                    try {
                        frozenField.setBoolean(map, true);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                RegistrationUtil.registerIgnoreFreezeAllOp(wr, entries, lifecycle);
            }
        } else {
            throw new RuntimeException("Registry isn't writable at all");
        }
    }

    private static <T> void registerIgnoreFreezeAllOp(WritableRegistry<T> registry, Map<ResourceKey<T>, T> entries, Lifecycle lifecycle) {
        RegistrationInfo info = new RegistrationInfo(Optional.empty(), lifecycle);
        for (Map.Entry<ResourceKey<T>, T> entry : entries.entrySet()) {
            registry.register(entry.getKey(), entry.getValue(), info);
        }
    }

    public static <T> void bindRegistrations(ResourceKey<Registry<T>> registry, RegistryAccess access, Map<ResourceKey<T>, T> entries) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        for (Map.Entry<ResourceKey<T>, T> entry : entries.entrySet()) {
            Holder.Reference<T> ref = VersionUtil.getHolder(reg, entry.getKey());
            if (ref == null) continue;
            try {
                valueHolderField.set(ref, entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        try {
            frozenField = MappedRegistry.class.getDeclaredField("frozen");
            byIdField = MappedRegistry.class.getDeclaredField("byId");
            toIdField = MappedRegistry.class.getDeclaredField("toId");
            byLocationField = MappedRegistry.class.getDeclaredField("byLocation");
            byKeyField = MappedRegistry.class.getDeclaredField("byKey");
            byValueField = MappedRegistry.class.getDeclaredField("byValue");
            registrationInfosField = MappedRegistry.class.getDeclaredField("registrationInfos");
            valueHolderField = Holder.Reference.class.getDeclaredField("value");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        frozenField.setAccessible(true);
        byIdField.setAccessible(true);
        toIdField.setAccessible(true);
        byLocationField.setAccessible(true);
        byKeyField.setAccessible(true);
        byValueField.setAccessible(true);
        registrationInfosField.setAccessible(true);
        valueHolderField.setAccessible(true);
    }
}

