/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util;

import com.mojang.serialization.Dynamic;
import io.hotwop.worldmagic.WorldMagic;
import io.hotwop.worldmagic.version.MethodMapping;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Nullable;

public final class VersionUtil {
    public static final int dataVersion;
    private static final MethodMapping<Registry<?>> registryAccessorMapping;
    private static final MethodMapping<ResourceLocation> resourceLocationCreatorMapping;
    private static final MethodMapping<Optional<Holder.Reference<?>>> registryGetHolderMapping;
    private static final MethodMapping<?> registryGetValueMapping;
    public static final MethodMapping<GameRules> createGameRulesMapping;
    public static final MethodMapping<LevelDataAndDimensions> getLevelDataAndDimensions;
    public static final MethodMapping<WorldDimensions> createWorldDimensionsData;
    public static final MethodMapping<Void> forceUpgrade;
    public static final MethodMapping<Void> setDifficulty;
    private static final Method getHolderOwner;
    private static final Method setSpawnSettings;
    private static final Method gameRuleVisitor;
    private static final Method datapackWorldGen;
    private static final Method forcedChunksFactory;
    private static final Method forcedChunks;
    private static final Method dimensionDataStorageGet;

    private VersionUtil() {
    }

    @Nullable
    public static <T> T registryGet(ResourceKey<Registry<T>> registry, RegistryAccess access, NamespacedKey id) {
        Registry<T> reg = VersionUtil.getRegistry(access, registry);
        return VersionUtil.registryGet(reg, id);
    }

    @Nullable
    public static <T> T registryGet(Registry<T> registry, NamespacedKey id) {
        ResourceLocation rc = VersionUtil.createResourceLocation(id);
        return VersionUtil.registryGet(registry, rc);
    }

    @Nullable
    public static <T> T registryGet(Registry<T> registry, ResourceLocation id) {
        return (T)registryGetValueMapping.invokeWithExecutor(registry, id);
    }

    public static <T> HolderOwner<T> getHolderOwner(Registry<T> registry) {
        if (dataVersion < 4082) {
            try {
                return (HolderOwner)getHolderOwner.invoke(registry, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return registry;
    }

    public static ResourceLocation createResourceLocation(NamespacedKey id) {
        return VersionUtil.createResourceLocation(id.namespace(), id.value());
    }

    public static ResourceLocation createResourceLocation(String namespace, String id) {
        return resourceLocationCreatorMapping.invoke(namespace, id);
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> id) {
        return VersionUtil.getRegistry((RegistryAccess)WorldMagic.vanillaServer().registryAccess(), id);
    }

    public static <T> Registry<T> getRegistry(RegistryAccess access, ResourceKey<Registry<T>> id) {
        return registryAccessorMapping.invokeWithExecutor(access, id);
    }

    public static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Holder.Reference<T> getHolder(Registry<T> registry, ResourceKey<T> id) {
        return registryGetHolderMapping.invokeWithExecutor(registry, id).orElse(null);
    }

    public static <T> Holder.Reference<T> getHolderOrThrow(Registry<T> registry, ResourceKey<T> id, Supplier<RuntimeException> err) {
        return registryGetHolderMapping.invokeWithExecutor(registry, id).orElseThrow(err);
    }

    public static void undirtData(DimensionDataStorage st) {
        if (dataVersion < 4082) {
            st.cache.forEach((id, dat) -> {
                if (dat != null) {
                    ((SavedData)dat).setDirty(false);
                }
            });
        } else {
            st.cache.forEach((id, dat) -> dat.ifPresent(savedData -> savedData.setDirty(false)));
        }
    }

    public static void setSpawnSettings(ServerLevel level, boolean monsters, boolean animals) {
        if (dataVersion < 4082) {
            try {
                setSpawnSettings.invoke((Object)level, monsters, animals);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            level.setSpawnSettings(monsters);
            level.tickCustomSpawners(monsters, animals);
        }
    }

    public static GameRules createGameRules() {
        return createGameRulesMapping.invoke(new Object[0]);
    }

    public static GameRules createGameRulesFromContext(CommandBuildContext ctx) {
        if (dataVersion < 4082) {
            return VersionUtil.createGameRules();
        }
        return new GameRules(ctx.enabledFeatures());
    }

    public static void visitGameRules(GameRules rules, GameRules.GameRuleTypeVisitor visitor) {
        GameRules executor = dataVersion < 4082 ? null : rules;
        try {
            gameRuleVisitor.invoke((Object)executor, visitor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static LevelDataAndDimensions getLevelDataAndDimension(Dynamic<?> dynamic, WorldDataConfiguration dataConfiguration, Registry<LevelStem> dimensionsRegistry) {
        try {
            return getLevelDataAndDimensions.invoke(dynamic, dataConfiguration, dimensionsRegistry, datapackWorldGen.invoke((Object)WorldMagic.worldLoader(), new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static WorldDimensions createWorldDimensions(DedicatedServerProperties.WorldDimensionData data) {
        try {
            return createWorldDimensionsData.invokeWithExecutor(data, datapackWorldGen.invoke((Object)WorldMagic.worldLoader(), new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void computeForcedChunks(DimensionDataStorage storage, ServerChunkCache chunkCache) {
        if (dataVersion < 4325) {
            try {
                Object factory = forcedChunksFactory.invoke(null, new Object[0]);
                Object forcedData = dimensionDataStorageGet.invoke((Object)storage, factory, "chunks");
                if (forcedData == null) return;
                LongList chunks = (LongList)forcedChunks.invoke(forcedData, new Object[0]);
                LongListIterator chunksIterator = chunks.iterator();
                while (chunksIterator.hasNext()) {
                    chunkCache.updateChunkForced(new ChunkPos(chunksIterator.nextLong()), true);
                }
                return;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            TicketStorage st = (TicketStorage)storage.get(TicketStorage.TYPE);
            if (st == null) return;
            st.activateAllDeactivatedTickets();
        }
    }

    private static /* synthetic */ Object[] lambda$static$6(Object[] old) {
        return old;
    }

    private static /* synthetic */ Object[] lambda$static$5(Object[] old) {
        return new Object[]{old[0], old[1], old[3]};
    }

    private static /* synthetic */ Object[] lambda$static$4(Object[] old) {
        return old;
    }

    private static /* synthetic */ Object[] lambda$static$3(Object[] old) {
        return new Object[]{old[0], old[2], old[3], old[4], old[5], old[6]};
    }

    private static /* synthetic */ Object lambda$static$2(Object obj) {
        return obj;
    }

    private static /* synthetic */ Object lambda$static$1(Object obj) {
        return obj;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

