/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util;

import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;

public enum Weather {
    clear("clear", (level, duration) -> level.setWeatherParameters(Weather.getDuration(level, duration, ServerLevel.RAIN_DELAY), 0, false, false)),
    raining("rain", (level, duration) -> level.setWeatherParameters(0, Weather.getDuration(level, duration, ServerLevel.RAIN_DURATION), true, false)),
    thundering("thunder", (level, duration) -> level.setWeatherParameters(0, Weather.getDuration(level, duration, ServerLevel.THUNDER_DURATION), true, true));

    public final String id;
    private final BiConsumer<ServerLevel, Integer> applier;

    private Weather(String id, BiConsumer<ServerLevel, Integer> applier) {
        this.id = id;
        this.applier = applier;
    }

    public Component getSetComponent() {
        return Component.translatable((String)("commands.weather.set." + this.id));
    }

    public void apply(ServerLevel level, int duration) {
        this.applier.accept(level, duration);
    }

    public static Weather query(ServerLevel level) {
        if (level.isRaining()) {
            if (level.isThundering()) {
                return thundering;
            }
            return raining;
        }
        return clear;
    }

    private static int getDuration(ServerLevel level, int duration, IntProvider provider) {
        return duration == -1 ? provider.sample(level.getRandom()) : duration;
    }
}

