/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util.serializer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.objectmapping.meta.Constraint;
import org.spongepowered.configurate.serialize.SerializationException;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface ConfigRange {
    public int min() default -2147483648;

    public int max() default 0x7FFFFFFF;

    public static final class Factory
    implements Constraint.Factory<ConfigRange, Number> {
        public static final Factory instance = new Factory();

        private Factory() {
        }

        @NotNull
        public Constraint<Number> make(ConfigRange data, @NotNull Type type) {
            return value -> {
                if (value != null && (value.intValue() < data.min() || value.intValue() > data.max())) {
                    throw new SerializationException("Value not in range " + data.min() + " - " + data.max());
                }
            };
        }
    }
}

