/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util.serializer;

import java.lang.reflect.AccessFlag;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class EnumSwitchSerializer<T, E extends Enum<?>>
implements TypeSerializer<T> {
    private final Class<T> clazz;
    private final Class<E> enm;
    private final Object typeNode;
    private final Object valueNode;
    private final boolean parent;
    private final Map<E, Class<? extends T>> toClass;
    private final Map<Class<? extends T>, E> toEnum;
    private final Map<E, NotNodeData<? extends T>> toNotNode;
    private final Map<Class<? extends T>, E> fromNotNode;

    private EnumSwitchSerializer(Class<T> clazz, Class<E> enm, Object typeNode, Object valueNode, boolean parent, Map<E, Class<? extends T>> toClass, Map<Class<? extends T>, E> toEnum, Map<E, NotNodeData<? extends T>> toNotNode, Map<Class<? extends T>, E> fromNotNode) {
        this.clazz = clazz;
        this.enm = enm;
        this.typeNode = typeNode;
        this.valueNode = valueNode;
        this.parent = parent;
        this.toClass = toClass;
        this.toEnum = toEnum;
        this.toNotNode = toNotNode;
        this.fromNotNode = fromNotNode;
    }

    public static <T, E extends Enum<?>> Builder<T, E> builder(Class<T> clazz, Class<E> enm, Object typeNode) {
        Objects.requireNonNull(typeNode);
        if (clazz.accessFlags().contains((Object)AccessFlag.FINAL)) {
            throw new RuntimeException("Error to build EnumSwitchSerializer: switchable class can't be final");
        }
        return new Builder<T, E>(clazz, enm, typeNode, null, true);
    }

    public static <T, E extends Enum<?>> Builder<T, E> builder(Class<T> clazz, Class<E> enm, Object typeNode, Object valueNode) {
        Objects.requireNonNull(typeNode);
        Objects.requireNonNull(valueNode);
        if (clazz.accessFlags().contains((Object)AccessFlag.FINAL)) {
            throw new RuntimeException("Error to build EnumSwitchSerializer: switchable class can't be final");
        }
        return new Builder<T, E>(clazz, enm, typeNode, valueNode, false);
    }

    public T deserialize(@NotNull Type typ, @NotNull ConfigurationNode node) throws SerializationException {
        if (this.parent) {
            ConfigurationNode parentNode = node.parent();
            if (parentNode == null) {
                throw new SerializationException(node, this.clazz, "Parented enum switch can't be a root");
            }
            ConfigurationNode typNode = parentNode.node(new Object[]{this.typeNode});
            if (typNode.virtual()) {
                return null;
            }
            return this.deserialize(typ, typNode, node, node);
        }
        ConfigurationNode typNode = node.node(new Object[]{this.typeNode});
        if (typNode.virtual()) {
            return null;
        }
        ConfigurationNode valNode = node.node(new Object[]{this.valueNode});
        return this.deserialize(typ, typNode, valNode, node);
    }

    private T deserialize(@NotNull Type typ, @NotNull ConfigurationNode typNode, @NotNull ConfigurationNode valNode, @NotNull ConfigurationNode origin) throws SerializationException {
        Enum type = (Enum)typNode.require(this.enm);
        if (this.toClass.containsKey(type)) {
            if (valNode.virtual()) {
                return null;
            }
            Class<T> subClass = this.toClass.get(type);
            TypeSerializer serializer = origin.options().serializers().get(subClass);
            if (serializer == null || serializer.equals((Object)this)) {
                if (subClass.isAnnotationPresent(ConfigSerializable.class)) {
                    ObjectMapper mapper = ObjectMapper.factory().get(subClass);
                    return (T)mapper.load(valNode);
                }
                throw new SerializationException(origin, this.clazz, "Enum switch: Class " + subClass.getName() + " hasn't own serializer");
            }
            return (T)serializer.deserialize(typ, valNode);
        }
        if (this.toNotNode.containsKey(type)) {
            NotNodeData<? extends T> data = this.toNotNode.get(type);
            return (T)data.supply.get();
        }
        throw new SerializationException(origin, this.clazz, "Enum switch hasn't definition for enum " + type.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NotNull Type typ, @Nullable T obj, @NotNull ConfigurationNode node) throws SerializationException {
        ConfigurationNode typNode;
        Enum type;
        if (obj == null) {
            return;
        }
        Class<T> subClass = obj.getClass().asSubclass(this.clazz);
        if (this.toEnum.containsKey(subClass)) {
            ConfigurationNode valNode;
            type = (Enum)this.toEnum.get(subClass);
            TypeSerializer serializer = node.options().serializers().get(subClass);
            ConfigurationNode configurationNode = valNode = this.parent ? node : node.node(new Object[]{this.valueNode});
            if (serializer == null || serializer.equals((Object)this)) {
                if (!subClass.isAnnotationPresent(ConfigSerializable.class)) throw new SerializationException(node, this.clazz, "Enum switch: Class " + subClass.getName() + " hasn't own serializer");
                ObjectMapper mapper = ObjectMapper.factory().get(subClass);
                mapper.save(obj, valNode);
            } else {
                serializer.serialize(typ, obj, valNode);
            }
        } else {
            if (!this.fromNotNode.containsKey(subClass)) throw new SerializationException(node, this.clazz, "Class " + subClass.getName() + " wasn't defined in enum switch");
            type = (Enum)this.fromNotNode.get(subClass);
        }
        if (this.parent) {
            ConfigurationNode parentNode = node.parent();
            if (parentNode == null) {
                throw new SerializationException(node, this.clazz, "Parented enum switch can't be a root");
            }
            typNode = parentNode.node(new Object[]{this.typeNode});
            if (!typNode.virtual()) {
                throw new SerializationException(node, this.clazz, "Parented enum switch: Type node already defined");
            }
        } else {
            typNode = node.node(new Object[]{this.typeNode});
        }
        typNode.set((Object)type);
    }

    public static final class Builder<T, E extends Enum<?>> {
        private final Class<T> clazz;
        private final Class<E> enm;
        private final Object typeNode;
        private final Object valueNode;
        private final boolean parent;
        private final Map<E, Class<? extends T>> toClass = new HashMap<E, Class<? extends T>>();
        private final Map<Class<? extends T>, E> toEnum = new HashMap<Class<? extends T>, E>();
        private final Map<E, NotNodeData<? extends T>> toNotNode = new HashMap<E, NotNodeData<? extends T>>();
        private final Map<Class<? extends T>, E> fromNotNode = new HashMap<Class<? extends T>, E>();

        private Builder(Class<T> clazz, Class<E> enm, Object typeNode, Object valueNode, boolean parent) {
            this.clazz = clazz;
            this.enm = enm;
            this.typeNode = typeNode;
            this.valueNode = valueNode;
            this.parent = parent;
        }

        public Builder<T, E> define(E enm, Class<? extends T> clazz) {
            if (this.toClass.containsKey(enm) || this.toNotNode.containsKey(enm)) {
                throw new RuntimeException("Error to build EnumSwitchSerializer: Enum " + ((Enum)enm).name() + " already defined");
            }
            if (this.toEnum.containsKey(clazz) || this.fromNotNode.containsKey(clazz)) {
                throw new RuntimeException("Error to build EnumSwitchSerializer: Class " + clazz.getName() + " already used");
            }
            this.toClass.put(enm, clazz);
            this.toEnum.put(clazz, enm);
            return this;
        }

        public <V extends T> Builder<T, E> defineNotNode(E enm, Class<V> clazz, Supplier<V> supply) {
            if (this.toClass.containsKey(enm) || this.toNotNode.containsKey(enm)) {
                throw new RuntimeException("Error to build EnumSwitchSerializer: Enum " + ((Enum)enm).name() + " already defined");
            }
            if (this.toEnum.containsKey(clazz) || this.fromNotNode.containsKey(clazz)) {
                throw new RuntimeException("Error to build EnumSwitchSerializer: Class " + clazz.getName() + " already used");
            }
            this.toNotNode.put(enm, new NotNodeData<V>(clazz, supply));
            this.fromNotNode.put(clazz, enm);
            return this;
        }

        public EnumSwitchSerializer<T, E> build() {
            if (this.toClass.isEmpty() && this.fromNotNode.isEmpty()) {
                throw new RuntimeException("Error to build EnumSwitchSerializer: No one case is defined");
            }
            return new EnumSwitchSerializer<T, E>(this.clazz, this.enm, this.typeNode, this.valueNode, this.parent, Map.copyOf(this.toClass), Map.copyOf(this.toEnum), Map.copyOf(this.toNotNode), Map.copyOf(this.fromNotNode));
        }
    }

    private record NotNodeData<V>(Class<V> clazz, Supplier<V> supply) {
    }
}

