/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.util.serializer;

import io.hotwop.worldmagic.api.LocationResolver;
import java.lang.reflect.Type;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class LocationResolverSerializer
implements TypeSerializer<LocationResolver> {
    public static final LocationResolverSerializer instance = new LocationResolverSerializer();

    private LocationResolverSerializer() {
    }

    public LocationResolver deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        ConfigurationNode worldNode = node.node(new Object[]{"world"});
        ConfigurationNode xNode = node.node(new Object[]{"x"});
        ConfigurationNode yNode = node.node(new Object[]{"y"});
        ConfigurationNode zNode = node.node(new Object[]{"z"});
        ConfigurationNode yawNode = node.node(new Object[]{"yaw"});
        ConfigurationNode pitchNode = node.node(new Object[]{"pitch"});
        if (worldNode.virtual()) {
            throw new SerializationException(node, LocationResolver.class, "world node missing");
        }
        if (xNode.virtual()) {
            throw new SerializationException(node, LocationResolver.class, "x node missing");
        }
        if (yNode.virtual()) {
            throw new SerializationException(node, LocationResolver.class, "y node missing");
        }
        if (zNode.virtual()) {
            throw new SerializationException(node, LocationResolver.class, "z node missing");
        }
        NamespacedKey world = (NamespacedKey)worldNode.require(NamespacedKey.class);
        double x = xNode.getDouble();
        double y = yNode.getDouble();
        double z = zNode.getDouble();
        float yaw = yawNode.virtual() ? 0.0f : yawNode.getFloat();
        float pitch = pitchNode.virtual() ? 0.0f : pitchNode.getFloat();
        return LocationResolver.resolver(world, x, y, z, yaw, pitch);
    }

    public void serialize(@NotNull Type type, @Nullable LocationResolver obj, @NotNull ConfigurationNode node) throws SerializationException {
        float pitch;
        float yaw;
        double z;
        double y;
        double x;
        NamespacedKey world;
        if (obj == null) {
            return;
        }
        if (obj instanceof LocationResolver.RuntimeResolver) {
            LocationResolver.RuntimeResolver run = (LocationResolver.RuntimeResolver)obj;
            world = run.world;
            x = run.x;
            y = run.y;
            z = run.z;
            yaw = run.yaw;
            pitch = run.pitch;
        } else if (obj instanceof LocationResolver.AlreadyResolver) {
            LocationResolver.AlreadyResolver al = (LocationResolver.AlreadyResolver)obj;
            world = al.location.getWorld().getKey();
            x = al.location.getX();
            y = al.location.getY();
            z = al.location.getZ();
            yaw = al.location.getYaw();
            pitch = al.location.getPitch();
        } else {
            throw new RuntimeException();
        }
        node.node(new Object[]{"world"}).set((Object)world);
        node.node(new Object[]{"x"}).set((Object)x);
        node.node(new Object[]{"y"}).set((Object)y);
        node.node(new Object[]{"z"}).set((Object)z);
        node.node(new Object[]{"yaw"}).set((Object)Float.valueOf(yaw));
        node.node(new Object[]{"pitch"}).set((Object)Float.valueOf(pitch));
    }
}

