/*
 * Decompiled with CFR 0.152.
 */
package io.hotwop.worldmagic.version;

import io.hotwop.worldmagic.version.MethodMapping;
import io.hotwop.worldmagic.version.ResultMapping;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

public final class MethodVersionWrapper<R> {
    private final Class<?> owner;
    private final Class<?>[] defaultParameters;
    private final String defaultName;
    private final Object defaultExecutor;
    private final Int2ObjectSortedMap<String> nameMap;
    private final Int2ObjectSortedMap<ResultMapping<R, ?>> resultMap;
    private final Int2ObjectSortedMap<Function<Object[], Object[]>> allParametersMap;
    private final Int2ObjectSortedMap<Int2ObjectSortedMap<Function<Object, Object>>> oneParameterMap;
    private final Int2ObjectSortedMap<Class<?>[]> parameters;
    private final Int2ObjectSortedMap<Object> executorSwitch;

    private MethodVersionWrapper(Class<?> owner, Class<?>[] defaultParameters, String defaultName, Object defaultExecutor, Int2ObjectSortedMap<String> nameMap, Int2ObjectSortedMap<ResultMapping<R, ?>> resultMap, Int2ObjectSortedMap<Function<Object[], Object[]>> allParametersMap, Int2ObjectSortedMap<Int2ObjectSortedMap<Function<Object, Object>>> oneParameterMap, Int2ObjectSortedMap<Class<?>[]> parameters, Int2ObjectSortedMap<Object> executorSwitch) {
        this.owner = owner;
        this.defaultParameters = defaultParameters;
        this.defaultName = defaultName;
        this.defaultExecutor = defaultExecutor;
        this.nameMap = nameMap;
        this.resultMap = resultMap;
        this.allParametersMap = allParametersMap;
        this.oneParameterMap = oneParameterMap;
        this.parameters = parameters;
        this.executorSwitch = executorSwitch;
    }

    public MethodMapping<R> createMapping(int version) {
        Constructor<?> constructor;
        Method method;
        final String name = MethodVersionWrapper.findUnderOrElse(this.nameMap, version + 1, this.defaultName);
        final ResultMapping result = MethodVersionWrapper.findUnderOrElse(this.resultMap, version + 1, null);
        Class<?>[] parametersVer = MethodVersionWrapper.findUnderOrElse(this.parameters, version + 1, this.defaultParameters);
        try {
            if (name.equals("<init>")) {
                method = null;
                constructor = this.owner.getConstructor(parametersVer);
            } else {
                constructor = null;
                method = this.owner.getMethod(name, parametersVer);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        final Function allTransformer = MethodVersionWrapper.findUnderOrElse(this.allParametersMap, version + 1, null);
        final Int2ObjectSortedMap<Function<Object, Object>> oneConverters = this.findConverters(version + 1);
        final Object executor = MethodVersionWrapper.findUnderOrElse(this.executorSwitch, version + 1, this.defaultExecutor);
        return new MethodMapping<R>(this){

            @Override
            public R invoke(Object ... params) {
                return this.invokeWithExecutor(executor, params);
            }

            @Override
            public R invokeWithExecutor(Object executor2, Object ... params) {
                Object val;
                Object[] modify = allTransformer == null ? Arrays.copyOf(params, params.length) : (Object[])allTransformer.apply(Arrays.copyOf(params, params.length));
                for (int i = 0; i < modify.length; ++i) {
                    if (!oneConverters.containsKey(i)) continue;
                    modify[i] = ((Function)oneConverters.get(i)).apply(modify[i]);
                }
                try {
                    val = name.equals("<init>") ? constructor.newInstance(modify) : method.invoke(executor2, modify);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                return result == null ? val : result.convert(val);
            }
        };
    }

    private static <T> T findUnderOrElse(Int2ObjectSortedMap<T> map, int index, T def) {
        Map.Entry entry = map.headMap(index).lastEntry();
        if (entry == null) {
            return def;
        }
        return (T)entry.getValue();
    }

    private Int2ObjectSortedMap<Function<Object, Object>> findConverters(int version) {
        Int2ObjectRBTreeMap out = new Int2ObjectRBTreeMap();
        this.oneParameterMap.headMap(version).reversed().forEach((arg_0, arg_1) -> MethodVersionWrapper.lambda$findConverters$1((Int2ObjectSortedMap)out, arg_0, arg_1));
        return out;
    }

    private static Class<?>[] addTo(Class<?>[] input, int index, Class<?> obj) {
        Class<?>[] out = Arrays.copyOf(input, Math.max(index + 1, input.length));
        out[index] = obj;
        return out;
    }

    private static <T> Int2ObjectSortedMap<Int2ObjectSortedMap<T>> freezeAll(Int2ObjectSortedMap<Int2ObjectSortedMap<T>> map) {
        Int2ObjectRBTreeMap out = new Int2ObjectRBTreeMap();
        map.forEach((arg_0, arg_1) -> MethodVersionWrapper.lambda$freezeAll$2((Int2ObjectSortedMap)out, arg_0, arg_1));
        return out;
    }

    private static /* synthetic */ void lambda$freezeAll$2(Int2ObjectSortedMap out, Integer id, Int2ObjectSortedMap val) {
        out.put(id.intValue(), (Object)Int2ObjectSortedMaps.unmodifiable((Int2ObjectSortedMap)val));
    }

    private static /* synthetic */ void lambda$findConverters$1(Int2ObjectSortedMap out, Integer vers, Int2ObjectSortedMap converters) {
        converters.forEach((index, conv) -> {
            if (!out.containsKey(index.intValue())) {
                out.put(index.intValue(), conv);
            }
        });
    }

    public static final class Builder<R> {
        private final Class<?> owner;
        private final Class<?>[] defaultParameters;
        private final String defaultName;
        private final Object defaultExecutor;
        private final Int2ObjectSortedMap<String> nameMap = new Int2ObjectRBTreeMap();
        private final Int2ObjectSortedMap<ResultMapping<R, ?>> resultMap = new Int2ObjectRBTreeMap();
        private final Int2ObjectSortedMap<Function<Object[], Object[]>> allParametersMap = new Int2ObjectRBTreeMap();
        private final Int2ObjectSortedMap<Int2ObjectSortedMap<Function<Object, Object>>> oneParameterMap = new Int2ObjectRBTreeMap();
        private final Int2ObjectSortedMap<Class<?>[]> parameters = new Int2ObjectRBTreeMap();
        private final Int2ObjectSortedMap<Object> executorSwitch = new Int2ObjectRBTreeMap();

        public Builder(Class<?> owner, String defaultName, Object defaultExecutor, Class<?> ... defaultParameters) {
            this.owner = owner;
            this.defaultParameters = defaultParameters;
            this.defaultName = defaultName;
            this.defaultExecutor = defaultExecutor;
        }

        public Builder<R> nameMapping(int version, String name) {
            this.nameMap.put(version, (Object)name);
            return this;
        }

        public <T> Builder<R> resultMapping(int version, Class<T> versionResult, Function<T, R> conversion) {
            this.resultMap.put(version, new ResultMapping<R, T>(versionResult, conversion));
            return this;
        }

        public Builder<R> oneParameterMapping(int version, int order, Class<?> parameterClass, Function<Object, Object> conversion) {
            this.parameters.compute(version, (vers, params) -> MethodVersionWrapper.addTo(params == null ? this.findUnderOrDefaultParameters(version) : params, order, parameterClass));
            ((Int2ObjectSortedMap)this.oneParameterMap.computeIfAbsent(version, v -> new Int2ObjectRBTreeMap())).put(order, conversion);
            return this;
        }

        public Builder<R> allParameterMapping(int version, Function<Object[], Object[]> conversion, Class<?> ... parameterClasses) {
            this.parameters.put(version, parameterClasses);
            this.allParametersMap.put(version, conversion);
            return this;
        }

        public Builder<R> executorSwitch(int version, Object executor) {
            this.executorSwitch.put(version, executor);
            return this;
        }

        public MethodVersionWrapper<R> build() {
            return new MethodVersionWrapper(this.owner, this.defaultParameters, this.defaultName, this.defaultExecutor, (Int2ObjectSortedMap<String>)Int2ObjectSortedMaps.unmodifiable(this.nameMap), Int2ObjectSortedMaps.unmodifiable(this.resultMap), (Int2ObjectSortedMap<Function<Object[], Object[]>>)Int2ObjectSortedMaps.unmodifiable(this.allParametersMap), (Int2ObjectSortedMap<Int2ObjectSortedMap<Function<Object, Object>>>)Int2ObjectSortedMaps.unmodifiable(MethodVersionWrapper.freezeAll(this.oneParameterMap)), (Int2ObjectSortedMap<Class<?>[]>)Int2ObjectSortedMaps.unmodifiable(this.parameters), (Int2ObjectSortedMap<Object>)Int2ObjectSortedMaps.unmodifiable(this.executorSwitch));
        }

        private Class<?>[] findUnderOrDefaultParameters(int version) {
            Map.Entry entry = this.parameters.headMap(version).lastEntry();
            if (entry != null) {
                return (Class[])entry.getValue();
            }
            return this.defaultParameters;
        }
    }
}

