/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.model.BackpackModelData;
import com.tiviacz.travelersbackpack.client.renderer.BackpackRenderInfo;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.Locale;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class BackpackBlockModel {
    public static final BackpackBlockModel BLOCK_MODEL = new BackpackBlockModel(BackpackModelData.createTravelersBackpack(false).bakeRoot());
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;
    public ModelPart leftHorn;
    public ModelPart rightHorn;

    public BackpackBlockModel(ModelPart rootPart) {
        this.mainBody = rootPart.getChild("main_body");
        this.tankLeftTop = rootPart.getChild("tankLeftTop");
        this.tankRightTop = rootPart.getChild("tankRightTop");
        this.sleepingBag = rootPart.getChild("sleepingBag");
        this.sleepingBagExtras = rootPart.getChild("sleepingBagExtras");
        this.villagerNose = rootPart.getChild("villagerNose");
        this.ocelotNose = rootPart.getChild("ocelotNose");
        this.pigNose = rootPart.getChild("pigNose");
        this.foxNose = rootPart.getChild("foxNose");
        this.wolfNose = rootPart.getChild("wolfNose");
        this.leftHorn = rootPart.getChild("leftHorn");
        this.rightHorn = rootPart.getChild("rightHorn");
    }

    public void render(BackpackBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BackpackWrapper wrapper = blockEntity.getWrapper();
        Item item = wrapper.getBackpackStack().getItem();
        if (!(item instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem item2 = (TravelersBackpackItem)item;
        ResourceLocation loc = item2.getBackpackTexture();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
        boolean mainBodyRendered = false;
        if (item2 == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && wrapper.getBackpackStack().has(DataComponents.DYED_COLOR)) {
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ARGB.opaque((int)((DyedItemColor)wrapper.getBackpackStack().get(DataComponents.DYED_COLOR)).rgb()));
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            mainBodyRendered = true;
        }
        if (wrapper.tanksVisible()) {
            this.tankLeftTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (!blockEntity.isSleepingBagDeployed()) {
            this.sleepingBagExtras.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(wrapper.getSleepingBagColor());
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            this.sleepingBag.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item2.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
        }
        if (item2 == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            this.foxNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
            this.ocelotNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
            this.wolfNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item2 == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
            this.villagerNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.PIG_TRAVELERS_BACKPACK.get() || item2 == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
            this.pigNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        if (item2 == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
            this.leftHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.rightHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
        }
        if (item2 == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item2 == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
            vertexConsumer = buffer.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)item2.getBackpackTexture()));
        }
        if (!mainBodyRendered) {
            this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanks -> {
            RenderHelper.renderFluidInTank(tanks.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
            RenderHelper.renderFluidInTank(tanks.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
        });
    }

    public void renderByItem(ItemStack backpack, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean renderDefault;
        TravelersBackpackItem item = (TravelersBackpackItem)backpack.getItem();
        ResourceLocation loc = item.getBackpackTexture();
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
        boolean bl = renderDefault = !backpack.has(ModDataComponents.RENDER_INFO);
        if (renderDefault) {
            this.tankLeftTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = BackpackBlockModel.getSleepingBagTexture(DyeColor.RED.getId());
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            this.sleepingBag.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK.get() || item == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
                this.leftHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)item.getBackpackTexture()));
            }
            this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        } else {
            BackpackRenderInfo renderInfo = new BackpackRenderInfo(backpack, (RenderInfo)backpack.get(ModDataComponents.RENDER_INFO));
            boolean backpackRendered = false;
            if (!renderInfo.isEmpty()) {
                this.tankLeftTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.tankRightTop.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                if (!renderInfo.getLeftTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
                }
                if (!renderInfo.getRightTank().isEmpty()) {
                    RenderHelper.renderFluidInTank(renderInfo.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
                }
            }
            if (renderInfo.hasSleepingBag()) {
                loc = item.getBackpackTexture();
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
                this.sleepingBagExtras.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = BackpackBlockModel.getSleepingBagTexture(renderInfo.getSleepingBagColor());
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
                this.sleepingBag.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (renderInfo.isDyed()) {
                loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed.png");
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
                this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ARGB.opaque((int)((DyedItemColor)renderInfo.getBackpack().get(DataComponents.DYED_COLOR)).rgb()));
                loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
                this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                backpackRendered = true;
            }
            loc = item.getBackpackTexture();
            vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            if (item == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK.get() || item == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (item == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
                this.leftHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                this.rightHorn.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
            }
            if (item == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || item == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)item.getBackpackTexture()));
            }
            if (!backpackRendered) {
                this.mainBody.render(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static ResourceLocation getSleepingBagTexture(int color) {
        return ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("textures/model/bags/" + DyeColor.byId((int)color).getName().toLowerCase(Locale.ENGLISH) + "_sleeping_bag.png"));
    }
}

