/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidModelPart
extends ModelPart {
    private final FluidTank leftTank = new FluidTank(3000);
    private final FluidTank rightTank = new FluidTank(3000);
    private MultiBufferSource buffer;
    private boolean render;

    public FluidModelPart(ModelPart parent) {
        super(parent.cubes, parent.children);
    }

    public void prepare(ItemStack stack, MultiBufferSource buffer) {
        this.buffer = buffer;
        RenderInfo info = (RenderInfo)stack.getOrDefault(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY);
        if (info.isEmpty()) {
            this.render = false;
            if (!this.leftTank.isEmpty()) {
                this.leftTank.setFluid(CommonFluid.empty());
            }
            if (!this.rightTank.isEmpty()) {
                this.rightTank.setFluid(CommonFluid.empty());
            }
            return;
        }
        this.render = true;
        this.leftTank.setCapacity(info.getCapacity());
        this.leftTank.setFluid(info.getLeftFluidStack());
        this.rightTank.setCapacity(info.getCapacity());
        this.rightTank.setFluid(info.getRightFluidStack());
    }

    public void render(PoseStack poseStack, VertexConsumer pBuffer, int light, int overlay) {
        if (this.buffer == null || !this.render) {
            return;
        }
        poseStack.pushPose();
        this.translateAndRotate(poseStack);
        this.render(poseStack, this.buffer, light);
        poseStack.popPose();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int light) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.05f, 1.0f);
        RenderHelper.renderFluidInTank(this.leftTank, poseStack, buffer, light, -0.66f, -0.55f, -0.235f);
        RenderHelper.renderFluidInTank(this.rightTank, poseStack, buffer, light, 0.24f, -0.55f, -0.235f);
        poseStack.popPose();
    }
}

