/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class StackModelPart
extends ModelPart {
    private List<ItemStack> tools = new ArrayList<ItemStack>();
    private MultiBufferSource buffer;

    public StackModelPart(ModelPart parent) {
        super(parent.cubes, parent.children);
    }

    public void prepare(ItemStack stack, MultiBufferSource buffer) {
        if (stack.has(ModDataComponents.TOOLS_CONTAINER)) {
            this.tools = new ArrayList<ItemStack>(((BackpackContainerContents)stack.get(ModDataComponents.TOOLS_CONTAINER)).getItems().stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        } else if (!this.tools.isEmpty()) {
            this.tools.clear();
        }
        this.buffer = buffer;
    }

    public void render(PoseStack poseStack, VertexConsumer vertices, int light, int overlay) {
        if (this.buffer == null) {
            return;
        }
        poseStack.pushPose();
        this.translateAndRotate(poseStack);
        this.render(poseStack, this.buffer, light, overlay);
        poseStack.popPose();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        if (this.tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = this.tools.get(0);
        ItemStack toolLower = ItemStack.EMPTY;
        if (!toolUpper.isEmpty() && this.tools.size() > 1) {
            toolLower = this.tools.get(this.tools.size() - 1);
        }
        if (!toolUpper.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.05, 0.075, 0.27);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            poseStack.scale(0.65f, 0.65f, 0.65f);
            Minecraft.getInstance().getItemRenderer().renderStatic(toolUpper, ItemDisplayContext.NONE, pPackedLight, pPackedOverlay, poseStack, buffer, null, 0);
            poseStack.popPose();
        }
        if (!toolLower.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.325, 0.95, 0.0);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.scale(0.65f, 0.65f, 0.65f);
            Minecraft.getInstance().getItemRenderer().renderStatic(toolLower, ItemDisplayContext.NONE, pPackedLight, pPackedOverlay, poseStack, buffer, null, 0);
            poseStack.popPose();
        }
    }
}

