/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class BackpackBlockEntityRenderer
implements BlockEntityRenderer<BackpackBlockEntity> {
    public BackpackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BackpackBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, Vec3 vec3) {
        this.render(blockEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    public void render(BackpackBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = blockEntity.getBlockDirection();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f * (float)direction.get2DDataValue()));
        poseStack.scale(0.7777778f, 0.7692308f, 0.7777778f);
        poseStack.translate(0.0, 0.016, 0.0);
        BackpackBlockModel.BLOCK_MODEL.render(blockEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }

    public static void renderByItem(ItemStack stack, PoseStack poseStack, MultiBufferSource vertexConsumer, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(0.7777778f, 0.7692308f, 0.7777778f);
        poseStack.translate(0.0, 0.016, 0.0);
        BackpackBlockModel.BLOCK_MODEL.renderByItem(stack, poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }
}

