/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackLayer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    public static final ContextKey<ItemStack> BACKPACK_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"));

    public BackpackLayer(RenderLayerParent<PlayerRenderState, PlayerModel> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, PlayerRenderState state, float limbSwing, float limbSwingAmount) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        ItemStack backpack = (ItemStack)state.getRenderData(BACKPACK_KEY);
        if (backpack != null && backpack.getItem() instanceof TravelersBackpackItem) {
            BackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (HumanoidModel)this.getParentModel(), poseStack, bufferIn, packedLightIn, (HumanoidRenderState)state, backpack);
        }
    }

    public static void renderBackpackLayer(BackpackLayerModel model, HumanoidModel humanoidModel, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, HumanoidRenderState state, ItemStack stack) {
        if (!((Boolean)stack.getOrDefault(ModDataComponents.IS_VISIBLE, (Object)true)).booleanValue()) {
            return;
        }
        model.setBackpackStack(stack);
        model.setMultiBufferSource(bufferIn);
        Item item = stack.getItem();
        if (!(item instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
        boolean translucentType = travelersBackpackItem == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || travelersBackpackItem == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        boolean cutoutType = travelersBackpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK.get();
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        VertexConsumer vertexConsumer = bufferIn.getBuffer(translucentType ? RenderType.entityTranslucent((ResourceLocation)loc) : RenderType.entitySolid((ResourceLocation)loc));
        if (cutoutType) {
            vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        }
        poseStack.pushPose();
        BackpackLayer.alignModel(poseStack, humanoidModel, model, state);
        if (stack.has(DataComponents.DYED_COLOR) && stack.getItem() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)loc));
            model.mainBody.render(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, ARGB.opaque((int)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb()));
            loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        }
        model.renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY);
        loc = BackpackBlockModel.getSleepingBagTexture((Integer)stack.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId()));
        vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
        model.sleepingBag.render(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY);
        if (state instanceof PlayerRenderState) {
            PlayerRenderState playerRenderState = (PlayerRenderState)state;
            if (Supporters.SUPPORTERS.contains(playerRenderState.name)) {
                model.supporterBadgeModel.render(poseStack, packedLightIn);
            }
        }
        poseStack.popPose();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackLayerModel backpackModel, HumanoidRenderState state) {
        if (state.isCrouching) {
            poseStack.translate(0.0, -0.155, 0.025);
        }
        parent.copyPropertiesTo((HumanoidModel)backpackModel);
        backpackModel.setupAngles(parent);
        poseStack.translate(0.0, 0.175, 0.325);
        poseStack.scale(0.85f, 0.85f, 0.85f);
        if (state.isBaby) {
            poseStack.translate(0.0f, 0.45f, -0.22f);
            float scaleFactor = state.ageScale;
            poseStack.scale(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

