/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BackpackRenderInfo {
    public ItemStack backpack;
    public RenderInfo info;
    public FluidTank leftTank;
    public FluidTank rightTank;

    public BackpackRenderInfo(ItemStack backpack, RenderInfo info) {
        this.backpack = backpack;
        this.info = info;
        if (info != null && !info.isEmpty()) {
            this.leftTank = new FluidTank(info.getCapacity());
            this.rightTank = new FluidTank(info.getCapacity());
            this.leftTank.setFluid(info.getLeftFluidStack());
            this.rightTank.setFluid(info.getRightFluidStack());
        }
    }

    public boolean isEmpty() {
        return this.info.isEmpty();
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public boolean renderDefault() {
        return !this.backpack.has(ModDataComponents.STORAGE_SLOTS);
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public Optional<Pair<FluidStack, FluidStack>> getTanksContents() {
        Optional<ItemStack> tanksUpgrade;
        if (this.backpack.has(ModDataComponents.UPGRADES) && (tanksUpgrade = ((BackpackContainerContents)this.backpack.get(ModDataComponents.UPGRADES)).getItems().stream().filter(stack -> stack.getItem() == ModItems.TANKS_UPGRADE.get()).findFirst()).isPresent()) {
            Fluids tanksInfo = (Fluids)tanksUpgrade.get().get(ModDataComponents.FLUIDS);
            return Optional.of(Pair.of((Object)tanksInfo.leftFluidStack(), (Object)tanksInfo.rightFluidStack()));
        }
        return Optional.empty();
    }

    public boolean isDyed() {
        return this.backpack.has(DataComponents.DYED_COLOR) && this.backpack.getItem() == ModItems.STANDARD_TRAVELERS_BACKPACK.get();
    }

    public int getSleepingBagColor() {
        return (Integer)this.backpack.getOrDefault((DataComponentType)ModDataComponents.SLEEPING_BAG_COLOR.get(), (Object)DyeColor.RED.getId());
    }

    public boolean hasSleepingBag() {
        return this.backpack.has(ModDataComponents.SLEEPING_BAG_COLOR);
    }
}

