/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.client.renderer.BackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public record BackpackSpecialRenderer(ItemStack stack) implements SpecialModelRenderer<ItemStack>
{
    public void render(@Nullable ItemStack patterns, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        BackpackBlockEntityRenderer.renderByItem(patterns, poseStack, bufferSource, packedLight, packedOverlay);
    }

    @Nullable
    public ItemStack extractArgument(ItemStack stack) {
        return stack.getItem() instanceof TravelersBackpackItem ? stack : ModItems.STANDARD_TRAVELERS_BACKPACK.asItem().getDefaultInstance();
    }

    public record Unbaked(Item defaultStack) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("default").forGetter(unbaked -> unbaked.defaultStack.getDefaultInstance())).apply((Applicative)instance, itemStack -> new Unbaked(itemStack.getItem())));

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new BackpackSpecialRenderer(this.defaultStack.getDefaultInstance());
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

