/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractBackpackScreen<T extends AbstractBackpackMenu>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation BACKGROUND_11 = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/background_11.png");
    public static final ResourceLocation BACKGROUND_9 = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/background_9.png");
    public static final ResourceLocation SLOTS = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/slots.png");
    public static final ResourceLocation TANKS = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/tanks.png");
    public static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/icons.png");
    public static final ResourceLocation TABS = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 17;
    protected int slotCount;
    protected boolean wider = false;
    protected final BackpackWrapper wrapper;
    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0;
    public static final int HEIGHT_WITHOUT_STORAGE = 114;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    protected AbstractBackpackScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.wrapper = ((AbstractBackpackMenu)((Object)pMenu)).getWrapper();
        this.titleLabelY = 6;
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public Player getScreenPlayer() {
        return ((AbstractBackpackMenu)this.getMenu()).player;
    }

    public Font getScreenFont() {
        return this.font;
    }

    public void updateDimensions() {
        int guiScaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        if (guiScaledHeight < this.imageHeight) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - 114) / 18, this.getRows());
            int newImageHeight = 114 + this.calculateSlotHeight(displayableNumberOfRows);
            this.slotsHeight = this.calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.imageHeight = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void updateBackpackSlotsPosition() {
        int allStorageSlots = ((AbstractBackpackMenu)this.menu).BACKPACK_INV_END;
        if (this.isScrollable) {
            int i;
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * this.getSlotsInRow();
            int movedSlots = this.visibleRows * this.getSlotsInRow() - hiddenSlotsFirst;
            int revealedSlots = scrollAmount * this.getSlotsInRow();
            int lastRowSlots = this.slotCount % this.getSlotsInRow();
            if (scrollAmount == this.getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= this.getSlotsInRow();
                revealedSlots += lastRowSlots;
            }
            for (int i2 = 0; i2 < hiddenSlotsFirst; ++i2) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i2)).y = -1000;
            }
            int countSlots = 0;
            for (int i3 = hiddenSlotsFirst; i3 < hiddenSlotsFirst + movedSlots; ++i3) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i3)).y = this.slotYPos + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            countSlots = 0;
            int lastY = this.slotYPos + (this.visibleRows - scrollAmount) * 18;
            for (i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; ++i) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i)).y = lastY + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            for (i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; ++i) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i)).y = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if (this.isScrollable) {
            int i;
            int firstPlayerSlotY = 32 + this.visibleRows * 18;
            int countSlots = 0;
            for (i = ((AbstractBackpackMenu)this.menu).PLAYER_INV_START; i < ((AbstractBackpackMenu)this.menu).PLAYER_HOT_END - 9; ++i) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i)).y = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9.0) * 18;
                ++countSlots;
            }
            for (i = ((AbstractBackpackMenu)this.menu).PLAYER_HOT_END - 9; i < ((AbstractBackpackMenu)this.menu).PLAYER_HOT_END; ++i) {
                ((Slot)((AbstractBackpackMenu)this.menu).slots.get((int)i)).y = firstPlayerSlotY + 54 + 4;
            }
        }
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / (double)this.getSlotsInRow());
    }

    public void renderInventoryBackground(GuiGraphics guiGraphics, int x, int y, ResourceLocation texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.blit(RenderType::guiTextured, texture, x, y, 0.0f, 0.0f, xSize, 17 + halfSlotHeight, 256, 256);
        int playerInventoryHeight = 98;
        guiGraphics.blit(RenderType::guiTextured, texture, x, y + 17 + halfSlotHeight, 0.0f, (float)(256 - (playerInventoryHeight + halfSlotHeight)), xSize, playerInventoryHeight + halfSlotHeight, 256, 256);
    }

    public void renderSlots(GuiGraphics guiGraphics, int x, int y, int slotCount) {
        int fullRows;
        int lastSlotRow = this.slotCount % this.getSlotsInRow();
        int visibleRows = this.visibleRows;
        int n = fullRows = this.isScrollable ? visibleRows : slotCount / this.getSlotsInRow();
        if (this.isScrollable && this.scrollAmount == this.getMaxScrollAmount() && lastSlotRow > 0) {
            --fullRows;
        }
        guiGraphics.blit(RenderType::guiTextured, SLOTS, x, y, 0.0f, 0.0f, this.getSlotsInRow() * 18, fullRows * 18, 256, 256);
        if (fullRows > 9) {
            guiGraphics.blit(RenderType::guiTextured, SLOTS, x, y + 162, 0.0f, 0.0f, this.getSlotsInRow() * 18, (fullRows - 9) * 18, 256, 256);
        }
        if (lastSlotRow > 0) {
            if (this.isScrollable) {
                if (this.scrollAmount == this.getMaxScrollAmount()) {
                    guiGraphics.blit(RenderType::guiTextured, SLOTS, x, y + fullRows * 18, 0.0f, (float)(fullRows * 18), lastSlotRow * 18, 18, 256, 256);
                }
            } else {
                guiGraphics.blit(RenderType::guiTextured, SLOTS, x, y + fullRows * 18, 0.0f, 0.0f, lastSlotRow * 18, 18, 256, 256);
            }
        }
    }

    public void renderLockedBackpackSlot(GuiGraphics guiGraphics) {
        Slot slot;
        if (((AbstractBackpackMenu)this.menu).disabledSlotIndex > 0 && ((AbstractBackpackMenu)this.menu).disabledSlotIndex < ((AbstractBackpackMenu)this.menu).slots.size() && (slot = ((AbstractBackpackMenu)this.menu).getSlot(((AbstractBackpackMenu)this.menu).disabledSlotIndex)) instanceof DisabledSlot) {
            DisabledSlot slot2 = (DisabledSlot)slot;
            int x = this.leftPos + slot2.x;
            int y = this.topPos + slot2.y;
            guiGraphics.fill(RenderType.guiOverlay(), x, y, x + 16, y + 16, 0, -9934744);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public abstract void renderScreen(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    public abstract void drawUnsortableSlots(GuiGraphics var1);

    public abstract void drawMemorySlots(GuiGraphics var1);

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scroll != null) {
            return this.scroll.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiEventListener focused = this.getFocused();
        if (focused != null && !focused.isMouseOver(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void sendDataToServer() {
    }

    public void playUIClickSound() {
        ((AbstractBackpackMenu)this.menu).getPlayerInventory().player.level().playSound((Entity)((AbstractBackpackMenu)this.menu).getPlayerInventory().player, ((AbstractBackpackMenu)this.menu).getPlayerInventory().player.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.MASTER, 0.25f, 1.0f);
    }
}

