/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SupporterBadgeWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackSettingsScreen
extends AbstractBackpackScreen<BackpackSettingsMenu>
implements MenuAccess<BackpackSettingsMenu> {
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, Inventory inventory, Component component) {
        super(backpackSettingsMenu, inventory, backpackSettingsMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.lastMemorySlots);
        this.visibility = (Boolean)this.wrapper.getBackpackStack().getOrDefault(ModDataComponents.IS_VISIBLE, (Object)true);
        this.titleLabelX = 8;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void init() {
        super.init();
        this.initWidgets();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.isScrollable = false;
        this.recalculate();
        this.init();
        ((BackpackSettingsMenu)this.getMenu()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        int i = slot.x;
        int j = slot.y;
        int j1 = slot.x + slot.y * this.imageWidth;
        if (slot.isFake()) {
            guiGraphics.renderFakeItem(itemstack, i, j, j1);
        } else {
            guiGraphics.renderItem(itemstack, i, j, j1);
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.clearWidgets();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.leftPos = 0;
        this.topPos = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.imageWidth = wideTexture ? 212 : 176;
        this.imageHeight = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.inventoryLabelY = 20 + this.visibleRows * 18;
        this.inventoryLabelX = 8;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        if (wideTexture) {
            this.inventoryLabelX += 18;
        }
        if (((BackpackSettingsMenu)this.menu).getSlot((int)0).y >= 0) {
            this.slotYPos = ((BackpackSettingsMenu)this.menu).getSlot((int)0).y;
        }
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.imageWidth, this.slotsHeight);
        int slotsXOffset = 7;
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void initWidgets() {
        if (this.isScrollable) {
            int scrollXPos = this.leftPos + 7;
            this.scroll = new InventoryScroll(this, Minecraft.getInstance(), 4, this.visibleRows * 18, this.topPos + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.addRenderableWidget((GuiEventListener)this.scroll);
        }
        this.settingsWidget = new SettingsWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4), true);
        this.addRenderableWidget(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4 + 24 + 1));
        this.addRenderableWidget(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4 + 24 + 1 + 24 + 1), false);
        this.addRenderableWidget(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.addRenderableWidget(this.visibilityWidget);
            if (this.getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().getGameProfile().getName())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.leftPos + this.imageWidth - 3, this.topPos + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1));
                this.addRenderableWidget(this.supporterBadgeWidget);
            }
        }
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.children().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<GuiEventListener> widgets = this.children().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.children().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    @Override
    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)i.intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)i.intValue()).y, 25.0f, 55.0f, 16, 16, 256, 256));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)i.intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)i.intValue()).y, 25.0f, 55.0f, 16, 16, 256, 256));
        }
    }

    @Override
    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y, 25.0f, 73.0f, 16, 16, 256, 256);
                    } else {
                        guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y, 25.0f, 91.0f, 16, 16, 256, 256);
                    }
                    if (((BackpackSettingsMenu)this.getMenu()).getSlot((Integer)pair.getFirst()).getItem().isEmpty()) {
                        ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.renderFakeItem(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y);
                        guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.getMenu()).getSlot((Integer)pair.getFirst()).getItem().isEmpty()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.renderFakeItem(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y);
                    guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y, this.getGuiLeft() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).x + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.getMenu()).getSlot((int)((Integer)pair.getFirst()).intValue()).y + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.slotClicked(slot, slotId, button, type);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.getSlotUnderMouse();
        if (this.selectSlots(slot, button)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean selectSlots(Slot slot, int button) {
        if (slot != null && slot.index >= 0 && slot.index < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.index)) {
                    this.unsortableSlots.add(slot.index);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.index)) {
                    this.unsortableSlots.remove((Object)slot.index);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.index, this.memorySlots)) {
                    if (slot.getItem().isEmpty()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)slot.index, (Object)Pair.of((Object)(this.memoryWidget.matchComponents ? slot.getItem() : slot.getItem().getItem().getDefaultInstance()), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.index, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.index);
                    return true;
                }
            }
        }
        return false;
    }

    public void onClose() {
        this.sendDataToServer();
        super.onClose();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().player;
            if (playerEntity != null) {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

