/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.accessories;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TravelersBackpackAccessory
implements Accessory {
    public static void init() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> AccessoriesAPI.registerAccessory((Item)((Item)holder.get()), (Accessory)new TravelersBackpackAccessory()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> AccessoriesRendererRegistry.registerRenderer((Item)((Item)holder.get()), Renderer::new));
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get();
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return false;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BackpackWrapper.tick(stack, player, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements SimpleAccessoryRenderer {
        public <S extends LivingEntityRenderState> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<S> entityModel, S renderState, MultiBufferSource multiBufferSource, int light, float partialTicks) {
            if (stack.getItem() instanceof TravelersBackpackItem && entityModel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)entityModel;
                if (renderState instanceof HumanoidRenderState) {
                    HumanoidRenderState humanoidRenderState = (HumanoidRenderState)renderState;
                    BackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (HumanoidModel)playerModel, matrices, multiBufferSource, light, humanoidRenderState, stack);
                }
            }
        }

        public <S extends LivingEntityRenderState> void align(ItemStack stack, SlotReference reference, EntityModel<S> model, S renderState, PoseStack matrices) {
        }
    }
}

