/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class BackpackContainerContents {
    public static final BackpackContainerContents EMPTY = new BackpackContainerContents((NonNullList<ItemStack>)NonNullList.withSize((int)27, (Object)ItemStack.EMPTY));
    public static final Codec<BackpackContainerContents> CODEC = Slot.CODEC.sizeLimitedListOf(256).xmap(BackpackContainerContents::fromSlots, BackpackContainerContents::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackContainerContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)256)).map(BackpackContainerContents::new, containerContents -> containerContents.items);
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    private BackpackContainerContents(NonNullList<ItemStack> pItems) {
        if (pItems.size() > 256) {
            throw new IllegalArgumentException("Got " + pItems.size() + " items, but maximum is 256");
        }
        this.items = pItems;
        this.hashCode = ItemStack.hashStackList(pItems);
    }

    public BackpackContainerContents(int pSize) {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)pSize, (Object)ItemStack.EMPTY));
    }

    private BackpackContainerContents(List<ItemStack> stacks) {
        this(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.items.set(i, (Object)stacks.get(i));
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    private static BackpackContainerContents fromSlots(List<Slot> slots) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        BackpackContainerContents contents = new BackpackContainerContents(optionalint.getAsInt() + 1);
        for (Slot slot : slots) {
            contents.items.set(slot.index(), (Object)slot.item());
        }
        return contents;
    }

    public static BackpackContainerContents fromItems(int size, List<ItemStack> pItems) {
        BackpackContainerContents ccontents = new BackpackContainerContents(size);
        for (int j = 0; j < size; ++j) {
            ccontents.items.set(j, (Object)pItems.get(j).copy());
        }
        return ccontents;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            list.add(new Slot(i, itemstack));
        }
        return list;
    }

    public BackpackContainerContents updateSlot(Slot slot) {
        ArrayList<ItemStack> itemsCopy = new ArrayList<ItemStack>((Collection<ItemStack>)this.items);
        if (slot.index >= 0 && slot.index < this.items.size()) {
            itemsCopy.set(slot.index, slot.item);
        }
        return new BackpackContainerContents(itemsCopy);
    }

    public CompoundTag toNbt(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            nbtTagList.add((Object)((ItemStack)this.items.get(i)).save(provider, (Tag)itemTag));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        return nbt;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof BackpackContainerContents) {
            BackpackContainerContents contents = (BackpackContainerContents)pOther;
            if (ItemStack.listMatches(this.items, contents.items)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public record Slot(int index, ItemStack item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(Slot::index), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)inst, Slot::new));
    }
}

