/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.renderer.BackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackSpecialRenderer;
import com.tiviacz.travelersbackpack.client.renderer.HoseSpecialRenderer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.PotionFluidType;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterSelectItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialBlockModelRendererEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelBaker;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.fluids.FluidStack;

@EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    public static final String CATEGORY = "key.travelersbackpack.category";
    public static final KeyMapping OPEN_BACKPACK = new KeyMapping("key.travelersbackpack.inventory", 66, "key.travelersbackpack.category");
    public static final KeyMapping SORT_BACKPACK = new KeyMapping("key.travelersbackpack.sort", -1, "key.travelersbackpack.category");
    public static final KeyMapping ABILITY = new KeyMapping("key.travelersbackpack.ability", -1, "key.travelersbackpack.category");
    public static final KeyMapping SWAP_TOOL = new KeyMapping("key.travelersbackpack.cycle_tool", 90, "key.travelersbackpack.category");
    public static final KeyMapping TOGGLE_TANK = new KeyMapping("key.travelersbackpack.toggle_tank", 78, "key.travelersbackpack.category");
    public static final StandaloneModelKey<SimpleModelWrapper> STAR_MODEL = new StandaloneModelKey(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"item/supporter_star"));

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_BACKPACK);
        event.register(SORT_BACKPACK);
        event.register(ABILITY);
        event.register(SWAP_TOOL);
        event.register(TOGGLE_TANK);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModItems.BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerSpecialModelRenderer(RegisterSpecialModelRendererEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"), BackpackSpecialRenderer.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    public static void registerSpecialModelRenderer(RegisterSelectItemModelPropertyEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"hose_modes"), HoseSpecialRenderer.TYPE);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterStandalone event) {
        event.register(STAR_MODEL, StandaloneModelBaker.simpleModelWrapper());
    }

    @SubscribeEvent
    public static void registerSpecialModelRenderer(RegisterSpecialBlockModelRendererEvent event) {
        ModBlocks.BLOCKS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackBlock).forEach(holder -> event.register((Block)holder.get(), (SpecialModelRenderer.Unbaked)new BackpackSpecialRenderer.Unbaked(((Block)holder.get()).asItem())));
    }

    @SubscribeEvent
    public static void registerClientExtenstions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final int EMPTY_COLOR = 0xF800F8;

            public int getTintColor() {
                return -524040;
            }

            public int getTintColor(FluidStack stack) {
                return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
            }

            public ResourceLocation getStillTexture() {
                return PotionFluidType.POTION_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return PotionFluidType.POTION_FLOW_RL;
            }
        }, new Holder[]{ModFluids.POTION_FLUID_TYPE});
    }

    @SubscribeEvent
    public static void registerMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.BACKPACK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), BackpackScreen::new);
        event.register((MenuType)ModMenuTypes.BACKPACK_SETTINGS_MENU.get(), BackpackSettingsScreen::new);
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent evt) {
        evt.registerBelow(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"overlay"), (pGuiGraphics, pPartialTick) -> {
            Minecraft mc = Minecraft.getInstance();
            if (((Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get()).booleanValue() && !mc.options.hideGui && AttachmentUtils.isWearingBackpack((Player)mc.player) && mc.gameMode.getPlayerMode() != GameType.SPECTATOR) {
                HudOverlay.renderOverlay(AttachmentUtils.getWearingBackpack((Player)mc.player), mc, pGuiGraphics);
            }
        });
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltipComponent.class, ClientBackpackTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerRenderStateModifier(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PlayerRenderer.class, (abstractClientPlayer, playerRenderState) -> {
            ItemStack backpack = AttachmentUtils.getWearingBackpack((Player)abstractClientPlayer);
            if (!backpack.isEmpty()) {
                playerRenderState.setRenderData(BackpackLayer.BACKPACK_KEY, (Object)backpack);
            }
        });
        event.registerEntityModifier(ZombieRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(SkeletonRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(EndermanRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(WitherSkeletonRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
        event.registerEntityModifier(PiglinRenderer.class, (mob, mobRenderState) -> {
            ItemStack chest = mob.getItemBySlot(EquipmentSlot.CHEST);
            if (chest.getItem() instanceof TravelersBackpackItem) {
                mobRenderState.chestEquipment = chest;
            }
        });
    }

    public static ModelLayerLocation createBackpackModelName(String name, boolean isWearable) {
        ResourceLocation location = ResourceLocation.tryParse((String)name);
        return new ModelLayerLocation(location.withPrefix("backpack/"), isWearable ? "main" : "block");
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.WIDE);
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.SLIM);
        for (EntityType type : evt.getEntityTypes()) {
            HumanoidMobRenderer renderer;
            EntityRenderer entityRenderer = evt.getRenderer(type);
            if (!(entityRenderer instanceof HumanoidMobRenderer) || !((renderer = (HumanoidMobRenderer)entityRenderer).getModel() instanceof HumanoidModel) || TravelersBackpack.endermanOverhaulLoaded && type == EntityType.ENDERMAN) continue;
            renderer.addLayer((RenderLayer)new BackpackEntityLayer((RenderLayerParent<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>)renderer));
        }
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, PlayerSkin.Model model) {
        EntityRenderer renderer = evt.getSkin(model);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer((RenderLayer)new BackpackLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)livingRenderer));
        }
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.BACKPACK.get()), BackpackBlockEntityRenderer::new);
    }
}

