/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.commands.AccessCommand;
import com.tiviacz.travelersbackpack.commands.ClearCommand;
import com.tiviacz.travelersbackpack.commands.RestoreCommand;
import com.tiviacz.travelersbackpack.commands.UnpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import com.tiviacz.travelersbackpack.network.SupporterBadgePacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.command.ConfigCommand;

@EventBusSubscriber(modid="travelersbackpack", bus=EventBusSubscriber.Bus.GAME)
public class NeoForgeEventHandler {
    public static final List<Supplier<Item>> UPGRADES = Arrays.asList(() -> (Item)ModItems.IRON_TIER_UPGRADE.get(), () -> (Item)ModItems.GOLD_TIER_UPGRADE.get(), () -> (Item)ModItems.DIAMOND_TIER_UPGRADE.get(), () -> (Item)ModItems.NETHERITE_TIER_UPGRADE.get());
    private static boolean checkAbilitiesForRemoval = true;
    private static int nextSupportersFetch = 0;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().level();
        if (event.getNewSpawn() != null) {
            Block block = level.getBlockState(event.getNewSpawn()).getBlock();
            if (!level.isClientSide && block instanceof SleepingBagBlock && !event.isForced()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerWakeUp(PlayerWakeUpEvent event) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.quickSleepingBag.get()).booleanValue()) {
            return;
        }
        BlockPos pos = event.getEntity().blockPosition();
        Level level = event.getEntity().level();
        if (level.getBlockState(pos).getBlock() instanceof SleepingBagBlock) {
            BlockState headPart = level.getBlockState(pos);
            if (headPart.hasProperty((Property)SleepingBagBlock.CAN_DROP) && ((Boolean)headPart.getValue((Property)SleepingBagBlock.CAN_DROP)).booleanValue()) {
                return;
            }
            BlockPos backpackPos = pos.relative(((Direction)headPart.getValue((Property)SleepingBagBlock.FACING)).getOpposite(), 2);
            if (!(level.getBlockState(backpackPos).getBlock() instanceof TravelersBackpackBlock) && !level.isClientSide) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity backpack;
        BlockEntity list;
        BlockEntity standardBackpack;
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity oldSleepingBag;
        BackpackBlockEntity blockEntity;
        BlockEntity context;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickUnequip.get()).booleanValue() && !TravelersBackpack.enableIntegration() && AttachmentUtils.isWearingBackpack(player) && !level.isClientSide && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().isEmpty()) {
            TravelersBackpackItem item;
            Item item2;
            ItemStack backpackStack = AttachmentUtils.getWearingBackpack(player).copy();
            context = new UseOnContext(level, player, hand, backpackStack, event.getHitVec());
            boolean quickPickupFlag = level.getBlockState(pos).getBlock() instanceof TravelersBackpackBlock;
            if (!quickPickupFlag && (item2 = backpackStack.getItem()) instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)item2).place(new BlockPlaceContext((UseOnContext)context)) == InteractionResult.SUCCESS_SERVER) {
                player.swing(hand, true);
                level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.05f, (1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f) * 0.7f);
                AttachmentUtils.getAttachment(player).ifPresent(data -> {
                    data.remove();
                    data.synchronise();
                });
                event.setCanceled(true);
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                return;
            }
        }
        if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().is(ModTags.SLEEPING_BAGS) && (context = level.getBlockEntity(pos)) instanceof BackpackBlockEntity) {
            blockEntity = (BackpackBlockEntity)context;
            oldSleepingBag = BackpackBlockEntity.getProperSleepingBag(blockEntity.getWrapper().getSleepingBagColor()).getBlock().asItem().getDefaultInstance();
            blockEntity.getWrapper().setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.getMainHandItem().getItem()));
            if (!level.isClientSide) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.above().getY(), (double)pos.getZ(), (ItemStack)oldSleepingBag);
                player.getMainHandItem().shrink(1);
            }
            level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().is(Items.SHEARS) && (oldSleepingBag = level.getBlockEntity(pos)) instanceof BackpackBlockEntity && !(backpackBlockEntity = (BackpackBlockEntity)oldSleepingBag).getWrapper().getBackpackStack().is(ModItems.STANDARD_TRAVELERS_BACKPACK)) {
            standardBackpack = new ItemStack((ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), 1);
            Component standardName = (Component)standardBackpack.get(DataComponents.ITEM_NAME);
            backpackBlockEntity.toItemStack((ItemStack)standardBackpack);
            standardBackpack.set(DataComponents.ITEM_NAME, (Object)standardName);
            Direction direction = (Direction)level.getBlockState(pos).getValue(TravelersBackpackBlock.FACING);
            if (!level.isClientSide && level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState())) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)standardBackpack);
                backpackBlockEntity.removeSleepingBag(level, direction);
                level.playSound(null, backpackBlockEntity.getBlockPos(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.isShiftKeyDown() && player.getMainHandItem().getItem() == ModItems.BLANK_UPGRADE.get() && (standardBackpack = level.getBlockEntity(pos)) instanceof BackpackBlockEntity) {
            ItemStack stackInSlot;
            int i;
            blockEntity = (BackpackBlockEntity)standardBackpack;
            list = NonNullList.create();
            for (i = 0; i < blockEntity.getWrapper().getStorage().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getStorage().getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                list.add((Object)stackInSlot);
            }
            for (i = 0; i < blockEntity.getWrapper().getTools().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getTools().getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                list.add((Object)stackInSlot);
            }
            for (i = 0; i < blockEntity.getWrapper().getUpgrades().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getUpgrades().getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                list.add((Object)stackInSlot);
            }
            int tier = (Integer)blockEntity.getWrapper().getBackpackStack().getOrDefault(ModDataComponents.TIER, (Object)0);
            if (tier != 0) {
                list.addAll(NeoForgeEventHandler.getUpgrades(tier));
            }
            Item backpackItem = blockEntity.getWrapper().getBackpackStack().getItem();
            list.add((Object)backpackItem.getDefaultInstance());
            if (!level.isClientSide) {
                Containers.dropContents((Level)level, (BlockPos)pos.above(), (NonNullList)list);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            return;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickEquip.get()).booleanValue() && (list = level.getBlockEntity(pos)) instanceof BackpackBlockEntity) {
            backpackBlockEntity = (BackpackBlockEntity)list;
            if (player.isShiftKeyDown() && !AttachmentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
                if (player.getItemInHand(hand).getItem() instanceof BlockItem) {
                    return;
                }
                backpack = new ItemStack((ItemLike)level.getBlockState(pos).getBlock(), 1).copy();
                backpackBlockEntity.toItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.getBlockState(pos).getValue(TravelersBackpackBlock.FACING);
                if (!level.isClientSide && level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState())) {
                    AttachmentUtils.equipBackpack(player, (ItemStack)backpack);
                    backpackBlockEntity.removeSleepingBag(level, direction);
                    event.setCanceled(true);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                    return;
                }
            }
        }
        if ((backpack = level.getBlockEntity(pos)) instanceof BackpackBlockEntity) {
            backpackBlockEntity = (BackpackBlockEntity)backpack;
            if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().isEmpty()) {
                backpack = new ItemStack((ItemLike)level.getBlockState(pos).getBlock(), 1).copy();
                backpackBlockEntity.toItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.getBlockState(pos).getValue(TravelersBackpackBlock.FACING);
                if (!level.isClientSide && level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState())) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)backpack);
                    backpackBlockEntity.removeSleepingBag(level, direction);
                    level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f);
                    event.setCanceled(true);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                }
            }
        }
    }

    public static NonNullList<ItemStack> getUpgrades(int tier) {
        NonNullList list = NonNullList.create();
        for (int i = 0; i < tier; ++i) {
            list.add((Object)UPGRADES.get(i).get().getDefaultInstance());
        }
        return list;
    }

    public static void initializeDefaultSize(ItemStack stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        stack.set(ModDataComponents.TIER, (Object)tier.getOrdinal());
        stack.set(ModDataComponents.STORAGE_SLOTS, (Object)tier.getStorageSlots());
        stack.set(ModDataComponents.UPGRADE_SLOTS, (Object)tier.getUpgradeSlots());
        stack.set(ModDataComponents.TOOL_SLOTS, (Object)tier.getToolSlots());
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.beeAbility(event);
            BackpackAbilities.witherAbility(event);
            BackpackAbilities.wardenAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity(), event.getOrb());
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && BackpackAbilities.ABILITIES.checkBackpack(player = (Player)livingEntity, (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get()) && BackpackAbilities.creeperAbility(event)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && AttachmentUtils.isWearingBackpack(player = (Player)livingEntity)) {
            ServerLevel serverLevel;
            if (TravelersBackpack.enableIntegration()) {
                if (!player.level().isClientSide) {
                    BackpackManager.addBackpack((ServerPlayer)player, AttachmentUtils.getWearingBackpack(player));
                }
                return;
            }
            Level level = player.level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                return;
            }
            ItemStack stack = AttachmentUtils.getWearingBackpack(player);
            if (BackpackDeathHelper.onPlayerDrops(player.level(), player, stack)) {
                if (player.level().isClientSide) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack);
                itemEntity.setDefaultPickUpDelay();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSendMessagePacket(true, player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.blockPosition().getX() + " Y: " + player.getY() + " Z: " + player.blockPosition().getZ(), new Object[0]);
                event.getDrops().add(itemEntity);
                AttachmentUtils.getAttachment(player).ifPresent(attachment -> {
                    attachment.remove();
                    attachment.synchronise();
                });
            }
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().getType()) && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof TravelersBackpackItem) {
            if (!(event.getSource().getEntity() instanceof Player)) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), event.getEntity().getItemBySlot(EquipmentSlot.CHEST));
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        AttachmentUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        AttachmentUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerRespawnEvent event) {
        AttachmentUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AttachmentUtils.synchronise(player);
            if (player.level().isClientSide) {
                boolean badgeVisibility = (Boolean)TravelersBackpackConfig.CLIENT.showSupporterBadge.get();
                PacketDistributor.sendToServer((CustomPacketPayload)new SupporterBadgePacket.Serverbound(badgeVisibility), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void finalizeSpawnEvent(FinalizeSpawnEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.world.spawnEntitiesWithBackpack.get()).booleanValue() && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).isEmpty() && !event.getEntity().isBaby() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().getType()) && (double)event.getLevel().getRandom().nextFloat() < (Double)TravelersBackpackConfig.SERVER.world.chance.get()) {
            boolean isNether = event.getEntity().getType() == EntityType.PIGLIN || event.getEntity().getType() == EntityType.WITHER_SKELETON;
            RandomSource rand = event.getLevel().getRandom();
            ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.nextIntBetweenInclusive(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).getDefaultInstance() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.nextIntBetweenInclusive(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).getDefaultInstance();
            backpack.set(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.values()[rand.nextIntBetweenInclusive(0, DyeColor.values().length - 1)].getId());
            boolean flag = false;
            if (rand.nextFloat() > 0.5f) {
                backpack.set(ModDataComponents.STARTER_UPGRADES, List.of(ModItems.TANKS_UPGRADE.toStack()));
                flag = true;
            }
            if (rand.nextFloat() > 0.25f) {
                backpack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(rand.nextInt()));
            }
            if (flag) {
                backpack.set(ModDataComponents.RENDER_INFO, (Object)TanksUpgradeItem.writeToRenderData());
            } else {
                backpack.set(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY);
            }
            event.getEntity().setItemSlot(EquipmentSlot.CHEST, backpack);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)entity;
            if (!target.level().isClientSide) {
                AttachmentUtils.getAttachment((Player)target).ifPresent(data -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ClientboundSyncAttachmentPacket(target.getId(), data.getBackpack()), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        if (AttachmentUtils.isWearingBackpack(event.getEntity())) {
            BackpackWrapper.tick(AttachmentUtils.getWearingBackpack(event.getEntity()), event.getEntity(), false);
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, AttachmentUtils.getWearingBackpack(event.getEntity())) && !checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, AttachmentUtils.getWearingBackpack(event.getEntity()))) {
            checkAbilitiesForRemoval = true;
        }
        if (!(!checkAbilitiesForRemoval || event.getEntity().level().isClientSide || AttachmentUtils.isWearingBackpack(event.getEntity()) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue())) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.getEntity());
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (nextSupportersFetch > event.getServer().getTickCount()) {
            return;
        }
        nextSupportersFetch = event.getServer().getTickCount() + 72000;
        Supporters.updateSupporters();
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.slownessDebuff.tooManyBackpacksSlowness.get()).booleanValue() || nextBackpackCountCheck > event.getLevel().getGameTime()) {
            return;
        }
        nextBackpackCountCheck = event.getLevel().getGameTime() + 100L;
        event.getLevel().players().forEach(player -> {
            if (player.isCreative() || player.isSpectator()) {
                return;
            }
            AtomicInteger numberOfBackpacks = NeoForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = (Integer)TravelersBackpackConfig.SERVER.slownessDebuff.maxNumberOfBackpacks.get();
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)TravelersBackpackConfig.SERVER.slownessDebuff.slownessPerExcessedBackpack.get()));
                player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.getInventory().getNonEquipmentItems().size(); ++i) {
            if (!(((ItemStack)player.getInventory().getNonEquipmentItems().get(i)).getItem() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (player.getOffhandItem().getItem() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (((Boolean)TravelersBackpackConfig.COMMON.enableVillagerTrade.get()).booleanValue() && event.getType() == VillagerProfession.LIBRARIAN) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, random.nextInt(64) + 48), new ItemStack((ItemLike)((TravelersBackpackItem)((Object)((Object)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()))).asItem(), 1), 1, 50, 0.5f));
        }
    }

    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemStack remainingStack;
        BackpackWrapper wrapper;
        ItemEntity itemEntity = event.getItemEntity();
        if (itemEntity.getItem().isEmpty() || itemEntity.pickupDelay > 0) {
            return;
        }
        Player player = event.getPlayer();
        Level level = player.level();
        if (AttachmentUtils.isWearingBackpack(player) && (wrapper = AttachmentUtils.getBackpackWrapper(player)).getUpgradeManager().getUpgrade(AutoPickupUpgrade.class).isPresent() && wrapper.getUpgradeManager().getUpgrade(AutoPickupUpgrade.class).get().canPickup(itemEntity.getItem()) && (remainingStack = ItemHandlerHelper.insertItemStacked((IItemHandler)new StorageAccessWrapper(wrapper, wrapper.getStorage()), (ItemStack)itemEntity.getItem(), (boolean)false)) != itemEntity.getItem()) {
            level.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f);
            itemEntity.setItem(remainingStack);
            event.setCanPickup(TriState.FALSE);
        }
    }
}

