/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BackpackSettingsMenu
extends AbstractBackpackMenu {
    private ContainerLevelAccess access;
    private Block backpackBlock;

    public BackpackSettingsMenu(int windowID, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        this(windowID, playerInventory, BackpackSettingsMenu.createWrapper(playerInventory, data));
    }

    public BackpackSettingsMenu(int windowID, Inventory playerInventory, BackpackWrapper wrapper) {
        this((MenuType)ModMenuTypes.BACKPACK_SETTINGS_MENU.get(), windowID, playerInventory, wrapper);
        if (this.wrapper.getScreenID() == 3) {
            this.access = ContainerLevelAccess.create((Level)this.player.level(), (BlockPos)this.getWrapper().getBackpackPos());
            this.backpackBlock = this.player.level().getBlockState(this.getWrapper().getBackpackPos()).getBlock();
            this.wrapper.addUser(this.inventory.player);
        } else {
            this.wrapper.addUser(playerInventory.player);
        }
    }

    public BackpackSettingsMenu(MenuType<?> type, int windowID, Inventory inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void updateSlots() {
        this.lastSlots.clear();
        this.slots.clear();
        this.remoteSlots.clear();
        this.addSlots();
    }

    public void addSlots() {
        this.addBackpackStorageSlots(this.wrapper);
        this.BACKPACK_INV_END = this.slots.size();
        this.PLAYER_INV_START = this.slots.size();
        this.addPlayerInventoryAndHotbar(this.inventory, this.getWrapper().getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.slots.size();
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        if (this.wrapper.getScreenID() == 1) {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    if (x + y * 9 + 9 == currentItemIndex) {
                        this.addSlot(new DisabledSlot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                        this.disabledSlotIndex = this.slots.size() - 1;
                        continue;
                    }
                    this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                if (x == currentItemIndex) {
                    this.addSlot(new DisabledSlot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
                    this.disabledSlotIndex = this.slots.size() - 1;
                    continue;
                }
                this.addSlot(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
            }
        } else {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, 18 + this.wrapper.getRows() * 18 + 14 + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
            }
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return false;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void removed(Player player) {
        BlockEntity blockEntity;
        BlockPos pos;
        if (!player.level().isClientSide && this.getWrapper().getScreenID() == 3 && (pos = this.getWrapper().getBackpackPos()) != null && (blockEntity = player.level().getBlockEntity(pos)) instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            backpackBlockEntity.removeSettingsUser();
        }
        if (player.containerMenu instanceof BackpackSettingsMenu && player.level().isClientSide) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        if (this.getWrapper().getScreenID() == 3) {
            return (Boolean)this.access.evaluate((level, blockPos) -> !level.getBlockState(blockPos).is(this.backpackBlock) ? false : player.canInteractWithBlock(blockPos, 4.0), (Object)true);
        }
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().isAlive() && AttachmentUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        return true;
    }

    private static BackpackWrapper createWrapper(Inventory inventory, RegistryFriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        boolean isBlockEntity = data.readBoolean();
        if (isBlockEntity) {
            return BackpackSettingsMenu.getBlockEntity(inventory, data);
        }
        return BackpackSettingsMenu.getWrapper(inventory, data);
    }

    private static BackpackWrapper getWrapper(Inventory inventory, RegistryFriendlyByteBuf data) {
        ItemStack backpackStack;
        int screenID = data.readInt();
        BlockPos pos = data.readBlockPos();
        int index = data.readInt();
        ItemStack itemStack = backpackStack = index == -1 ? inventory.player.getItemInHand(InteractionHand.MAIN_HAND) : (ItemStack)inventory.getNonEquipmentItems().get(index);
        if (screenID == 2) {
            return AttachmentUtils.getBackpackWrapper(inventory.player);
        }
        return new BackpackWrapper(backpackStack, screenID, (HolderLookup.Provider)data.registryAccess(), inventory.player, inventory.player.level(), index);
    }

    private static BackpackWrapper getBlockEntity(Inventory inventory, RegistryFriendlyByteBuf data) {
        BlockPos pos = data.readBlockPos();
        BlockEntity blockEntityAtPos = inventory.player.level().getBlockEntity(pos);
        if (blockEntityAtPos instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntityAtPos;
            backpackBlockEntity.getWrapper().addUser(inventory.player);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            backpackBlockEntity.setSettingsUser(inventory.player);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + String.valueOf(blockEntityAtPos));
    }
}

