/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class SortType {
    static String getStringForSort(ItemStack stack, Type type) {
        Item item = stack.getItem();
        String itemName = SortType.specialCases(stack);
        return String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item)) + itemName;
    }

    public static String getTabID(int tabID) {
        return tabID < 10 ? "00" + tabID : (tabID < 100 ? "0" + tabID : "999");
    }

    private static String specialCases(ItemStack stack) {
        Item item = stack.getItem();
        if (stack.getCount() != stack.getMaxStackSize()) {
            return SortType.stackSize(stack);
        }
        if (stack.has(DataComponents.DAMAGE)) {
            return SortType.toolDuribilityCase(stack);
        }
        if (stack.has(DataComponents.STORED_ENCHANTMENTS)) {
            SortType.enchantedBookNameCase(stack);
        }
        return item.getDescriptionId();
    }

    private static String stackSize(ItemStack stack) {
        return stack.getItem().toString() + stack.getCount();
    }

    private static String enchantedBookNameCase(ItemStack stack) {
        Set enchants = ((ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)).entrySet();
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (Object2IntMap.Entry e : enchants) {
            names.add(Enchantment.getFullname((Holder)((Holder)e.getKey()), (int)e.getIntValue()).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return String.valueOf(stack.getItem()) + " " + enchants.size() + " " + String.valueOf(enchantNames);
    }

    private static String toolDuribilityCase(ItemStack stack) {
        return stack.getItem().toString() + stack.getDamageValue();
    }

    public static enum Type {
        NAME,
        MOD,
        CATEGORY;

    }
}

